/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim;

import com.google.common.base.Function;
import java.util.Optional;
import javax.annotation.Nullable;
import mcjty.lib.base.ModBase;
import mcjty.lib.proxy.IProxy;
import mcjty.lib.varia.Logging;
import mcjty.rftools.api.teleportation.ITeleportationManager;
import mcjty.rftoolsdim.api.dimension.IDimensionManager;
import mcjty.rftoolsdim.api.dimlet.IDimletConfigurationManager;
import mcjty.rftoolsdim.apiimpl.DimensionManager;
import mcjty.rftoolsdim.apiimpl.DimletConfigurationManager;
import mcjty.rftoolsdim.commands.CommandRftDb;
import mcjty.rftoolsdim.commands.CommandRftDim;
import mcjty.rftoolsdim.dimensions.ModDimensions;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.dimensions.dimlets.DimletRandomizer;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.items.manual.GuiRFToolsManual;
import mcjty.rftoolsdim.setup.ModSetup;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;

@Mod(modid="rftoolsdim", name="RFTools Dimensions", dependencies="required-after:mcjtylib_ng@[3.5.0,);required-after:rftools@[7.58,);after:forge@[14.23.2.2645,)", acceptedMinecraftVersions="[1.12,1.13)", version="5.71")
public class RFToolsDim
implements ModBase {
    public static final String MODID = "rftoolsdim";
    public static final String MIN_RFTOOLS_VER = "7.58";
    public static final String VERSION = "5.71";
    public static final String MIN_FORGE11_VER = "14.23.2.2645";
    public static final String MIN_MCJTYLIB_VER = "3.5.0";
    @SidedProxy(clientSide="mcjty.rftoolsdim.setup.ClientProxy", serverSide="mcjty.rftoolsdim.setup.ServerProxy")
    public static IProxy proxy;
    public static ModSetup setup;
    @Mod.Instance(value="rftoolsdim")
    public static RFToolsDim instance;
    public static ITeleportationManager teleportationManager;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        setup.preInit(e);
        proxy.preInit(e);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        setup.init(e);
        proxy.init(e);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        setup.postInit(e);
        proxy.postInit(e);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandRftDim());
        event.registerServerCommand((ICommand)new CommandRftDb());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        Logging.log((String)"RFTools: server is starting");
        ModDimensions.initDimensions();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        Logging.log((String)"RFTools Dimensions: server is stopping. Shutting down gracefully");
        RfToolsDimensionManager.cleanupDimensionInformation();
        RfToolsDimensionManager.clearInstance();
        KnownDimletConfiguration.init();
        DimletRandomizer.init();
    }

    @Mod.EventHandler
    public void imcCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            String mod;
            Optional value;
            if ("getDimletConfigurationManager".equalsIgnoreCase(message.key)) {
                value = message.getFunctionValue(IDimletConfigurationManager.class, Void.class);
                mod = message.getSender();
                Logging.log((String)("Received RFTools Dimensions dimlet reconfiguration request from mod '" + mod + "'"));
                ((java.util.function.Function)value.get()).apply(new DimletConfigurationManager(mod));
                continue;
            }
            if (!"getDimensionManager".equalsIgnoreCase(message.key)) continue;
            value = message.getFunctionValue(IDimensionManager.class, Void.class);
            mod = message.getSender();
            Logging.log((String)("Received RFTools dimension manager request from mod '" + mod + "'"));
            ((java.util.function.Function)value.get()).apply(new DimensionManager());
        }
    }

    public String getModId() {
        return MODID;
    }

    public void openManual(EntityPlayer player, int bookIndex, String page) {
        GuiRFToolsManual.locatePage = page;
        player.openGui((Object)instance, bookIndex, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }

    static {
        setup = new ModSetup();
    }

    public static class GetTeleportationManager
    implements Function<ITeleportationManager, Void> {
        @Nullable
        public Void apply(ITeleportationManager manager) {
            teleportationManager = manager;
            return null;
        }
    }
}

