/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import mcjty.lib.container.BaseSlot;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotFactory;
import mcjty.lib.container.SlotType;
import mcjty.rftools.blocks.storage.RemoteStorageIdRegistry;
import mcjty.rftools.blocks.storage.RemoteStorageItemInventory;
import mcjty.rftools.blocks.storage.RemoteStorageTileEntity;
import mcjty.rftools.compat.jei.JEIRecipeAcceptor;
import mcjty.rftools.craftinggrid.CraftingGridInventory;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public class RemoteStorageItemContainer
extends GenericContainer {
    public static final String CONTAINER_INVENTORY = "container";
    public static final String CONTAINER_GRID = "grid";
    public static final int MAXSIZE_STORAGE = 300;
    private EntityPlayer entityPlayer;
    private int tabletIndex;
    public static final ContainerFactory factory = new ContainerFactory(){

        protected void setup() {
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_INPUT, new ItemStack[0]), RemoteStorageItemContainer.CONTAINER_INVENTORY, 0, -500, -500, 30, 0, 10, 0);
            this.layoutPlayerInventorySlots(91, 157);
            this.layoutGridInventorySlots(CraftingGridInventory.GRID_XOFFSET, CraftingGridInventory.GRID_YOFFSET);
        }

        protected void layoutGridInventorySlots(int leftCol, int topRow) {
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_GHOST, new ItemStack[0]), RemoteStorageItemContainer.CONTAINER_GRID, CraftingGridInventory.SLOT_GHOSTINPUT, leftCol, topRow, 3, 18, 3, 18);
            this.addSlotRange(new SlotDefinition(SlotType.SLOT_GHOSTOUT, new ItemStack[0]), RemoteStorageItemContainer.CONTAINER_GRID, CraftingGridInventory.SLOT_GHOSTOUTPUT, leftCol, topRow += 58, 1, 18);
        }
    };

    public void clearGrid() {
        IInventory inventory = (IInventory)this.inventories.get(CONTAINER_GRID);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public CraftingGridProvider getCraftingGridProvider() {
        return (CraftingGridProvider)this.getInventory(CONTAINER_INVENTORY);
    }

    public JEIRecipeAcceptor getJEIRecipeAcceptor() {
        return (JEIRecipeAcceptor)this.getInventory(CONTAINER_INVENTORY);
    }

    public RemoteStorageItemContainer(EntityPlayer player) {
        super(factory);
        this.entityPlayer = player;
        if (this.isServer()) {
            int si;
            int maxStacks = 0;
            RemoteStorageTileEntity remoteStorageTileEntity = this.getRemoteStorage();
            if (remoteStorageTileEntity != null && (si = remoteStorageTileEntity.findRemoteIndex(this.getStorageID())) != -1) {
                maxStacks = remoteStorageTileEntity.getMaxStacks(si);
            }
            ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
            stack.func_77978_p().func_74768_a("maxSize", maxStacks);
        }
        RemoteStorageItemInventory inventory = new RemoteStorageItemInventory(player);
        this.addInventory(CONTAINER_INVENTORY, inventory);
        this.addInventory("player", (IInventory)player.field_71071_by);
        this.addInventory(CONTAINER_GRID, inventory.getCraftingGrid().getCraftingGridInventory());
        this.tabletIndex = player.field_71071_by.field_70461_c;
        this.generateSlots();
    }

    private RemoteStorageTileEntity getRemoteStorage() {
        return RemoteStorageIdRegistry.getRemoteStorage(this.entityPlayer.func_130014_f_(), this.getStorageID());
    }

    private int getStorageID() {
        return this.entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77978_p().func_74762_e("id");
    }

    private boolean isServer() {
        return !this.entityPlayer.func_130014_f_().field_72995_K;
    }

    public void generateSlots() {
        for (SlotFactory slotFactory : factory.getSlots()) {
            BaseSlot slot;
            if (CONTAINER_GRID.equals(slotFactory.getInventoryName())) {
                SlotType slotType = slotFactory.getSlotType();
                IInventory inventory = (IInventory)this.inventories.get(slotFactory.getInventoryName());
                int index = slotFactory.getIndex();
                int x = slotFactory.getX();
                int y = slotFactory.getY();
                slot = this.createSlot(slotFactory, inventory, index, x, y, slotType);
            } else {
                slot = slotFactory.getSlotType() == SlotType.SLOT_PLAYERHOTBAR ? (slotFactory.getIndex() == this.tabletIndex ? new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()){

                    public boolean func_82869_a(EntityPlayer player) {
                        return false;
                    }
                } : new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY())) : (slotFactory.getSlotType() == SlotType.SLOT_PLAYERINV ? new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()) : new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()){

                    public boolean func_75214_a(ItemStack stack) {
                        if (RemoteStorageItemContainer.this.isServer()) {
                            RemoteStorageTileEntity storage = RemoteStorageItemContainer.this.getRemoteStorage();
                            int si = -1;
                            if (storage != null) {
                                si = storage.findRemoteIndex(RemoteStorageItemContainer.this.getStorageID());
                            }
                            if (si != -1) {
                                RemoteStorageItemContainer.this.entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77978_p().func_74768_a("maxSize", storage.getMaxStacks(si));
                                return true;
                            }
                            RemoteStorageItemContainer.this.entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77978_p().func_74768_a("maxSize", 0);
                            return false;
                        }
                        int maxSize = RemoteStorageItemContainer.this.entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77978_p().func_74762_e("maxSize");
                        if (this.getSlotIndex() >= maxSize) {
                            return false;
                        }
                        return super.func_75214_a(stack);
                    }
                });
            }
            this.func_75146_a((Slot)slot);
        }
    }
}

