/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.world.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.WorldSavedData;

public class StructureSaveData
extends WorldSavedData {
    public static final String ID = "MysticalWorld-StructureSaveData";
    private Map<ResourceLocation, List<BlockPos>> generatorMap = new HashMap<ResourceLocation, List<BlockPos>>();

    public StructureSaveData(String name) {
        super(name);
    }

    public StructureSaveData() {
        super(ID);
    }

    public List<BlockPos> getGeneratorMap(ResourceLocation location) {
        return this.generatorMap.computeIfAbsent(location, k -> new ArrayList());
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList keyList = nbt.func_150295_c("keyList", 8);
        for (int i = 0; i < keyList.func_74745_c(); ++i) {
            String key = keyList.func_150307_f(i);
            ResourceLocation rl = new ResourceLocation(key);
            NBTTagList positions = nbt.func_150295_c(key, 4);
            List<BlockPos> posList = this.generatorMap.get(rl);
            if (posList == null) {
                posList = new ArrayList<BlockPos>();
                this.generatorMap.put(rl, posList);
            } else {
                posList.clear();
            }
            for (int j = 0; j < positions.func_74745_c(); ++j) {
                long l = ((NBTTagLong)positions.func_179238_g(j)).func_150291_c();
                posList.add(BlockPos.func_177969_a((long)l));
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList stringKeyList = new NBTTagList();
        for (Map.Entry<ResourceLocation, List<BlockPos>> entry : this.generatorMap.entrySet()) {
            ResourceLocation rl = entry.getKey();
            String name = rl.toString();
            stringKeyList.func_74742_a((NBTBase)new NBTTagString(name));
            NBTTagList positions = new NBTTagList();
            for (BlockPos p : entry.getValue()) {
                positions.func_74742_a((NBTBase)new NBTTagLong(p.func_177986_g()));
            }
            compound.func_74782_a(name, (NBTBase)positions);
        }
        compound.func_74782_a("keyList", (NBTBase)stringKeyList);
        return compound;
    }
}

