/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.modifier;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class RecipeModifier {
    public static final String TARGET_ITEM = "item";
    public static final String TARGET_FLUID = "fluid";
    public static final String TARGET_ENERGY = "energy";
    public static final String TARGET_GAS = "gas";
    public static final String TARGET_DURATION = "duration";
    public static final String IO_INPUT = "input";
    public static final String IO_OUTPUT = "output";
    public static final int OPERATION_ADD = 0;
    public static final int OPERATION_MULTIPLY = 1;
    protected final String target;
    protected final MachineComponent.IOType ioTarget;
    protected final float modifier;
    protected final int operation;
    protected final boolean chance;

    public RecipeModifier(String target, MachineComponent.IOType ioTarget, float modifier, int operation, boolean affectsChance) {
        this.target = target;
        this.ioTarget = ioTarget;
        this.modifier = modifier;
        this.operation = operation;
        this.chance = affectsChance;
    }

    public String getTarget() {
        return this.target;
    }

    public MachineComponent.IOType getIOTarget() {
        return this.ioTarget;
    }

    public float getModifier() {
        return this.modifier;
    }

    public boolean affectsChance() {
        return this.chance;
    }

    public int getOperation() {
        return this.operation;
    }

    public static float applyModifiers(RecipeCraftingContext context, ComponentRequirement<?> in, float value, boolean isChance) {
        String target = in.getRequiredComponentType().getRegistryName();
        return RecipeModifier.applyModifiers(context.getModifiers(target), target, in.getActionType(), value, isChance);
    }

    public static float applyModifiers(Collection<RecipeModifier> modifiers, ComponentRequirement<?> in, float value, boolean isChance) {
        return RecipeModifier.applyModifiers(modifiers, in.getRequiredComponentType().getRegistryName(), in.getActionType(), value, isChance);
    }

    public static float applyModifiers(Collection<RecipeModifier> modifiers, String target, MachineComponent.IOType ioType, float value, boolean isChance) {
        List applicable = modifiers.stream().filter(mod -> mod.getTarget().equals(target) && (ioType == null || mod.getIOTarget() == ioType) && mod.affectsChance() == isChance).collect(Collectors.toList());
        float add = 0.0f;
        float mul = 1.0f;
        for (RecipeModifier mod2 : applicable) {
            if (mod2.getOperation() == 0) {
                add += mod2.getModifier();
                continue;
            }
            if (mod2.getOperation() == 1) {
                mul *= mod2.getModifier();
                continue;
            }
            throw new RuntimeException("Unknown modifier operation: " + mod2.getOperation());
        }
        return (value + add) * mul;
    }

    public static class Deserializer
    implements JsonDeserializer<RecipeModifier> {
        public RecipeModifier deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ComponentType type;
            JsonObject part = json.getAsJsonObject();
            if (!(part.has("io") && part.get("io").isJsonPrimitive() && part.getAsJsonPrimitive("io").isString())) {
                throw new JsonParseException("'io' string-tag not found when deserializing recipemodifier!");
            }
            String ioTarget = part.getAsJsonPrimitive("io").getAsString();
            MachineComponent.IOType ioType = MachineComponent.IOType.getByString(ioTarget);
            if (ioType == null) {
                throw new JsonParseException("Unknown machine iotype: " + ioTarget);
            }
            if (!(part.has("target") && part.get("target").isJsonPrimitive() && part.getAsJsonPrimitive("target").isString())) {
                throw new JsonParseException("'target' string-tag not found when deserializing recipemodifier!");
            }
            String target = part.getAsJsonPrimitive("target").getAsString();
            if (!target.equalsIgnoreCase(RecipeModifier.TARGET_DURATION) && (type = ComponentType.Registry.getComponent(target)) == null) {
                throw new JsonParseException("'target' has to be a recipe-component! Unknown component: " + target);
            }
            if (!(part.has("multiplier") && part.get("multiplier").isJsonPrimitive() && part.getAsJsonPrimitive("multiplier").isNumber())) {
                throw new JsonParseException("'multiplier' float-tag not found when deserializing recipemodifier!");
            }
            float multiplier = part.getAsJsonPrimitive("multiplier").getAsFloat();
            if (!(part.has("operation") && part.get("operation").isJsonPrimitive() && part.getAsJsonPrimitive("operation").isNumber())) {
                throw new JsonParseException("'operation' int-tag not found when deserializing recipemodifier!");
            }
            int operation = part.getAsJsonPrimitive("operation").getAsInt();
            if (operation < 0 || operation > 1) {
                throw new JsonParseException("There are currently only operation 0 and 1 available (add and multiply operations)! Found: " + operation);
            }
            boolean affectsChance = false;
            if (part.has("affectChance")) {
                if (!part.get("affectChance").isJsonPrimitive() || !part.getAsJsonPrimitive("affectChance").isBoolean()) {
                    throw new JsonParseException("'affectChance', if defined, needs to be either true or false!");
                }
                affectsChance = part.getAsJsonPrimitive("affectChance").getAsBoolean();
            }
            return new RecipeModifier(target, ioType, multiplier, operation, affectsChance);
        }
    }
}

