/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.adapter;

import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapter;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirements.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.requirements.RequirementItem;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;

public class AdapterMinecraftFurnace
extends RecipeAdapter {
    public AdapterMinecraftFurnace() {
        super(new ResourceLocation("minecraft", "furnace"));
    }

    @Override
    @Nonnull
    public Collection<MachineRecipe> createRecipesFor(ResourceLocation owningMachineName, List<RecipeModifier> modifiers, List<ComponentRequirement<?>> additionalRequirements) {
        Map inputOutputMap = FurnaceRecipes.func_77602_a().func_77599_b();
        ArrayList<MachineRecipe> smeltingRecipes = new ArrayList<MachineRecipe>(inputOutputMap.size());
        int incId = 0;
        for (Map.Entry smelting : inputOutputMap.entrySet()) {
            int inEnergy;
            int outAmount;
            int tickTime = Math.round(Math.max(1.0f, RecipeModifier.applyModifiers(modifiers, "duration", null, 120.0f, false)));
            MachineRecipe recipe = this.createRecipeShell(new ResourceLocation("minecraft", "smelting_recipe_" + incId), owningMachineName, tickTime, 0);
            int inAmount = Math.round(RecipeModifier.applyModifiers(modifiers, "item", MachineComponent.IOType.INPUT, ((ItemStack)smelting.getKey()).func_190916_E(), false));
            if (inAmount > 0) {
                recipe.addRequirement(new RequirementItem(MachineComponent.IOType.INPUT, ItemUtils.copyStackWithSize((ItemStack)smelting.getKey(), inAmount)));
            }
            if ((outAmount = Math.round(RecipeModifier.applyModifiers(modifiers, "item", MachineComponent.IOType.OUTPUT, ((ItemStack)smelting.getKey()).func_190916_E(), false))) > 0) {
                recipe.addRequirement(new RequirementItem(MachineComponent.IOType.OUTPUT, ItemUtils.copyStackWithSize((ItemStack)smelting.getValue(), outAmount)));
            }
            if ((inEnergy = Math.round(RecipeModifier.applyModifiers(modifiers, "energy", MachineComponent.IOType.INPUT, 20.0f, false))) > 0) {
                recipe.addRequirement(new RequirementEnergy(MachineComponent.IOType.INPUT, inEnergy));
            }
            for (ComponentRequirement<?> additionalRequirement : additionalRequirements) {
                recipe.addRequirement(additionalRequirement.deepCopy());
            }
            smeltingRecipes.add(recipe);
            ++incId;
        }
        return smeltingRecipes;
    }
}

