/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.proxy;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import sblectric.lightningcraft.LightningCraft;
import sblectric.lightningcraft.config.LCConfig;
import sblectric.lightningcraft.crafting.LCCraftingManager;
import sblectric.lightningcraft.gui.LCGuiHandler;
import sblectric.lightningcraft.init.LCBlocks;
import sblectric.lightningcraft.init.LCCapabilities;
import sblectric.lightningcraft.init.LCCreativeTabs;
import sblectric.lightningcraft.init.LCDimensions;
import sblectric.lightningcraft.init.LCEntities;
import sblectric.lightningcraft.init.LCEvents;
import sblectric.lightningcraft.init.LCFluids;
import sblectric.lightningcraft.init.LCItems;
import sblectric.lightningcraft.init.LCNetwork;
import sblectric.lightningcraft.init.LCStructures;
import sblectric.lightningcraft.init.LCTileEntities;
import sblectric.lightningcraft.integration.LCModIntegration;
import sblectric.lightningcraft.ref.Log;
import sblectric.lightningcraft.registry.RegistryHelper;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        Log.logger.info("PreInitializing LightningCraft...");
        MinecraftForge.EVENT_BUS.register((Object)new RegistryHelper());
        LCConfig.loadConfig(event.getSuggestedConfigurationFile());
        LCCreativeTabs.mainRegistry();
        LCBlocks.createBlocks();
        LCItems.createItems();
        LCFluids.createFluids();
        LCTileEntities.mainRegistry();
        LCEntities.mainRegistry();
        LCNetwork.mainRegistry();
        LCCapabilities.mainRegistry();
        LCModIntegration.preInit();
    }

    public void onInit(FMLInitializationEvent event) {
        Log.logger.info("Initializing LightningCraft...");
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)LightningCraft.modInstance, (IGuiHandler)new LCGuiHandler());
        LCDimensions.mainRegistry();
        LCStructures.mainRegistry();
        LCEvents.mainRegistry();
        LCCreativeTabs.updateCreativeTabs();
        LCCraftingManager.addSmeltingRecipes();
        LCModIntegration.onInit();
    }

    public void postInit(FMLPostInitializationEvent event) {
        Log.logger.info("PostInitializing LightningCraft...");
        LCModIntegration.postInit();
    }

    public void registerItemModels() {
    }
}

