/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.integration.crafttweaker;

import com.blamejared.mtlib.helpers.InputHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import sblectric.lightningcraft.integration.crafttweaker.LCHelper;
import sblectric.lightningcraft.recipes.LightningInfusionRecipes;
import sblectric.lightningcraft.util.InputsUtils;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.lightningcraft.LightningInfusion")
@ZenRegister
public class LightningInfusion {
    @ZenMethod
    public static void add(IItemStack output, IIngredient catalyst, final int cost, IIngredient[] inputs) {
        final ItemStack out = InputHelper.toStack((IItemStack)output);
        final Object cl = LCHelper.getObject(catalyst);
        final Object[] in = LCHelper.getObjects(inputs);
        if (in.length != 4) {
            CraftTweakerAPI.logError((String)("Lightning-Infusion needs 4 inputs, got " + in.length));
        }
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                LightningInfusionRecipes.instance().addRecipe(out, cost, cl, in);
            }

            public String describe() {
                return null;
            }
        });
    }

    @ZenMethod
    public static void remove(IIngredient output) {
        final Object obj = InputsUtils.getObject(output);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                LightningInfusionRecipes.instance().getRecipeList().removeIf(recipe -> InputsUtils.matchesForRemoval(obj, recipe.getOutput()));
            }

            public String describe() {
                return null;
            }
        });
    }
}

