/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.dimensions.DimensionEntry;
import com.rwtema.extrautils2.dimensions.TeleporterBase;
import com.rwtema.extrautils2.render.IVertexBuffer;
import com.rwtema.extrautils2.tile.TileTeleporter;
import com.rwtema.extrautils2.utils.MCTimer;
import com.rwtema.extrautils2.utils.helpers.BlockStates;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTeleporter
extends XUBlockStatic {
    public static final PropertyEnumSimple<Type> property_type = new PropertyEnumSimple<Type>(Type.class);
    public static final PropertyBool property_unbreakable = PropertyBool.func_177716_a((String)"unbreakable");
    public static EnumMap<Side, WeakHashMap<Entity, TeleportingEntityEntry>> teleportingEntities = new EnumMap(Side.class);

    public BlockTeleporter() {
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
    }

    public static boolean isValid(Entity entityIn) {
        return !entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.func_184222_aU() && !entityIn.field_70128_L && entityIn instanceof EntityPlayer;
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return XUBlockStateCreator.builder(this).addDropProperties(new IProperty[]{property_type}).addWorldProperties(new IProperty[]{property_unbreakable}).build();
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if (((Boolean)blockState.func_177229_b((IProperty)property_unbreakable)).booleanValue()) {
            return -1.0f;
        }
        return super.func_176195_g(blockState, worldIn, pos);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        worldIn.func_175656_a(pos.func_177984_a(), BlockStates.TORCH_UP);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileTeleporter();
    }

    @Override
    public BoxModel getModel(IBlockState state) {
        Type value = (Type)((Object)state.func_177229_b(property_type));
        return BoxModel.newStandardBlock(value.tex);
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        IBlockState state;
        if (BlockTeleporter.isValid(entityIn) && (state = worldIn.func_180495_p(pos)).func_177230_c() == this) {
            Type type = (Type)((Object)state.func_177229_b(property_type));
            if (type.dimension != null || worldIn.field_73011_w.getDimension() != 0) {
                teleportingEntities.computeIfAbsent(worldIn.field_72995_K ? Side.CLIENT : Side.SERVER, p -> new WeakHashMap()).putIfAbsent(entityIn, new TeleportingEntityEntry(type, pos));
            }
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
    }

    @Override
    public void getSubBlocksBase(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < this.xuBlockState.dropmeta2state.length; ++i) {
            if (((Type)((Object)this.xuBlockState.dropmeta2state[i].func_177229_b(BlockTeleporter.property_type))).debug && !ExtraUtils2.deobf) continue;
            list.add(new ItemStack(itemIn, 1, i));
        }
    }

    public static class EventHandler {
        @SubscribeEvent
        public static void clientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                EventHandler.processMap(Side.CLIENT);
            }
        }

        @SubscribeEvent
        public static void worldTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                EventHandler.processMap(Side.SERVER);
            }
        }

        private static void processMap(Side side) {
            WeakHashMap<Entity, TeleportingEntityEntry> map = teleportingEntities.get(side);
            if (map != null) {
                Iterator<Map.Entry<Entity, TeleportingEntityEntry>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    int curDim;
                    World worldObj;
                    Map.Entry<Entity, TeleportingEntityEntry> entry2 = iterator.next();
                    Entity key = entry2.getKey();
                    TeleportingEntityEntry value = entry2.getValue();
                    if (!BlockTeleporter.isValid(key) || key.field_70128_L || (worldObj = key.field_70170_p) == null || !key.func_174813_aQ().func_72314_b(0.2, 0.2, 0.2).func_72326_a(new AxisAlignedBB(value.pos))) {
                        iterator.remove();
                        continue;
                    }
                    IBlockState state = worldObj.func_180495_p(value.pos);
                    if (state.func_177230_c() != XU2Entries.teleporter.value || state.func_177229_b(property_type) != value.type) {
                        iterator.remove();
                        continue;
                    }
                    if (key.field_71088_bW > 0) continue;
                    ++value.time;
                    if (worldObj.field_72995_K || value.time <= 80 + key.func_82145_z()) continue;
                    key.field_71088_bW = key.func_82147_ab() + 80;
                    DimensionEntry dimension = value.type.dimension;
                    int dest = dimension != null ? dimension.id : 0;
                    if (dest == (curDim = worldObj.field_73011_w.getDimension())) {
                        if (curDim != 0) {
                            dest = 0;
                        } else {
                            iterator.remove();
                            continue;
                        }
                    }
                    if (key instanceof EntityPlayerMP) {
                        MinecraftServer mcServer = ((EntityPlayerMP)key).field_71133_b;
                        Teleporter teleporter = dest == 0 ? new TeleporterBase(mcServer.func_71218_a(0), 0, curDim) : dimension.createTeleporter(mcServer.func_71218_a(dest), dest, curDim);
                        mcServer.func_184103_al().transferPlayerToDimension((EntityPlayerMP)key, dest, teleporter);
                    }
                    iterator.remove();
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public static void renderOverlay(TickEvent.RenderTickEvent event) {
            Minecraft mc = Minecraft.func_71410_x();
            WeakHashMap<Entity, TeleportingEntityEntry> map = teleportingEntities.get(Side.CLIENT);
            if (map == null) {
                return;
            }
            TeleportingEntityEntry entry2 = map.get(mc.field_71439_g);
            if (entry2 == null) {
                return;
            }
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            float v = Math.min(((float)entry2.time + MCTimer.renderPartialTickTime) / (float)(80 + mc.field_71439_g.func_82145_z()), 1.0f) * 0.75f;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)v);
            GlStateManager.func_179118_c();
            mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            TextureAtlasSprite sprite = Textures.getSprite(entry2.type.tex);
            GlStateManager.func_179094_E();
            ScaledResolution scaledRes = new ScaledResolution(mc);
            double w = scaledRes.func_78326_a();
            double h = scaledRes.func_78328_b();
            GlStateManager.func_179137_b((double)(w / 2.0), (double)(h / 2.0), (double)0.0);
            GlStateManager.func_179114_b((float)(MCTimer.renderTimer * 4.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            IVertexBuffer vertexbuffer = IVertexBuffer.getVertexBuffer(tessellator);
            vertexbuffer.begin(7, DefaultVertexFormats.field_181707_g);
            double s = Math.max(w, h) * 0.71;
            vertexbuffer.pos(-s, s, -90.0).tex(sprite.func_94209_e(), sprite.func_94210_h()).endVertex();
            vertexbuffer.pos(s, s, -90.0).tex(sprite.func_94212_f(), sprite.func_94210_h()).endVertex();
            vertexbuffer.pos(s, -s, -90.0).tex(sprite.func_94212_f(), sprite.func_94206_g()).endVertex();
            vertexbuffer.pos(-s, -s, -90.0).tex(sprite.func_94209_e(), sprite.func_94206_g()).endVertex();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static class TeleportingEntityEntry {
        @Nonnull
        Type type;
        @Nonnull
        BlockPos pos;
        int time;

        public TeleportingEntityEntry(@Nonnull Type type, @Nonnull BlockPos pos) {
            this.type = type;
            this.pos = pos;
        }
    }

    public static enum Type {
        OVERWORLD(null, false),
        DEEP_DARK(XU2Entries.deep_dark, false),
        SPECIAL_DIM(XU2Entries.specialdim, true);

        @Nullable
        public final DimensionEntry dimension;
        public final String tex;
        public final boolean debug;

        private Type(DimensionEntry dimension, boolean debug) {
            this.dimension = dimension;
            this.debug = debug;
            this.tex = this.name().toLowerCase(Locale.ENGLISH) + "_portal";
        }

        public int getDestinationID() {
            if (this.dimension == null) {
                return 0;
            }
            return this.dimension.id;
        }
    }
}

