/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemPetContract
extends ItemEnderUtilities {
    public ItemPetContract(String name) {
        super(name);
        this.func_77625_d(64);
        this.func_77656_e(0);
        this.func_77627_a(false);
    }

    public String func_77667_c(ItemStack stack) {
        String name = super.func_77658_a();
        return this.isSigned(stack) ? name + "_signed" : name + "_blank";
    }

    public String func_77653_i(ItemStack stack) {
        String name = super.func_77653_i(stack);
        if (this.isSigned(stack)) {
            return name + " - " + this.getTargetName(stack);
        }
        return name;
    }

    private boolean isSigned(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt != null && nbt.func_150297_b("OwnableL", 4) && nbt.func_150297_b("OwnableM", 4) && nbt.func_150297_b("OwnerL", 4) && nbt.func_150297_b("OwnerM", 4);
    }

    private UUID getOwnerUUID(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return new UUID(nbt.func_74763_f("OwnerM"), nbt.func_74763_f("OwnerL"));
    }

    private UUID getSubjectUUID(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return new UUID(nbt.func_74763_f("OwnableM"), nbt.func_74763_f("OwnableL"));
    }

    @Nullable
    private String getTargetName(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            String pre = TextFormatting.WHITE.toString() + TextFormatting.ITALIC.toString();
            String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
            String name = nbt.func_74779_i("CustomName");
            String id = null;
            if (nbt.func_150297_b("EntityString", 8)) {
                id = nbt.func_74779_i("EntityString");
            }
            if (id != null) {
                String translated = I18n.func_135052_a((String)("entity." + id + ".name"), (Object[])new Object[0]);
                if (!id.equals(translated)) {
                    id = translated;
                }
                String string = name = name.length() > 0 ? pre + name + rst + " (" + id + ")" : id;
                if (nbt.func_150297_b("Health", 5)) {
                    name = name + String.format(" (%.1f HP)", Float.valueOf(nbt.func_74760_g("Health")));
                }
            }
            return name;
        }
        return null;
    }

    private void signContract(ItemStack stack, EntityPlayer oldOwner, EntityLivingBase target) {
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, null, true);
        UUID uuidOwner = oldOwner.func_110124_au();
        nbt.func_74772_a("OwnerM", uuidOwner.getMostSignificantBits());
        nbt.func_74772_a("OwnerL", uuidOwner.getLeastSignificantBits());
        UUID uuidTarget = target.func_110124_au();
        nbt.func_74772_a("OwnableM", uuidTarget.getMostSignificantBits());
        nbt.func_74772_a("OwnableL", uuidTarget.getLeastSignificantBits());
        nbt.func_74776_a("Health", target.func_110143_aJ());
        String str = EntityList.func_75621_b((Entity)target);
        if (str != null) {
            nbt.func_74778_a("EntityString", str);
        }
        if (target.func_145818_k_()) {
            nbt.func_74778_a("CustomName", target.func_95999_t());
        }
        oldOwner.func_130014_f_().func_184133_a(null, oldOwner.func_180425_c(), SoundEvents.field_190021_aL, SoundCategory.PLAYERS, 0.5f, 1.0f);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (target instanceof EntityTameable) {
            if (!player.func_130014_f_().field_72995_K) {
                if (this.isSigned(stack)) {
                    UUID targetOwner = ((EntityTameable)target).func_184753_b();
                    UUID signedOwner = this.getOwnerUUID(stack);
                    if (targetOwner != null && targetOwner.equals(signedOwner) && target.func_110124_au().equals(this.getSubjectUUID(stack)) && !player.func_110124_au().equals(signedOwner)) {
                        ((EntityTameable)target).func_70903_f(true);
                        ((EntityTameable)target).func_184754_b(player.func_110124_au());
                        player.func_130014_f_().func_72960_a((Entity)target, (byte)7);
                        stack.func_190918_g(1);
                    }
                } else if (((EntityTameable)target).func_70909_n() && ((EntityTameable)target).func_152114_e((EntityLivingBase)player)) {
                    ItemStack stackSigned = stack.func_77946_l();
                    stackSigned.func_190920_e(1);
                    this.signContract(stackSigned, player, target);
                    if (!player.func_191521_c(stackSigned)) {
                        player.func_71019_a(stackSigned, false);
                    }
                    stack.func_190918_g(1);
                }
            }
            return true;
        }
        return super.func_111207_a(stack, player, target, hand);
    }

    @Override
    protected void addItemOverrides() {
        this.func_185043_a(new ResourceLocation("enderutilities", "signed"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return ItemPetContract.this.isSigned(stack) ? 1.0f : 0.0f;
            }
        });
    }
}

