/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.client.renderer.tileentity;

import fi.dy.masa.enderutilities.config.Configs;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.tileentity.TileEntityBarrel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class TESRBarrel
extends TileEntitySpecialRenderer<TileEntityBarrel> {
    private static final ResourceLocation TEXTURE_LOCK = ReferenceTextures.getResourceLocation("textures/gui/barrel_lock_icon.png");
    private static final ResourceLocation TEXTURE_VOID = ReferenceTextures.getResourceLocation("textures/gui/barrel_void_icon.png");
    private static final float[] MODEL_ROT_SIDE_Y = new float[]{0.0f, 0.0f, 180.0f, 0.0f, 270.0f, 90.0f};
    private static final float[] LABEL_ROT_SIDE_Y = new float[]{0.0f, 0.0f, 0.0f, -180.0f, 90.0f, -90.0f};
    private RenderItem renderItem;
    private Minecraft mc;

    public void render(TileEntityBarrel te, double x, double y, double z, float partialTicks, int destroyStage, float partial) {
        this.mc = Minecraft.func_71410_x();
        BlockPos pos = te.func_174877_v();
        if (this.mc.field_71439_g.func_174818_b(pos) < 900.0) {
            double posZ;
            double posY;
            int lv;
            int lu;
            EnumFacing barrelFront = te.getFacing();
            x += 0.5;
            y += 0.5;
            z += 0.5;
            if (this.mc.field_71439_g.func_174818_b(pos) < 100.0) {
                boolean locked = te.getInventoryBarrel().isSlotLocked(0);
                boolean hasVoid = te.hasVoidUpgrade();
                if (locked || hasVoid) {
                    for (EnumFacing side : te.getLabeledFaces()) {
                        int ambLight = this.func_178459_a().func_175626_b(pos.func_177972_a(side), 0);
                        int lu2 = ambLight % 65536;
                        int lv2 = ambLight / 65536;
                        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)lu2 / 1.0f), (float)((float)lv2 / 1.0f));
                        double posX = x + 0.502 * (double)side.func_82601_c();
                        double posY2 = y + 0.502 * (double)side.func_96559_d();
                        double posZ2 = z + 0.502 * (double)side.func_82599_e();
                        if (locked) {
                            this.renderLockIcon(posX, posY2, posZ2, 0.365, 0.33, side, barrelFront, TEXTURE_LOCK);
                        }
                        if (!hasVoid) continue;
                        this.renderLockIcon(posX, posY2, posZ2, 0.365, -0.5, side, barrelFront, TEXTURE_VOID);
                    }
                }
            }
            if (te.renderStack.func_190926_b()) {
                return;
            }
            boolean fancy = this.mc.field_71474_y.field_74347_j;
            this.renderItem = this.mc.func_175599_af();
            this.mc.field_71474_y.field_74347_j = true;
            for (EnumFacing side : te.getLabeledFaces()) {
                int ambLight = this.func_178459_a().func_175626_b(pos.func_177972_a(side), 0);
                lu = ambLight % 65536;
                lv = ambLight / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)lu / 1.0f), (float)((float)lv / 1.0f));
                double posX = x + 0.502 * (double)side.func_82601_c();
                posY = y + 0.502 * (double)side.func_96559_d();
                posZ = z + 0.502 * (double)side.func_82599_e();
                this.renderStack(te.renderStack, posX, posY, posZ, side, barrelFront);
            }
            if (Configs.barrelRenderFullnessBar) {
                for (EnumFacing side : te.getLabeledFaces()) {
                    int ambLight = this.func_178459_a().func_175626_b(pos.func_177972_a(side), 0);
                    lu = ambLight % 65536;
                    lv = ambLight / 65536;
                    OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)lu / 1.0f), (float)((float)lv / 1.0f));
                    double posX = x + 0.502 * (double)side.func_82601_c();
                    posY = y + 0.502 * (double)side.func_96559_d();
                    posZ = z + 0.502 * (double)side.func_82599_e();
                    this.renderFullnessBar(te.cachedFullness, posX, posY, posZ, side, barrelFront);
                }
            }
            if (this.mc.field_71439_g.func_174818_b(pos) < 100.0) {
                for (EnumFacing side : te.getLabeledFaces()) {
                    int ambLight = this.func_178459_a().func_175626_b(pos.func_177972_a(side), 0);
                    lu = ambLight % 65536;
                    lv = ambLight / 65536;
                    OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)lu / 1.0f), (float)((float)lv / 1.0f));
                    double posX = x + 0.502 * (double)side.func_82601_c();
                    posY = y + 0.502 * (double)side.func_96559_d();
                    posZ = z + 0.502 * (double)side.func_82599_e();
                    this.renderText(te.cachedStackSizeString, posX, posY, posZ, side, barrelFront);
                }
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179085_a((int)0);
            GlStateManager.func_179085_a((int)1);
            GlStateManager.func_179142_g();
            GlStateManager.func_179104_a((int)1032, (int)5634);
            GlStateManager.func_179101_C();
            GlStateManager.func_179133_A();
            GlStateManager.func_179084_k();
            this.mc.field_71474_y.field_74347_j = fancy;
        }
    }

    protected void renderStack(ItemStack stack, double posX, double posY, double posZ, EnumFacing side, EnumFacing barrelFront) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)posX, (double)posY, (double)posZ);
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            GlStateManager.func_179114_b((float)MODEL_ROT_SIDE_Y[barrelFront.func_176745_a()], (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-90.0f * (float)side.func_96559_d()), (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GlStateManager.func_179114_b((float)MODEL_ROT_SIDE_Y[side.func_176745_a()], (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179152_a((float)0.55f, (float)0.55f, (float)1.0f);
        if (this.renderItem.func_175050_a(stack)) {
            GlStateManager.func_179139_a((double)0.0625, (double)-0.0625, (double)1.0E-4);
        } else {
            GlStateManager.func_179139_a((double)0.0625, (double)-0.0625, (double)0.01);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-100.0f);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)2.6f, (float)2.6f, (float)1.0f);
        GlStateManager.func_179114_b((float)171.6f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)84.9f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
        GlStateManager.func_179089_o();
        GlStateManager.func_179091_B();
        GlStateManager.func_179101_C();
        GlStateManager.func_179088_q();
        GlStateManager.func_179136_a((float)-1.0f, (float)-1.0f);
        GlStateManager.func_179123_a();
        GlStateManager.func_179091_B();
        GlStateManager.func_179099_b();
        this.renderItem.func_175042_a(stack, -8, -7);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179113_r();
        GlStateManager.func_179121_F();
    }

    private void renderText(String text, double x, double y, double z, EnumFacing side, EnumFacing barrelFront) {
        FontRenderer fontRenderer = this.mc.field_71466_p;
        int strLenHalved = fontRenderer.func_78256_a(text) / 2;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            GlStateManager.func_179114_b((float)LABEL_ROT_SIDE_Y[barrelFront.func_176745_a()], (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(90.0f * (float)side.func_96559_d()), (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GlStateManager.func_179114_b((float)LABEL_ROT_SIDE_Y[side.func_176745_a()], (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179137_b((double)0.0, (double)0.48, (double)0.0);
        GlStateManager.func_179152_a((float)-0.01f, (float)-0.01f, (float)0.01f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179088_q();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179136_a((float)-1.0f, (float)-20.0f);
        this.func_147498_b().func_78276_b(text, -strLenHalved, 0, -1);
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179113_r();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void renderFullnessBar(float fullness, double x, double y, double z, EnumFacing side, EnumFacing barrelFront) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            GlStateManager.func_179114_b((float)LABEL_ROT_SIDE_Y[barrelFront.func_176745_a()], (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(90.0f * (float)side.func_96559_d()), (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GlStateManager.func_179114_b((float)LABEL_ROT_SIDE_Y[side.func_176745_a()], (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179137_b((double)-0.3, (double)-0.43, (double)-0.001);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        int r_b = 3;
        int g_b = 3;
        int b_b = 32;
        buffer.func_181662_b(0.0, 0.0, 0.0).func_181669_b(r_b, g_b, b_b, 255).func_181675_d();
        buffer.func_181662_b(0.0, 0.08, 0.0).func_181669_b(r_b, g_b, b_b, 255).func_181675_d();
        buffer.func_181662_b(0.6, 0.08, 0.0).func_181669_b(r_b, g_b, b_b, 255).func_181675_d();
        buffer.func_181662_b(0.6, 0.0, 0.0).func_181669_b(r_b, g_b, b_b, 255).func_181675_d();
        int r_f = 32;
        int g_f = 144;
        int b_f = 240;
        float e = fullness * 0.57f;
        buffer.func_181662_b(0.585, 0.065, -0.001).func_181669_b(r_f, g_f, b_f, 255).func_181675_d();
        buffer.func_181662_b(0.585, 0.015, -0.001).func_181669_b(r_f, g_f, b_f, 255).func_181675_d();
        buffer.func_181662_b(0.585 - (double)e, 0.015, -0.001).func_181669_b(r_f, g_f, b_f, 255).func_181675_d();
        buffer.func_181662_b(0.585 - (double)e, 0.065, -0.001).func_181669_b(r_f, g_f, b_f, 255).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void renderLockIcon(double x, double y, double z, double offsetX, double offsetY, EnumFacing side, EnumFacing barrelFront, ResourceLocation texture) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            GlStateManager.func_179114_b((float)LABEL_ROT_SIDE_Y[barrelFront.func_176745_a()], (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(90.0f * (float)side.func_96559_d()), (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GlStateManager.func_179114_b((float)LABEL_ROT_SIDE_Y[side.func_176745_a()], (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)offsetX, (double)offsetY, (double)-0.001);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179140_f();
        this.mc.func_110434_K().func_110577_a(texture);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(0.0, 0.15, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(0.15, 0.15, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(0.15, 0.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }
}

