/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.client.renderer.item;

import fi.dy.masa.enderutilities.config.Configs;
import fi.dy.masa.enderutilities.event.RenderEventHandler;
import fi.dy.masa.enderutilities.item.ItemBuildersWand;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.BlockInfo;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.BlockPosStateDist;
import fi.dy.masa.enderutilities.util.EntityUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class BuildersWandRenderer {
    protected final Minecraft mc = Minecraft.func_71410_x();
    protected final List<BlockPosStateDist> positions = new ArrayList<BlockPosStateDist>();
    protected float partialTicksLast;
    protected BlockPosEU posStartLast;

    public void renderSelectedArea(World world, EntityPlayer usingPlayer, ItemStack stack, EntityPlayer clientPlayer, float partialTicks) {
        BlockPosEU posEnd;
        ItemBuildersWand wand = (ItemBuildersWand)stack.func_77973_b();
        BlockPosEU posStart = wand.getPosition(stack, true);
        ItemBuildersWand.Mode mode = ItemBuildersWand.Mode.getMode(stack);
        if (posStart == null) {
            RayTraceResult rayTraceResult = EntityUtils.getRayTraceFromPlayer(world, usingPlayer, false);
            if (rayTraceResult == null || rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
                return;
            }
            if (usingPlayer.func_70093_af() && rayTraceResult.field_178784_b == EnumFacing.UP && mode != ItemBuildersWand.Mode.REPLACE) {
                return;
            }
            posStart = mode == ItemBuildersWand.Mode.REPLACE ? new BlockPosEU(rayTraceResult.func_178782_a(), usingPlayer.field_71093_bK, rayTraceResult.field_178784_b) : new BlockPosEU(rayTraceResult.func_178782_a().func_177972_a(rayTraceResult.field_178784_b), usingPlayer.field_71093_bK, rayTraceResult.field_178784_b);
        }
        if (posStart == null || usingPlayer.field_71093_bK != posStart.getDimension()) {
            return;
        }
        BlockPosEU blockPosEU = posEnd = mode.isAreaMode() || mode == ItemBuildersWand.Mode.WALLS || mode == ItemBuildersWand.Mode.CUBE ? wand.getPosition(stack, false) : null;
        if (posEnd == null && mode.isAreaMode()) {
            posEnd = wand.getTransformedEndPosition(stack, mode, posStart);
        }
        if (partialTicks < this.partialTicksLast || !posStart.equals(this.posStartLast)) {
            this.positions.clear();
            if (mode == ItemBuildersWand.Mode.CUBE || mode == ItemBuildersWand.Mode.WALLS) {
                wand.getBlockPositionsWalls(stack, world, this.positions, posStart, posEnd);
            } else if (!mode.isAreaMode()) {
                wand.getBlockPositions(stack, world, usingPlayer, this.positions, posStart);
            }
        }
        this.posStartLast = posStart;
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179094_E();
        boolean renderGhostBlocks = ItemBuildersWand.WandOption.RENDER_GHOST.isEnabled(stack, mode);
        if (renderGhostBlocks) {
            this.renderGhostBlocks(clientPlayer, partialTicks);
        }
        GlStateManager.func_179090_x();
        if (!renderGhostBlocks && !mode.isAreaMode()) {
            this.renderBlockOutlines(mode, clientPlayer, posStart, posEnd, partialTicks);
        }
        if (mode == ItemBuildersWand.Mode.STACK) {
            this.renderStackedArea(ItemBuildersWand.Area3D.getAreaFromNBT(wand.getAreaTag(stack)), clientPlayer, posStart, posEnd, partialTicks);
            this.renderStartAndEndPositions(mode, clientPlayer, posStart, posEnd, partialTicks, 34, 255, 34);
        } else {
            this.renderStartAndEndPositions(mode, clientPlayer, posStart, posEnd, partialTicks);
        }
        if (mode == ItemBuildersWand.Mode.MOVE_DST) {
            posStart = wand.getPosition(stack, ItemBuildersWand.Mode.MOVE_SRC, true);
            posEnd = wand.getPosition(stack, ItemBuildersWand.Mode.MOVE_SRC, false);
            this.renderStartAndEndPositions(ItemBuildersWand.Mode.MOVE_SRC, clientPlayer, posStart, posEnd, partialTicks, 255, 85, 85);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)true);
        this.partialTicksLast = partialTicks;
    }

    private void renderBlockOutlines(ItemBuildersWand.Mode mode, EntityPlayer player, BlockPosEU posStart, BlockPosEU posEnd, float partialTicks) {
        GlStateManager.func_187441_d((float)2.0f);
        float expand = mode == ItemBuildersWand.Mode.REPLACE ? 0.001f : 0.0f;
        for (int i = 0; i < this.positions.size(); ++i) {
            BlockPosEU pos = this.positions.get(i);
            if (pos.equals(posStart) || pos.equals(posEnd)) continue;
            AxisAlignedBB aabb = BuildersWandRenderer.createAABB(pos.getX(), pos.getY(), pos.getZ(), expand, partialTicks, player);
            RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderStartAndEndPositions(ItemBuildersWand.Mode mode, EntityPlayer player, BlockPosEU posStart, BlockPosEU posEnd, float partialTicks) {
        this.renderStartAndEndPositions(mode, player, posStart, posEnd, partialTicks, 255, 255, 255);
    }

    private void renderStartAndEndPositions(ItemBuildersWand.Mode mode, EntityPlayer player, BlockPosEU posStart, BlockPosEU posEnd, float partialTicks, int r, int g, int b) {
        AxisAlignedBB aabb;
        float expand;
        if (posStart != null && posEnd != null && mode.isAreaMode()) {
            AxisAlignedBB aabb2 = this.createEnclosingAABB(posStart, posEnd, player, partialTicks);
            RenderGlobal.func_189697_a((AxisAlignedBB)aabb2, (float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)0.8f);
        }
        float f = expand = mode == ItemBuildersWand.Mode.REPLACE || mode == ItemBuildersWand.Mode.REPLACE_3D || mode.hasTwoPlacableCorners() ? 0.001f : 0.0f;
        if (posStart != null) {
            GlStateManager.func_187441_d((float)3.0f);
            aabb = BuildersWandRenderer.createAABB(posStart.getX(), posStart.getY(), posStart.getZ(), expand, partialTicks, player);
            RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)1.0f, (float)0.06666667f, (float)0.06666667f, (float)1.0f);
        }
        if (posEnd != null && (mode.isAreaMode() || mode == ItemBuildersWand.Mode.WALLS || mode == ItemBuildersWand.Mode.CUBE)) {
            GlStateManager.func_187441_d((float)3.0f);
            aabb = BuildersWandRenderer.createAABB(posEnd.getX(), posEnd.getY(), posEnd.getZ(), expand, partialTicks, player);
            RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)0.06666667f, (float)0.06666667f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderGhostBlocks(EntityPlayer player, float partialTicks) {
        int i;
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        if (partialTicks < this.partialTicksLast) {
            for (i = 0; i < this.positions.size(); ++i) {
                BlockPosStateDist pos = this.positions.get(i);
                pos.setSquaredDistance(pos.getSquaredDistanceFrom(dx, dy, dz));
            }
            Collections.sort(this.positions);
            Collections.reverse(this.positions);
        }
        this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (i = 0; i < this.positions.size(); ++i) {
            BlockPosStateDist posEU = this.positions.get(i);
            if (posEU.blockInfo == null || posEU.blockInfo.blockStateActual == null) continue;
            IBlockState stateActual = posEU.blockInfo.blockStateActual;
            BlockPos pos = posEU.toBlockPos();
            GlStateManager.func_179094_E();
            GlStateManager.func_179089_o();
            GlStateManager.func_179126_j();
            GlStateManager.func_179137_b((double)((double)posEU.getX() - dx), (double)((double)posEU.getY() - dy), (double)((double)posEU.getZ() - dz));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!this.mc.field_71441_e.func_175623_d(pos)) {
                GlStateManager.func_179137_b((double)-0.001, (double)-0.001, (double)-0.001);
                GlStateManager.func_179139_a((double)1.002, (double)1.002, (double)1.002);
            }
            if (Configs.buildersWandUseTranslucentGhostBlocks) {
                IBakedModel model = this.mc.func_175602_ab().func_184389_a(stateActual);
                int alpha = (int)(Configs.buildersWandGhostBlockAlpha * 255.0f) << 24;
                GlStateManager.func_179147_l();
                GlStateManager.func_179098_w();
                GlStateManager.func_179112_b((int)770, (int)771);
                GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                this.renderModel(stateActual, model, pos, alpha);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179143_c((int)515);
                this.renderModel(stateActual, model, pos, alpha);
                GlStateManager.func_179084_k();
            } else {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                Minecraft.func_71410_x().func_175602_ab().func_175016_a(stateActual, 0.9f);
            }
            GlStateManager.func_179121_F();
        }
    }

    private void renderStackedArea(ItemBuildersWand.Area3D area, EntityPlayer player, BlockPosEU posStart, BlockPosEU posEnd, float partialTicks) {
        if (posStart == null || posEnd == null) {
            return;
        }
        int xp = area.getXPos();
        int yp = area.getYPos();
        int zp = area.getZPos();
        int xn = area.getXNeg();
        int yn = area.getYNeg();
        int zn = area.getZNeg();
        int sx = Math.abs(posEnd.getX() - posStart.getX()) + 1;
        int sy = Math.abs(posEnd.getY() - posStart.getY()) + 1;
        int sz = Math.abs(posEnd.getZ() - posStart.getZ()) + 1;
        AxisAlignedBB originalBox = this.createEnclosingAABB(posStart, posEnd, player, partialTicks);
        GlStateManager.func_187441_d((float)2.0f);
        if (xp + xn + yp + yn + zp + zn != 0) {
            for (int y = -yn; y <= yp; ++y) {
                for (int x = -xn; x <= xp; ++x) {
                    for (int z = -zn; z <= zp; ++z) {
                        AxisAlignedBB aabb = originalBox.func_72317_d((double)(x * sx), (double)(y * sy), (double)(z * sz));
                        if (x != 0 || y != 0 || z != 0) {
                            RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
                            continue;
                        }
                        RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)0.5f, (float)1.0f, (float)0.5f, (float)0.8f);
                    }
                }
            }
        }
    }

    public void renderHud(EntityPlayer player) {
        ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, EnderUtilitiesItems.BUILDERS_WAND);
        if (!stack.func_190926_b()) {
            ArrayList<String> lines = new ArrayList<String>();
            this.getText(lines, stack, player);
            RenderEventHandler.renderText(lines, 4, 0, RenderEventHandler.HudAlignment.BOTTOM_LEFT, true, true, this.mc);
        }
    }

    private void getText(List<String> lines, ItemStack stack, EntityPlayer player) {
        String str;
        ItemBuildersWand wand = (ItemBuildersWand)stack.func_77973_b();
        ItemBuildersWand.Mode mode = ItemBuildersWand.Mode.getMode(stack);
        String preGreen = TextFormatting.GREEN.toString();
        String preRed = TextFormatting.RED.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
        String preIta = TextFormatting.ITALIC.toString();
        String strNo = I18n.func_135052_a((String)"enderutilities.tooltip.item.no", (Object[])new Object[0]);
        String strYes = I18n.func_135052_a((String)"enderutilities.tooltip.item.yes", (Object[])new Object[0]);
        int index = wand.getSelectionIndex(stack);
        if (mode == ItemBuildersWand.Mode.REPLACE_3D) {
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.build.replacement", (Object[])new Object[0]);
            lines.add(str + String.format(" [%s%d/%d%s]: %s%s", preGreen, index + 1, 16, rst, this.getBlockTypeName(wand, stack, index), rst));
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.build.target", (Object[])new Object[0]);
            index = wand.getSelectionIndex(stack, true);
            lines.add(str + String.format(" [%s%d/%d%s]: %s%s", preGreen, index + 1, 16, rst, this.getBlockTypeName(wand, stack, index, true), rst));
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.build.bindmode", (Object[])new Object[0]);
            if (ItemBuildersWand.WandOption.BIND_MODE.isEnabled(stack, mode)) {
                lines.add(String.format("%s: %s%s%s", str, preGreen, strYes, rst));
            } else {
                lines.add(String.format("%s: %s%s%s", str, preRed, strNo, rst));
            }
        } else if (mode.isAreaMode()) {
            if (mode == ItemBuildersWand.Mode.COPY || mode == ItemBuildersWand.Mode.PASTE) {
                str = I18n.func_135052_a((String)"enderutilities.tooltip.item.template", (Object[])new Object[0]);
                String name = wand.getTemplateName(stack, mode);
                lines.add(String.format("%s [%s%d/%d%s]: %s%s%s", str, preGreen, index + 1, 16, rst, preIta, name, rst));
            } else {
                str = I18n.func_135052_a((String)"enderutilities.tooltip.item.area", (Object[])new Object[0]);
                lines.add(String.format("%s: [%s%d/%d%s]", str, preGreen, index + 1, 16, rst));
            }
            if (mode == ItemBuildersWand.Mode.COPY) {
                str = I18n.func_135052_a((String)"enderutilities.tooltip.item.build.chiselsandbits.crossworld", (Object[])new Object[0]);
                String val = ItemBuildersWand.WandOption.CHISELS_AND_BITS_CROSSWORLD.isEnabled(stack, mode) ? preGreen + strYes : preRed + strNo;
                str = String.format("%s: %s%s", str, val, rst);
            } else {
                String strFacing;
                str = I18n.func_135052_a((String)"enderutilities.tooltip.item.rotation", (Object[])new Object[0]);
                EnumFacing facing = wand.getAreaFacing(stack, mode);
                String string = strFacing = facing != null ? preGreen + facing.toString().toLowerCase() : preRed + "N/A";
                if (wand.isMirrored(stack)) {
                    String mirror = wand.getMirror(stack) == Mirror.FRONT_BACK ? "x" : "z";
                    str = String.format("%s: %s%s - %s: %s%s%s", str, strFacing, rst, I18n.func_135052_a((String)"enderutilities.tooltip.item.mirror", (Object[])new Object[0]), preGreen, mirror, rst);
                } else {
                    str = String.format("%s: %s%s - %s: %s%s%s", str, strFacing, rst, I18n.func_135052_a((String)"enderutilities.tooltip.item.mirror", (Object[])new Object[0]), preRed, strNo, rst);
                }
            }
            lines.add(str);
            if (mode == ItemBuildersWand.Mode.DELETE) {
                str = I18n.func_135052_a((String)"enderutilities.tooltip.item.entities", (Object[])new Object[0]);
                str = str + ": " + (ItemBuildersWand.WandOption.AFFECT_ENTITIES.isEnabled(stack, mode) ? preGreen + strYes : preRed + strNo) + rst;
                lines.add(str);
            } else if (mode == ItemBuildersWand.Mode.PASTE || mode == ItemBuildersWand.Mode.MOVE_DST || mode == ItemBuildersWand.Mode.STACK) {
                str = I18n.func_135052_a((String)"enderutilities.tooltip.item.replace", (Object[])new Object[0]);
                str = str + ": " + (ItemBuildersWand.WandOption.REPLACE_EXISTING.isEnabled(stack, mode) ? preGreen + strYes : preRed + strNo) + rst;
                if (mode != ItemBuildersWand.Mode.MOVE_DST) {
                    str = str + " - " + I18n.func_135052_a((String)"enderutilities.tooltip.item.entities", (Object[])new Object[0]);
                    str = str + ": " + (ItemBuildersWand.WandOption.AFFECT_ENTITIES.isEnabled(stack, mode) ? preGreen + strYes : preRed + strNo) + rst;
                }
                lines.add(str);
            }
        } else {
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.block", (Object[])new Object[0]);
            if (index >= 0) {
                lines.add(str + String.format(" [%s%d/%d%s]: %s%s", preGreen, index + 1, 16, rst, this.getBlockTypeName(wand, stack, index), rst));
            } else {
                lines.add(str + ": " + this.getBlockTypeName(wand, stack, index) + rst);
            }
            if (mode != ItemBuildersWand.Mode.WALLS && mode != ItemBuildersWand.Mode.CUBE) {
                if (mode != ItemBuildersWand.Mode.REPLACE) {
                    str = I18n.func_135052_a((String)"enderutilities.tooltip.item.area.flipped", (Object[])new Object[0]);
                    str = str + ": " + (wand.isAreaFlipped(stack) ? preGreen + wand.getAreaFlipAxis(stack, EnumFacing.UP) : preRed + strNo) + rst;
                    str = str + " - " + I18n.func_135052_a((String)"enderutilities.tooltip.item.move", (Object[])new Object[0]);
                    lines.add(str + ": " + (ItemBuildersWand.WandOption.MOVE_POSITION.isEnabled(stack, mode) ? preGreen + strYes : preRed + strNo) + rst);
                }
                if (mode == ItemBuildersWand.Mode.COLUMN || mode == ItemBuildersWand.Mode.LINE || mode == ItemBuildersWand.Mode.PLANE || mode == ItemBuildersWand.Mode.EXTEND_AREA) {
                    str = I18n.func_135052_a((String)"enderutilities.tooltip.item.continuethrough", (Object[])new Object[0]);
                    str = str + ": " + (ItemBuildersWand.WandOption.CONTINUE_THROUGH.isEnabled(stack, mode) ? preGreen + strYes : preRed + strNo) + rst;
                    str = str + " - " + I18n.func_135052_a((String)"enderutilities.tooltip.item.replace", (Object[])new Object[0]);
                    str = str + ": " + (ItemBuildersWand.WandOption.REPLACE_EXISTING.isEnabled(stack, mode) ? preGreen + strYes : preRed + strNo) + rst;
                    lines.add(str);
                } else if (mode == ItemBuildersWand.Mode.EXTEND_CONTINUOUS || mode == ItemBuildersWand.Mode.REPLACE && ItemBuildersWand.WandOption.REPLACE_MODE_IS_AREA.isEnabled(stack, mode)) {
                    str = I18n.func_135052_a((String)"enderutilities.tooltip.item.builderswand.allowdiagonals", (Object[])new Object[0]);
                    lines.add(str + ": " + (ItemBuildersWand.WandOption.ALLOW_DIAGONALS.isEnabled(stack, mode) ? preGreen + strYes : preRed + strNo) + rst);
                }
            }
        }
        String modeName = mode.getDisplayName();
        if (mode == ItemBuildersWand.Mode.REPLACE) {
            modeName = ItemBuildersWand.WandOption.REPLACE_MODE_IS_AREA.isEnabled(stack, mode) ? modeName + " (" + I18n.func_135052_a((String)"enderutilities.tooltip.item.area", (Object[])new Object[0]) + ")" : modeName + " (" + I18n.func_135052_a((String)"enderutilities.tooltip.item.single", (Object[])new Object[0]) + ")";
        }
        int modeId = mode.ordinal() + 1;
        int maxModeId = ItemBuildersWand.Mode.getModeCount(player);
        str = I18n.func_135052_a((String)"enderutilities.tooltip.item.mode", (Object[])new Object[0]);
        String strMode = String.format("%s [%s%d/%d%s]: %s%s%s", str, preGreen, modeId, maxModeId, rst, preGreen, modeName, rst);
        lines.add(strMode);
    }

    private String getBlockTypeName(ItemBuildersWand wand, ItemStack stack, int index) {
        return this.getBlockTypeName(wand, stack, index, false);
    }

    private String getBlockTypeName(ItemBuildersWand wand, ItemStack stack, int index, boolean secondary) {
        if (index >= 0) {
            ItemStack blockStack;
            BlockInfo blockInfo = wand.getSelectedFixedBlockType(stack, secondary);
            if (blockInfo != null && !(blockStack = new ItemStack(blockInfo.block, 1, blockInfo.itemMeta)).func_190926_b() && blockStack.func_77973_b() != null && blockStack.func_77973_b() != Items.field_190931_a) {
                return TextFormatting.GREEN.toString() + blockStack.func_82833_r();
            }
            return TextFormatting.RED.toString() + "N/A";
        }
        if (index == -1) {
            return TextFormatting.AQUA.toString() + I18n.func_135052_a((String)"enderutilities.tooltip.item.blocktype.targeted", (Object[])new Object[0]);
        }
        return TextFormatting.AQUA.toString() + I18n.func_135052_a((String)"enderutilities.tooltip.item.blocktype.adjacent", (Object[])new Object[0]);
    }

    private AxisAlignedBB createEnclosingAABB(BlockPosEU posStart, BlockPosEU posEnd, EntityPlayer player, float partialTicks) {
        int minX = Math.min(posStart.getX(), posEnd.getX());
        int minY = Math.min(posStart.getY(), posEnd.getY());
        int minZ = Math.min(posStart.getZ(), posEnd.getZ());
        int maxX = Math.max(posStart.getX(), posEnd.getX()) + 1;
        int maxY = Math.max(posStart.getY(), posEnd.getY()) + 1;
        int maxZ = Math.max(posStart.getZ(), posEnd.getZ()) + 1;
        return BuildersWandRenderer.createAABB(minX, minY, minZ, maxX, maxY, maxZ, 0.0, partialTicks, player);
    }

    public static AxisAlignedBB createAABB(int x, int y, int z, double expand, double partialTicks, EntityPlayer player) {
        return BuildersWandRenderer.createAABB(x, y, z, x + 1, y + 1, z + 1, expand, partialTicks, player);
    }

    public static AxisAlignedBB createAABB(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, double expand, double partialTicks, EntityPlayer player) {
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partialTicks;
        return new AxisAlignedBB((double)minX - dx - expand, (double)minY - dy - expand, (double)minZ - dz - expand, (double)maxX - dx + expand, (double)maxY - dy + expand, (double)maxZ - dz + expand);
    }

    private void renderModel(IBlockState state, IBakedModel model, BlockPos pos, int alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing facing : EnumFacing.values()) {
            this.renderQuads(state, pos, buffer, model.func_188616_a(state, facing, 0L), alpha);
        }
        this.renderQuads(state, pos, buffer, model.func_188616_a(state, null, 0L), alpha);
        tessellator.func_78381_a();
    }

    private void renderQuads(IBlockState state, BlockPos pos, BufferBuilder buffer, List<BakedQuad> quads, int alpha) {
        int size = quads.size();
        for (int i = 0; i < size; ++i) {
            BakedQuad quad = quads.get(i);
            int color = quad.func_178211_c() == -1 ? alpha | 0xFFFFFF : this.getTint(state, pos, alpha, quad.func_178211_c());
            LightUtil.renderQuadColor((BufferBuilder)buffer, (BakedQuad)quad, (int)color);
        }
    }

    private int getTint(IBlockState state, BlockPos pos, int alpha, int tintIndex) {
        return alpha | this.mc.func_184125_al().func_186724_a(state, null, pos, tintIndex);
    }
}

