/*
 * Decompiled with CFR 0.152.
 */
package org.btpos.dj2addons.mixin;

import java.util.List;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.Loader;
import org.btpos.dj2addons.core.DJ2AddonsCore;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class DJ2AMixinConfig
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
        DJ2AddonsCore.LOGGER.debug("Loading mixins from " + mixinPackage);
    }

    public String getRefMapperConfig() {
        return Launch.blackboard.get("fml.deobfuscatedEnvironment") == Boolean.TRUE ? null : "mixins.dj2addons.refmap.json";
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String[] split = mixinClassName.split("\\.");
        String simplename = split[split.length - 1];
        if (simplename.equals("MWorld")) {
            try {
                Class<?> c = Class.forName("org.minimallycorrect.tickprofiler.minecraft.CoreMod");
                DJ2AddonsCore.LOGGER.debug(c.getSimpleName() + " detected.");
                DJ2AddonsCore.LOGGER.info("TickProfiler detected! Disabling Aerogel patch.");
                DJ2AddonsCore.onDisableAerogelPatch();
                return false;
            }
            catch (ClassNotFoundException ignore) {
                return true;
            }
        }
        return !simplename.contains("JEI") || Loader.isModLoaded((String)"jei");
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        String output;
        String[] splitName = mixinClassName.split("\\.");
        switch (splitName[splitName.length - 1]) {
            case "MItemBucket": {
                output = "Sprinkling aerogel dust in lava buckets.";
                break;
            }
            case "MEnchanter": {
                output = "Disabling Skyroot bucket mitosis.";
                break;
            }
            case "MTileCelestialCrystals": {
                output = "De-ironing starmetal/crystal interactions.";
                break;
            }
            case "MModRecipes": {
                output = "This server is WAC-secured. [Witch Anti-Cheat]";
                break;
            }
            case "MSoulForge": {
                output = "Giving demons a pep rally.";
                break;
            }
            case "MPowerSystem": {
                output = "Embiggening reactor buffer.";
                break;
            }
            case "MPlantInteractor": {
                output = "Enabling interdimensional access of Crop Things\u2122.";
                break;
            }
            case "MOverlayHandler": {
                output = "Teaching hunger shanks to do The Wave.";
                break;
            }
            case "MInputs": {
                output = "It's Florbin' Time.";
                break;
            }
            case "MTileEssentiaOutput": {
                output = "Sealing those pesky leaks in the modular magical machineries.";
                break;
            }
            case "MModContent": {
                output = "Bass-boosting totemic instruments.";
                break;
            }
            case "MArcanePedestal": {
                output = "Making arcane pedestals bigger (on the inside).";
                break;
            }
            case "MModBrews": {
                output = "Turning rivers into bacon.";
                break;
            }
            default: {
                return;
            }
        }
        DJ2AddonsCore.LOGGER.info(output);
    }
}

