/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.world.gen.tree;

import com.bewitchment.common.block.BlockDragonsBloodLog;
import com.bewitchment.common.world.gen.tree.util.WorldGenModTree;
import com.bewitchment.registry.ModObjects;
import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WorldGenDragonTree
extends WorldGenModTree {
    public WorldGenDragonTree(boolean notify) {
        super(notify);
    }

    @Override
    public boolean canSaplingGrow(World world, BlockPos pos) {
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                for (int y = 0; y < 8; ++y) {
                    BlockPos current = pos.func_177981_b(1).func_177982_a(x, y, z);
                    if (world.func_180495_p(current).func_177230_c().canBeReplacedByLeaves(world.func_180495_p(current), (IBlockAccess)world, current)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean func_180709_b(World world, Random random, BlockPos blockPos) {
        int h = this.generateTrunk(world, ModObjects.dragons_blood_wood.func_176223_P(), blockPos, random, 3, 4);
        if (random.nextDouble() < 0.7) {
            this.generateBottom(world, blockPos);
        }
        int branch = this.generateCrown(world, random, blockPos, h);
        this.generateLeaves(world, blockPos, h, branch);
        return true;
    }

    private void generateBottom(World world, BlockPos pos) {
        for (int i = 0; i < 4; ++i) {
            BlockPos current = pos.func_177972_a(EnumFacing.field_176754_o[i]);
            this.setBlocks(world, current, ModObjects.dragons_blood_wood.func_176194_O().func_177621_b().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE).func_177226_a((IProperty)BlockDragonsBloodLog.SLASHED, (Comparable)Boolean.valueOf(false)));
        }
    }

    private int generateCrown(World world, Random random, BlockPos pos, int height) {
        BlockPos treetop = pos.func_177981_b(height);
        int ymax = random.nextInt(2) + 3;
        for (int y = 0; y < ymax; ++y) {
            for (int i = 0; i < 4; ++i) {
                BlockPos current = treetop.func_177967_a(EnumFacing.field_176754_o[i], y + 1).func_177981_b(y);
                this.setBlocks(world, current, ModObjects.dragons_blood_wood.func_176194_O().func_177621_b().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE).func_177226_a((IProperty)BlockDragonsBloodLog.SLASHED, (Comparable)Boolean.valueOf(false)));
            }
            BlockPos trunk = treetop.func_177981_b(y);
            this.setBlocks(world, trunk, ModObjects.dragons_blood_wood.func_176223_P());
            BlockPos diagonal = treetop.func_177982_a(y, y, y);
            this.setBlocks(world, diagonal, ModObjects.dragons_blood_wood.func_176194_O().func_177621_b().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE).func_177226_a((IProperty)BlockDragonsBloodLog.SLASHED, (Comparable)Boolean.valueOf(false)));
            diagonal = treetop.func_177982_a(y, y, -y);
            this.setBlocks(world, diagonal, ModObjects.dragons_blood_wood.func_176194_O().func_177621_b().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE).func_177226_a((IProperty)BlockDragonsBloodLog.SLASHED, (Comparable)Boolean.valueOf(false)));
            diagonal = treetop.func_177982_a(-y, y, y);
            this.setBlocks(world, diagonal, ModObjects.dragons_blood_wood.func_176194_O().func_177621_b().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE).func_177226_a((IProperty)BlockDragonsBloodLog.SLASHED, (Comparable)Boolean.valueOf(false)));
            diagonal = treetop.func_177982_a(-y, y, -y);
            this.setBlocks(world, diagonal, ModObjects.dragons_blood_wood.func_176194_O().func_177621_b().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE).func_177226_a((IProperty)BlockDragonsBloodLog.SLASHED, (Comparable)Boolean.valueOf(false)));
        }
        return ymax;
    }

    private void generateLeaves(World world, BlockPos pos, int height, int branch) {
        BlockPos treetop = pos.func_177981_b(height);
        for (int h = 1; h < branch + 1; ++h) {
            BlockPos newtop = new BlockPos(treetop.func_177958_n() - h, treetop.func_177956_o() + h, treetop.func_177952_p() - h);
            for (int x = 0; x < 2 * h + 1; ++x) {
                for (int z = 0; z < 2 * h + 1; ++z) {
                    BlockPos current = newtop.func_177982_a(x, 0, z);
                    this.setBlocks(world, current, ModObjects.dragons_blood_leaves.func_176223_P());
                }
            }
        }
        BlockPos toplevel = new BlockPos(treetop.func_177958_n() - branch + 1, treetop.func_177956_o() + branch + 1, treetop.func_177952_p() - branch + 1);
        for (int x = 0; x < 2 * branch - 1; ++x) {
            for (int z = 0; z < 2 * branch - 1; ++z) {
                BlockPos current = toplevel.func_177982_a(x, 0, z);
                this.setBlocks(world, current, ModObjects.dragons_blood_leaves.func_176223_P());
            }
        }
    }

    private void setBlocks(World world, BlockPos pos, IBlockState blockState) {
        if (world.func_180495_p(pos).func_177230_c().canBeReplacedByLeaves(world.func_180495_p(pos), (IBlockAccess)world, pos)) {
            world.func_175656_a(pos, blockState);
        }
    }
}

