/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.ritual;

import com.bewitchment.Util;
import com.bewitchment.api.capability.extendedplayer.ExtendedPlayer;
import com.bewitchment.api.registry.Curse;
import com.bewitchment.api.registry.Ritual;
import com.bewitchment.registry.ModObjects;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class RitualCurseCleansing
extends Ritual {
    private static final List<Ingredient> lesser_input = Arrays.asList(Util.get(ModObjects.white_sage), Util.get(ModObjects.white_sage), Util.get(ModObjects.cleansing_balm), Util.get(ModObjects.dragons_blood_resin), Util.get(ModObjects.dragons_blood_resin), Util.get(ModObjects.birch_soul), Util.get(Items.field_151131_as));
    private static final List<Ingredient> greater_input = Arrays.asList(Util.get(ModObjects.white_sage), Util.get(ModObjects.white_sage), Util.get(ModObjects.cleansing_balm), Util.get(ModObjects.dragons_blood_resin), Util.get(ModObjects.dragons_blood_resin), Util.get(ModObjects.birch_soul), Util.get(Items.field_151131_as), Util.get("cropGarlic"), Util.get("ingotSilver"));
    private final boolean lesser;

    public RitualCurseCleansing(boolean lesser) {
        super(new ResourceLocation("bewitchment", (lesser ? "lesser" : "greater") + "_curse_cleansing"), lesser ? lesser_input : greater_input, null, Collections.singletonList(new ItemStack(Items.field_151133_ar)), 15, lesser ? 500 : 1000, 10, 1, 1, -1);
        this.lesser = lesser;
    }

    @Override
    public void onFinished(World world, BlockPos altarPos, BlockPos effectivePos, EntityPlayer caster, ItemStackHandler inventory) {
        super.onFinished(world, altarPos, effectivePos, caster, inventory);
        if (caster.hasCapability(ExtendedPlayer.CAPABILITY, null)) {
            ExtendedPlayer ep = (ExtendedPlayer)caster.getCapability(ExtendedPlayer.CAPABILITY, null);
            List curses = ep.getCurses().stream().filter(p -> !p.isPositive()).filter(p -> {
                if (this.lesser) {
                    return p.isLesser();
                }
                return true;
            }).collect(Collectors.toList());
            for (Curse curse : curses) {
                double d = caster.func_70681_au().nextDouble();
                double d2 = this.lesser ? 0.6 : 0.9;
                if (!(d < d2)) continue;
                ep.removeCurse(curse);
            }
        }
    }
}

