/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.item.food;

import com.bewitchment.common.integration.dynamictrees.DynamicTreesCompat;
import com.ferreusveritas.dynamictrees.blocks.BlockBonsaiPot;
import com.ferreusveritas.dynamictrees.trees.Species;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

public class ItemFoodSeed
extends ItemFood {
    public ItemFoodSeed(int amount, float saturation, boolean isWolfFood) {
        super(amount, saturation, isWolfFood);
    }

    @Optional.Method(modid="dynamictrees")
    public EnumActionResult onItemUseFlowerPot(EntityPlayer player, World world, BlockPos pos, EnumHand hand, ItemStack seedStack, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Species species;
        IBlockState emptyPotState = world.func_180495_p(pos);
        if (emptyPotState.func_177230_c() instanceof BlockFlowerPot && emptyPotState == emptyPotState.func_177230_c().func_176223_P() && (species = this.getSpecies()) != null) {
            BlockBonsaiPot bonzaiPot = species.getBonzaiPot();
            world.func_175656_a(pos, bonzaiPot.func_176223_P());
            if (bonzaiPot.setSpecies(world, species, pos) && bonzaiPot.setPotState(world, emptyPotState, pos)) {
                seedStack.func_190918_g(1);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    @Optional.Method(modid="dynamictrees")
    public EnumActionResult onItemUsePlantSeed(EntityPlayer player, World world, BlockPos pos, EnumHand hand, ItemStack seedStack, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177977_b();
            facing = EnumFacing.UP;
        }
        if (facing == EnumFacing.UP && player.func_175151_a(pos, facing, seedStack) && player.func_175151_a(pos.func_177984_a(), facing, seedStack) && this.doPlanting(world, pos.func_177984_a())) {
            seedStack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Optional.Method(modid="dynamictrees")
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack seedStack = player.func_184586_b(hand);
        if (this.onItemUseFlowerPot(player, world, pos, hand, seedStack, facing, hitX, hitY, hitZ) == EnumActionResult.SUCCESS) {
            return EnumActionResult.SUCCESS;
        }
        return this.onItemUsePlantSeed(player, world, pos, hand, seedStack, facing, hitX, hitY, hitZ) == EnumActionResult.SUCCESS ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }

    private boolean doPlanting(World world, BlockPos pos) {
        Species species = this.getSpecies();
        if (species != null) {
            return species.plantSapling(world, pos);
        }
        return false;
    }

    private Species getSpecies() {
        if (this.getRegistryName().func_110623_a().contains("juniper")) {
            return DynamicTreesCompat.juniperTree.getCommonSpecies();
        }
        if (this.getRegistryName().func_110623_a().contains("elder")) {
            return DynamicTreesCompat.elderTree.getCommonSpecies();
        }
        return null;
    }
}

