/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.entity.util;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public abstract class ModEntityMob
extends EntityMob {
    public static final DataParameter<Integer> SKIN = EntityDataManager.func_187226_a(ModEntityMob.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> SPECTRAL = EntityDataManager.func_187226_a(ModEntityMob.class, (DataSerializer)DataSerializers.field_187198_h);
    private final ResourceLocation lootTableLocation;
    public int lifeTimeTicks = 0;
    public UUID summoner;

    protected ModEntityMob(World world, ResourceLocation lootTableLocation) {
        super(world);
        this.lootTableLocation = lootTableLocation;
        this.field_70180_af.func_187227_b(SPECTRAL, (Object)false);
    }

    protected int getSkinTypes() {
        return 1;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer player;
            if (((Boolean)this.field_70180_af.func_187225_a(SPECTRAL)).booleanValue()) {
                if (this.lifeTimeTicks <= 0) {
                    ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 20, this.field_70146_Z.nextGaussian() / 3.0, this.field_70146_Z.nextGaussian() / 3.0, this.field_70146_Z.nextGaussian() / 3.0, 0.0, new int[0]);
                    this.func_70106_y();
                } else {
                    --this.lifeTimeTicks;
                }
            }
            if (this.summoner != null && this.field_184629_bo % 60 == 0 && (player = this.field_70170_p.func_152378_a(this.summoner)) != null && (this.func_70638_az() != player.func_94060_bK() && this.func_70638_az() != player.func_110144_aD() || this.func_70638_az() == null)) {
                this.func_70624_b(player.func_94060_bK() == null ? player.func_110144_aD() : player.func_94060_bK());
            }
        }
    }

    protected abstract boolean func_70814_o();

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKIN, (Object)0);
        this.field_70180_af.func_187214_a(SPECTRAL, (Object)false);
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("skin", ((Integer)this.field_70180_af.func_187225_a(SKIN)).intValue());
        tag.func_74757_a("spectral", ((Boolean)this.field_70180_af.func_187225_a(SPECTRAL)).booleanValue());
        tag.func_74768_a("lifeTimeTick", this.lifeTimeTicks);
        tag.func_74778_a("summoner", this.summoner == null ? "" : this.summoner.toString());
        this.field_70180_af.func_187217_b(SKIN);
        this.field_70180_af.func_187217_b(SPECTRAL);
        super.func_70014_b(tag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.field_70180_af.func_187227_b(SKIN, (Object)tag.func_74762_e("skin"));
        this.field_70180_af.func_187227_b(SPECTRAL, (Object)tag.func_74767_n("spectral"));
        this.lifeTimeTicks = tag.func_74762_e("lifeTimeTick");
        this.summoner = tag.func_74779_i("summoner").equals("") ? null : UUID.fromString(tag.func_74779_i("summoner"));
        super.func_70037_a(tag);
    }

    protected ResourceLocation func_184647_J() {
        return this.lootTableLocation;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData data) {
        this.field_70180_af.func_187227_b(SKIN, (Object)this.field_70146_Z.nextInt(this.getSkinTypes()));
        return super.func_180482_a(difficulty, data);
    }
}

