/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.client.render;

import java.util.Collection;
import kotlin.Pair;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class OutlineRenderer {
    public static void renderOutlines(RenderWorldLastEvent evt, EntityPlayer p, Collection<BlockPos> coordinates, int r, int g, int b) {
        double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)evt.getPartialTicks();
        double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)evt.getPartialTicks();
        double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)evt.getPartialTicks();
        GlStateManager.func_179123_a();
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        OutlineRenderer.renderOutlines(coordinates, r, g, b, 4);
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179132_a((boolean)true);
    }

    private static void renderOutlines(Collection<BlockPos> coordinates, int r, int g, int b, int thickness) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        GL11.glLineWidth((float)thickness);
        for (BlockPos coordinate : coordinates) {
            float x = coordinate.func_177958_n();
            float y = coordinate.func_177956_o();
            float z = coordinate.func_177952_p();
            OutlineRenderer.renderHighLightedBlocksOutline(buffer, x, y, z, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
        }
        tessellator.func_78381_a();
    }

    public static void renderHighLightedBlocksOutline(BufferBuilder buffer, float mx, float my, float mz, float r, float g, float b, float a) {
        buffer.func_181662_b((double)mx, (double)my, (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)my, (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)my, (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)my, (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)my, (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)my, (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f)).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void renderOutlinesWithFacing(RenderWorldLastEvent evt, EntityPlayer p, Collection<Pair<BlockPos, EnumFacing>> coordinates, int r, int g, int b) {
        double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)evt.getPartialTicks();
        double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)evt.getPartialTicks();
        double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)evt.getPartialTicks();
        GlStateManager.func_179123_a();
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        OutlineRenderer.renderOutlinesWithFacing(coordinates, -doubleX, -doubleY, -doubleZ, r, g, b, 4);
        GlStateManager.func_179099_b();
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179132_a((boolean)true);
    }

    private static void renderOutlinesWithFacing(Collection<Pair<BlockPos, EnumFacing>> coordinates, double x, double y, double z, int r, int g, int b, int thickness) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        for (Pair<BlockPos, EnumFacing> coordinate : coordinates) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            GL11.glLineWidth((float)thickness);
            BlockPos pos = (BlockPos)coordinate.component1();
            EnumFacing facing = (EnumFacing)coordinate.component2();
            buffer.func_178969_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            OutlineRenderer.renderHighLightedBlocksOutlineForFacing(buffer, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
            buffer.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
            switch (facing) {
                case DOWN: {
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                    break;
                }
                case UP: {
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)270.0, (double)0.0, (double)0.0, (double)1.0);
                    break;
                }
                case NORTH: {
                    GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                    break;
                }
                case SOUTH: {
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    break;
                }
                case EAST: {
                    GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                    break;
                }
            }
            int[] west_matrix = new int[]{1, 0, 0, 0, 1, 0, 0, 0, 1};
            int[] east_matrix = new int[]{-1, 0, 0, 0, 1, 0, 0, 0, 1};
            int[] north_matrix = new int[]{0, 0, -1, 0, 1, 0, 1, 0, 0};
            int[] south_matrix = new int[]{0, 0, 1, 0, 1, 0, -1, 0, 0};
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
            GlStateManager.func_179109_b((float)(-pos.func_177958_n()), (float)(-pos.func_177956_o()), (float)(-pos.func_177952_p()));
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
    }

    public static void renderHighLightedBlocksOutlineForFacing(BufferBuilder buffer, float r, float g, float b, float a) {
        double minX = 0.0;
        double minY = 0.125;
        double minZ = 0.125;
        double maxX = 0.1875;
        double maxY = 0.875;
        double maxZ = 0.875;
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(r, g, b, a).func_181675_d();
    }
}

