/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.client;

import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.network.packet.ClientReplyPacket;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktRequestSeed
implements IMessage,
IMessageHandler<PktRequestSeed, PktRequestSeed>,
ClientReplyPacket {
    private Integer dimId;
    private Integer session;
    private Long seed;

    public PktRequestSeed() {
    }

    public PktRequestSeed(Integer session, Integer dimId) {
        this.dimId = dimId;
        this.session = session;
        this.seed = -1L;
    }

    private PktRequestSeed seed(Long seed) {
        this.seed = seed;
        return this;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimId = buf.readInt();
        this.session = buf.readInt();
        this.seed = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimId.intValue());
        buf.writeInt(this.session.intValue());
        buf.writeLong(this.seed.longValue());
    }

    public PktRequestSeed onMessage(PktRequestSeed message, MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            Long seed;
            try {
                WorldProvider mgr = DimensionManager.getProvider((int)message.dimId);
                seed = new Random(mgr.getSeed()).nextLong();
            }
            catch (Exception exc) {
                World plWorld = ctx.getServerHandler().field_147369_b.field_70170_p;
                if (plWorld.field_73011_w.getDimension() == message.dimId.intValue()) {
                    seed = ctx.getServerHandler().field_147369_b.field_70170_p.func_72905_C();
                    seed = new Random(seed).nextLong();
                }
                return null;
            }
            return new PktRequestSeed(message.session, message.dimId).seed(seed);
        }
        this.updateSeedClient(message.dimId, message.session, message.seed);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSeedClient(int dimId, int session, long seed) {
        Minecraft.func_71410_x().func_152344_a(() -> ConstellationSkyHandler.getInstance().updateSeedCache(dimId, session, seed));
    }
}

