/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightbeam;
import hellfirepvp.astralsorcery.common.block.BlockMarble;
import hellfirepvp.astralsorcery.common.crafting.ISpecialCraftingEffects;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.TileBore;
import hellfirepvp.astralsorcery.common.util.OreDictAlias;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.Random;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LiquidBoreRecipe
extends TraitRecipe
implements ISpecialCraftingEffects {
    public LiquidBoreRecipe() {
        super(ShapedRecipe.Builder.newShapedRecipe("internal/altar/bore_head_liquid", TileBore.BoreType.LIQUID.asStack()).addPart(ItemHandle.getCrystalVariant(false, false), ShapedRecipeSlot.UPPER_CENTER).addPart(BlockMarble.MarbleBlockType.RUNED.asStack(), ShapedRecipeSlot.UPPER_RIGHT, ShapedRecipeSlot.RIGHT, ShapedRecipeSlot.LOWER_RIGHT, ShapedRecipeSlot.UPPER_LEFT, ShapedRecipeSlot.LEFT, ShapedRecipeSlot.LOWER_LEFT).addPart(ItemCraftingComponent.MetaType.RESO_GEM.asStack(), ShapedRecipeSlot.CENTER, ShapedRecipeSlot.LOWER_CENTER).unregisteredAccessibleShapedRecipe());
        this.setCstItem(BlockMarble.MarbleBlockType.RUNED.asStack(), ConstellationRecipe.ConstellationAtlarSlot.UP_UP_LEFT, ConstellationRecipe.ConstellationAtlarSlot.UP_LEFT_LEFT, ConstellationRecipe.ConstellationAtlarSlot.UP_UP_RIGHT, ConstellationRecipe.ConstellationAtlarSlot.UP_RIGHT_RIGHT);
        this.setAttItem(OreDictAlias.ITEM_GOLD_INGOT, AttunementRecipe.AttunementAltarSlot.UPPER_LEFT, AttunementRecipe.AttunementAltarSlot.UPPER_RIGHT);
        this.setInnerTraitItem(OreDictAlias.ITEM_GOLD_INGOT, TraitRecipe.TraitRecipeSlot.LEFT_CENTER, TraitRecipe.TraitRecipeSlot.RIGHT_CENTER);
        this.setInnerTraitItem(BlockMarble.MarbleBlockType.RUNED.asStack(), TraitRecipe.TraitRecipeSlot.UPPER_CENTER);
        this.setInnerTraitItem(ItemCraftingComponent.MetaType.RESO_GEM.asStack(), TraitRecipe.TraitRecipeSlot.LOWER_CENTER);
        this.addOuterTraitItem(ItemCraftingComponent.MetaType.STARDUST.asStack());
        this.addOuterTraitItem(ItemCraftingComponent.MetaType.STARDUST.asStack());
        this.setPassiveStarlightRequirement(4400);
        this.setRequiredConstellation(Constellations.octans);
    }

    @Override
    public AbstractAltarRecipe copyNewEffectInstance() {
        return new LiquidBoreRecipe();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onCraftClientTick(TileAltar altar, ActiveCraftingTask.CraftingState state, long tick, Random rand) {
        super.onCraftClientTick(altar, state, tick, rand);
        if (state == ActiveCraftingTask.CraftingState.ACTIVE && tick % 10L == 0L && rand.nextBoolean()) {
            float height = 5.0f;
            Vector3 position = new Vector3(altar).add(0.5, 0.0, 0.5);
            position.add(rand.nextFloat() * 3.0f * (float)(rand.nextBoolean() ? 1 : -1), 0.0, rand.nextFloat() * 3.0f * (float)(rand.nextBoolean() ? 1 : -1));
            Vector3 target = position.clone().addY(height);
            EffectLightbeam beam = EffectHandler.getInstance().lightbeam(target, position, 0.8f);
            beam.setAlphaMultiplier(1.0f).setMaxAge(20);
            beam.setAlphaFunction(EntityComplexFX.AlphaFunction.FADE_OUT);
            beam.setDistanceCapSq(Config.maxEffectRenderDistanceSq * 5);
            for (int i = 0; i < 170; ++i) {
                float perc = rand.nextFloat();
                Vector3 mot = new Vector3((double)rand.nextFloat() * 0.08 * (double)(rand.nextBoolean() ? 1 : -1) * (double)(1.0f - perc), 0.0, (double)rand.nextFloat() * 0.08 * (double)(rand.nextBoolean() ? 1 : -1) * (double)(1.0f - perc));
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(position.clone().addY(height * perc));
                p.motion(mot.getX(), mot.getY(), mot.getZ()).gravity(0.004);
                p.enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).setAlphaMultiplier(1.0f);
                p.scale(0.2f + rand.nextFloat() * 0.1f).setMaxAge(20);
                if (!rand.nextBoolean()) continue;
                p.setColor(Color.WHITE);
            }
        }
    }
}

