/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.reader;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.PlayerAttributeMap;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeType;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.AttributeReader;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.AttributeReaderRegistry;
import hellfirepvp.astralsorcery.common.constellation.perk.reader.PerkStatistic;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PlayerAttributeInterpreter {
    private Map<String, AttributeReader> attributeReaderOverrides = Maps.newHashMap();
    private PlayerAttributeMap attributeMap;
    private EntityPlayer player;

    private PlayerAttributeInterpreter(PlayerAttributeMap attributeMap, EntityPlayer player) {
        this.attributeMap = attributeMap;
        this.player = player;
    }

    public static PlayerAttributeInterpreter defaultInterpreter(EntityPlayer player) {
        return new Builder(player).build();
    }

    @Nullable
    public PerkStatistic getValue(PerkAttributeType type) {
        return this.getValue(type.getTypeString());
    }

    @Nullable
    public PerkStatistic getValue(String typeString) {
        if (this.attributeReaderOverrides.containsKey(typeString)) {
            return this.attributeReaderOverrides.get(typeString).getStatistics(this.attributeMap, this.player);
        }
        AttributeReader reader = AttributeReaderRegistry.getReader(typeString);
        if (reader != null) {
            return reader.getStatistics(this.attributeMap, this.player);
        }
        return null;
    }

    public static class Builder {
        private PlayerAttributeInterpreter reader;

        private Builder(EntityPlayer player) {
            this.reader = new PlayerAttributeInterpreter(null, player);
        }

        public static Builder newBuilder(EntityPlayer player) {
            return new Builder(player);
        }

        public Builder overrideAttributeMap(PlayerAttributeMap map) {
            this.reader.attributeMap = map;
            return this;
        }

        public Builder overrideReader(String attributeTypeString, AttributeReader reader) {
            this.reader.attributeReaderOverrides.put(attributeTypeString, reader);
            return this;
        }

        public PlayerAttributeInterpreter build() {
            if (this.reader.attributeMap == null) {
                this.reader.attributeMap = PerkAttributeHelper.getOrCreateMap(this.reader.player, Side.CLIENT);
            }
            return this.reader;
        }
    }
}

