/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.network;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.utility.IAgriFluidComponentSyncable;
import com.infinityraider.infinitylib.network.MessageBase;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageSyncFluidAmount
extends MessageBase<IMessage> {
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private int dimId;
    private BlockPos pos;
    private int fluidAmount;

    public MessageSyncFluidAmount() {
        int count = COUNTER.addAndGet(1);
        if (count % 100 == 0) {
            AgriCore.getLogger("agricraft").debug("Created another hundred fluid update packets!", new Object[0]);
        }
    }

    public MessageSyncFluidAmount(World world, BlockPos pos, int fluidAmount) {
        this();
        this.dimId = world.field_73011_w.getDimension();
        this.pos = pos;
        this.fluidAmount = fluidAmount;
    }

    public Side getMessageHandlerSide() {
        return Side.CLIENT;
    }

    protected void processMessage(MessageContext ctx) {
        World world = AgriCraft.proxy.getWorldByDimensionId(this.dimId);
        if (world == null) {
            return;
        }
        IAgriFluidComponentSyncable component = WorldHelper.getTile((IBlockAccess)world, (BlockPos)this.pos, IAgriFluidComponentSyncable.class).orElse(null);
        if (component == null) {
            return;
        }
        component.setFluidAmount(this.fluidAmount);
    }

    protected IMessage getReply(MessageContext ctx) {
        return null;
    }
}

