/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.resource;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import wanion.lib.common.MetaItem;
import wanion.unidict.Config;
import wanion.unidict.UniDict;
import wanion.unidict.UniOreDictionary;
import wanion.unidict.common.SpecificEntryItemStackComparator;
import wanion.unidict.common.SpecificKindItemStackComparator;
import wanion.unidict.common.Util;
import wanion.unidict.plugin.UniDictJEIPlugin;
import wanion.unidict.resource.Resource;
import wanion.unidict.resource.ResourceHandler;
import wanion.unidict.resource.UniResourceHandler;

public final class UniResourceContainer {
    public final String name;
    public final int kind;
    private final int id;
    private final List<ItemStack> entries;
    private final int initialSize;
    private boolean sort = false;
    private boolean updated = false;
    private Item mainEntryItem;
    private int mainEntryMeta;
    private List<ItemStack> originalEntries;

    public UniResourceContainer(@Nonnull String name, int kind) {
        this.name = name;
        this.id = UniOreDictionary.getId(this.name);
        this.entries = UniOreDictionary.get(this.id);
        if (this.entries == null) {
            throw new RuntimeException("Something may have broke the Ore Dictionary!");
        }
        this.originalEntries = new ArrayList<ItemStack>(this.entries);
        this.kind = kind;
        this.initialSize = this.entries.size();
    }

    public UniResourceContainer(@Nonnull String name, int kind, boolean sort) {
        this(name, kind);
        this.setSort(sort);
    }

    public ItemStack getMainEntry() {
        return new ItemStack(this.mainEntryItem, 1, this.mainEntryMeta);
    }

    public ItemStack getMainEntry(int size) {
        return new ItemStack(this.mainEntryItem, size, this.mainEntryMeta);
    }

    public ItemStack getMainEntry(ItemStack itemStack) {
        return new ItemStack(this.mainEntryItem, itemStack.func_190916_E(), this.mainEntryMeta);
    }

    public List<ItemStack> getEntries() {
        return UniOreDictionary.getUn(this.id);
    }

    boolean updateEntries() {
        if (this.entries.isEmpty()) {
            return false;
        }
        if (this.updated) {
            return true;
        }
        ItemStack mainEntry = this.entries.get(0);
        this.mainEntryItem = mainEntry.func_77973_b();
        this.mainEntryMeta = this.mainEntryItem.getDamage(mainEntry);
        if (this.originalEntries.size() != this.entries.size()) {
            this.originalEntries = new ArrayList<ItemStack>(this.entries);
        }
        if (this.sort) {
            if (this.initialSize != this.entries.size()) {
                this.sort();
            }
            Config config = UniDict.getConfig();
            if (config.autoHideInJEI) {
                this.removeBadEntriesFromJEI();
            }
            if (config.keepOneEntry) {
                if (config.keepOneEntryBlackListsAsWhiteLists) {
                    if (config.keepOneEntryEntryBlackSet.contains(this.name) || config.keepOneEntryKindBlackSet.contains(Resource.getNameFromKind(this.kind))) {
                        this.keepOneEntry();
                    }
                } else if (!config.keepOneEntryEntryBlackSet.contains(this.name) && !config.keepOneEntryKindBlackSet.contains(Resource.getNameFromKind(this.kind))) {
                    this.keepOneEntry();
                }
            }
        }
        this.updated = true;
        return true;
    }

    @Nonnull
    int[] getHashes() {
        return MetaItem.getArray(this.originalEntries);
    }

    private void removeBadEntriesFromJEI() {
        if (this.entries.size() <= 1) {
            return;
        }
        if (UniResourceHandler.getEntryJEIBlackSet().contains(this.name)) {
            return;
        }
        if (UniResourceHandler.getKindJEIBlackSet().contains(this.kind)) {
            return;
        }
        Config config = UniDict.getConfig();
        if (config.hideInJEIResourceBlackSet.contains(this.name.replace(Resource.getNameFromKind(this.kind), ""))) {
            return;
        }
        if (config.keepOneEntry && config.keepOneEntryDisableJEIHide && (config.keepOneEntryBlackListsAsWhiteLists ? !config.keepOneEntryEntryBlackSet.contains(this.name) && !config.keepOneEntryKindBlackSet.contains(Resource.getNameFromKind(this.kind)) : config.keepOneEntryEntryBlackSet.contains(this.name) || config.keepOneEntryKindBlackSet.contains(Resource.getNameFromKind(this.kind)))) {
            return;
        }
        this.entries.subList(1, this.entries.size()).forEach(UniDictJEIPlugin::hide);
    }

    private void keepOneEntry() {
        if (this.entries.size() == 1) {
            return;
        }
        Set<ItemStack> keepOneEntryBlackSet = ResourceHandler.keepOneEntryBlackSet;
        if (!keepOneEntryBlackSet.isEmpty()) {
            this.entries.subList(1, this.entries.size()).removeIf(itemStack -> !keepOneEntryBlackSet.contains(itemStack));
        } else {
            this.entries.subList(1, this.entries.size()).clear();
        }
    }

    public Comparator<ItemStack> getComparator() {
        Config config = UniDict.getConfig();
        if (config.enableSpecificEntrySort && SpecificEntryItemStackComparator.hasComparatorForEntry(this.name)) {
            return SpecificEntryItemStackComparator.getComparatorFor(this.name);
        }
        if (config.enableSpecificKindSort && SpecificKindItemStackComparator.hasComparatorForKind(this.kind)) {
            return SpecificKindItemStackComparator.getComparatorFor(this.kind);
        }
        return Util.itemStackComparatorByModName;
    }

    public boolean isSorted() {
        return this.sort;
    }

    void setSort(boolean sort) {
        this.sort = sort;
        if (this.sort) {
            this.sort();
        }
    }

    public void sort() {
        Comparator<ItemStack> itemStackComparator = this.getComparator();
        if (itemStackComparator == null) {
            return;
        }
        this.entries.sort(itemStackComparator);
    }

    public String toString() {
        return this.name;
    }
}

