/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.config;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/Triumph", classExplaination="This file is for basic mod options. If Triumph.txt does not exist, default configs and documentation will be printed.")
public class MainConfig {
    private boolean printDocumenation = true;
    private boolean printDefaultConfigs = true;
    private boolean removeVanillaAdvancements = true;
    private boolean removeModAdvancements = true;
    private String[] keepAdvancements = new String[0];
    private String[] removeAdvancements = new String[0];
    private boolean allowDragging = false;
    private boolean useNewParentCompletionCriteriaNames = false;
    private String[] pageOrder = null;

    @ScriptMethodDocumentation(args="boolean", usage="", notes="Used to set whether Triumph should print config documentation.", defaultValues="true")
    public void printDocumentation(boolean bool) {
        this.printDocumenation = bool;
    }

    @ScriptMethodDocumentation(args="boolean", usage="", notes="Used to set whether Triumph should print default config files. This will replace files. Always backup first!", defaultValues="true")
    public void printDefaultConfigs(boolean bool) {
        this.printDefaultConfigs = bool;
    }

    @ScriptMethodDocumentation(args="boolean", usage="", notes="Used to set whether Triumph should remove vanilla advancements.", defaultValues="true")
    public void removeVanillaAdvancements(boolean bool) {
        this.removeVanillaAdvancements = bool;
    }

    @ScriptMethodDocumentation(args="boolean", usage="", notes="Used to set whether Triumph should remove mod advancements.", defaultValues="true")
    public void removeModAdvancements(boolean bool) {
        this.removeModAdvancements = bool;
    }

    @ScriptMethodDocumentation(args="boolean", usage="", notes="No longer does anything. Simply here to avoid script errors. Will be removed fully in a future update.")
    public void forceReloadFunctions(boolean bool) {
    }

    @ScriptMethodDocumentation(args="String array", usage="", notes="Used to set advancements that should be kept. Can contain both mod ids and advancement ids. If anything is set in this array, everything else will be removed.", defaultValues="true")
    public void keepAdvancements(String[] keep) {
        if (keep.length != 1 || !keep[0].isEmpty()) {
            this.keepAdvancements = keep;
        }
    }

    @ScriptMethodDocumentation(args="String array", usage="", notes="Used to set advancements that should be removed. Can contain both mod ids and advancement ids. If anything is set in this array, everything else will be kept.", defaultValues="true")
    public void removeAdvancements(String[] remove) {
        if (remove.length != 1 || !remove[0].isEmpty()) {
            this.removeAdvancements = remove;
        }
    }

    @ScriptMethodDocumentation(args="boolean", usage="", notes="Sets whether advancements can be dragged around in the gui. End positions will be saved to script files when the mouse button is released, but advancements must be reloaded to refresh positions after the gui is closed.", defaultValues="false")
    public void allowDragging(boolean bool) {
        this.allowDragging = bool;
    }

    @ScriptMethodDocumentation(args="", usage="", notes="Tells the mod to use the new naming scheme for parent completion criteria generated with 'setRequiresParents()', instead of the old one. 'Completed Title' vs 'completedParent1'")
    public void useNewParentCompletionCriteriaNames() {
        this.useNewParentCompletionCriteriaNames = true;
    }

    public boolean shouldPrintDefaultConfigs() {
        return this.printDefaultConfigs;
    }

    public boolean shouldPrintDocumentation() {
        return this.printDocumenation;
    }

    public boolean shouldRemoveVanillaAdvancements() {
        return this.removeVanillaAdvancements;
    }

    public boolean shouldRemoveModAdvancements() {
        return this.removeModAdvancements;
    }

    public String[] getKeepAdvancements() {
        return this.keepAdvancements;
    }

    public String[] getRemoveAdvancements() {
        return this.removeAdvancements;
    }

    public boolean allowDragging() {
        return this.allowDragging;
    }

    public boolean useNewNames() {
        return this.useNewParentCompletionCriteriaNames;
    }

    public String[] getPageOrder() {
        return this.pageOrder;
    }

    @ScriptMethodDocumentation(args="String array", usage="Array of root advancement resource location", notes="Forces an order for advancement pages in the gui. Any not added to this array are ordered alphabetically.")
    public void pageOrder(String[] order) {
        this.pageOrder = order;
    }
}

