/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.Triumph;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.config.data.PotionEffectData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.EffectsChangedTrigger;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/minecraft/effects_changed", classExplaination="These are the functions which can be called on a minecraft:effects_changed criteria trigger.")
public class EffectsChangedTriggerData
extends CriterionTriggerData {
    private final Map<String, PotionEffectData> effectMap = new HashMap<String, PotionEffectData>();

    public EffectsChangedTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() {
        return new Criterion((ICriterionInstance)new EffectsChangedTrigger.Instance(this.buildMobEffectsPredicate()));
    }

    public MobEffectsPredicate buildMobEffectsPredicate() {
        HashMap<Potion, MobEffectsPredicate.InstancePredicate> effects = new HashMap<Potion, MobEffectsPredicate.InstancePredicate>();
        for (Map.Entry<String, PotionEffectData> entry : this.effectMap.entrySet()) {
            Potion potion = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation(entry.getKey()));
            if (potion != null) {
                MobEffectsPredicate.InstancePredicate predicate = entry.getValue().buildPredicate();
                if (predicate != null) {
                    effects.put(potion, predicate);
                    continue;
                }
                Triumph.instance.getLog().info((Object)("Could not build predicate for potion effect " + entry.getKey()));
                continue;
            }
            Triumph.instance.getLog().info((Object)("Unknown potion effect '" + entry.getKey() + "'"));
        }
        return new MobEffectsPredicate(effects);
    }

    @ScriptMethodDocumentation(args="String", usage="potion type", notes="Adds a PotionEffectData for the provided potion type and returns it so functions can be called on it.")
    public PotionEffectData addEffect(String potion) {
        PotionEffectData data = new PotionEffectData();
        this.effectMap.put(potion, data);
        return data;
    }
}

