/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api.lexicon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import pokefenn.totemic.api.lexicon.LexiconCategory;
import pokefenn.totemic.api.lexicon.LexiconPage;

public class LexiconEntry
implements Comparable<LexiconEntry> {
    private final String unlocalizedName;
    private final List<LexiconPage> pages = new ArrayList<LexiconPage>();
    private int sortIndex = 0;
    @Deprecated
    private boolean priority = false;

    public LexiconEntry(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
    }

    public LexiconEntry(String unlocalizedName, LexiconCategory category) {
        this(unlocalizedName);
        category.addEntry(this);
    }

    public LexiconEntry setSortIndex(int index) {
        this.sortIndex = index;
        return this;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    @Deprecated
    public LexiconEntry setPriority() {
        this.priority = true;
        return this;
    }

    @Deprecated
    public boolean isPriority() {
        return this.priority;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public LexiconEntry addPages(LexiconPage ... pages) {
        int firstIndex = this.pages.size();
        this.pages.addAll(Arrays.asList(pages));
        for (int i = firstIndex; i < this.pages.size(); ++i) {
            this.pages.get(i).onPageAdded(this, i);
        }
        return this;
    }

    public void addPage(LexiconPage page) {
        this.pages.add(page);
        page.onPageAdded(this, this.pages.size() - 1);
    }

    public List<LexiconPage> getPages() {
        return this.pages;
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    @Override
    public int compareTo(LexiconEntry o) {
        if (this.priority != o.priority) {
            return this.priority ? -1 : 1;
        }
        if (this.sortIndex != o.sortIndex) {
            return this.sortIndex < o.sortIndex ? -1 : 1;
        }
        return this.getLocalizedName().compareTo(o.getLocalizedName());
    }
}

