/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.world;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.block.property.ITAStoneType;
import thecodex6824.thaumicaugmentation.common.world.ITAChunkGenerator;
import thecodex6824.thaumicaugmentation.common.world.structure.MapGenEldritchSpire;

public class ChunkGeneratorEmptiness
implements ITAChunkGenerator {
    protected World world;
    protected Random rand;
    protected NoiseGeneratorOctaves min;
    protected NoiseGeneratorOctaves max;
    protected NoiseGeneratorOctaves main;
    protected NoiseGeneratorOctaves scale;
    protected NoiseGeneratorOctaves depth;
    protected NoiseGeneratorPerlin gen4;
    protected double[] biomeWeights;
    protected MapGenEldritchSpire spireGenerator;

    public ChunkGeneratorEmptiness(World w) {
        this.world = w;
        this.rand = new Random(this.world.func_72905_C());
        this.min = new NoiseGeneratorOctaves(this.rand, 16);
        this.max = new NoiseGeneratorOctaves(this.rand, 16);
        this.main = new NoiseGeneratorOctaves(this.rand, 8);
        this.scale = new NoiseGeneratorOctaves(this.rand, 10);
        this.depth = new NoiseGeneratorOctaves(this.rand, 16);
        this.gen4 = new NoiseGeneratorPerlin(this.rand, 4);
        this.biomeWeights = new double[25];
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                this.biomeWeights[x + 2 + (z + 2) * 5] = 10.0f / MathHelper.func_76129_c((float)((float)(x * x + z * z) + 0.2f));
            }
        }
        InitNoiseGensEvent.Context ctx = new InitNoiseGensEvent.Context(this.min, this.max, this.main, this.scale, this.depth);
        ctx = TerrainGen.getModdedNoiseGenerators((World)this.world, (Random)this.rand, (InitNoiseGensEvent.Context)ctx);
        this.min = ctx.getLPerlin1();
        this.max = ctx.getLPerlin2();
        this.main = ctx.getPerlin();
        this.scale = ctx.getScale();
        this.depth = ctx.getDepth();
        this.spireGenerator = (MapGenEldritchSpire)TerrainGen.getModdedMapGen((MapGenBase)new MapGenEldritchSpire(this), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CUSTOM);
    }

    protected double[] generateHeights(int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, Biome[] biomes) {
        double[] output = new double[sizeX * sizeY * sizeZ];
        ChunkGeneratorEvent.InitNoiseField noiseEvent = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this, output, posX, posY, posZ, sizeX, sizeY, sizeZ);
        MinecraftForge.EVENT_BUS.post((Event)noiseEvent);
        if (noiseEvent.getResult() == Event.Result.DENY) {
            return noiseEvent.getNoisefield();
        }
        double depthScaleX = 200.0;
        double depthScaleZ = 200.0;
        double coordScale = 684.412;
        double heightScale = 684.412;
        double[] depthNoise = this.depth.func_76305_a(null, posX, posZ, sizeX, sizeZ, depthScaleX, depthScaleZ, 0.5);
        double[] mainNoise = this.main.func_76304_a(null, posX, posY, posZ, sizeX, sizeY, sizeZ, coordScale / 80.0, heightScale / 160.0, coordScale / 80.0);
        double[] minNoise = this.min.func_76304_a(null, posX, posY, posZ, sizeX, sizeY, sizeZ, coordScale, heightScale, coordScale);
        double[] maxNoise = this.max.func_76304_a(null, posX, posY, posZ, sizeX, sizeY, sizeZ, coordScale, heightScale, coordScale);
        int noiseIndex = 0;
        int depthIndex = 0;
        for (int x = 0; x < sizeX; ++x) {
            for (int z = 0; z < sizeZ; ++z) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                Biome biome = biomes[x + 2 + (z + 2) * 10];
                for (int bX = -2; bX <= 2; ++bX) {
                    for (int bZ = -2; bZ <= 2; ++bZ) {
                        Biome biome1 = biomes[x + bX + 2 + (z + bZ + 2) * 10];
                        float f7 = (float)this.biomeWeights[bX + 2 + (bZ + 2) * 5] / (biome1.func_185355_j() + 2.0f);
                        if (biome1.func_185355_j() > biome.func_185355_j()) {
                            f7 /= 2.0f;
                        }
                        f2 += biome1.func_185360_m() * f7;
                        f3 += biome1.func_185355_j() * f7;
                        f4 += f7;
                    }
                }
                f2 /= f4;
                f3 /= f4;
                f2 = f2 * 0.9f + 0.1f;
                f3 = (f3 * 4.0f - 1.0f) / 8.0f;
                int n = depthIndex++;
                double d7 = depthNoise[n] / 8000.0;
                if (d7 < 0.0) {
                    d7 = -d7 * 0.3;
                }
                if ((d7 = d7 * 3.0 - 2.0) < 0.0) {
                    if ((d7 /= 2.0) < -1.0) {
                        d7 = -1.0;
                    }
                    d7 /= 1.4;
                    d7 /= 2.0;
                } else {
                    if (d7 > 1.0) {
                        d7 = 1.0;
                    }
                    d7 /= 8.0;
                }
                double depthBase = 0.5;
                double d8 = ((double)f3 + d7 * 0.2) * (depthBase / 8.0);
                double d9 = f2;
                double d0 = depthBase + d8 * 4.0;
                for (int l1 = 0; l1 < 33; ++l1) {
                    double d1 = ((double)l1 - d0) * 12.0 * 128.0 / 256.0 / d9;
                    if (d1 < 0.0) {
                        d1 *= 4.0;
                    }
                    double d2 = minNoise[noiseIndex] / 512.0;
                    double d3 = maxNoise[noiseIndex] / 512.0;
                    double d4 = (mainNoise[noiseIndex] / 10.0 + 1.0) / 2.0;
                    double d5 = MathHelper.func_151238_b((double)d2, (double)d3, (double)d4) - d1;
                    if (l1 > 29) {
                        double d6 = (float)(l1 - 29) / 3.0f;
                        d5 = d5 * (1.0 - d6) - 10.0 * d6;
                    }
                    output[noiseIndex++] = d5;
                }
            }
        }
        return output;
    }

    @Override
    public void populatePrimerWithHeightmap(int xPos, int zPos, ChunkPrimer primer) {
        Biome[] biomes = this.world.func_72959_q().func_76937_a(null, xPos * 4 - 2, zPos * 4 - 2, 10, 10);
        this.setBlocksInChunk(xPos, zPos, primer, biomes);
    }

    protected void setBlocksInChunk(int xPos, int zPos, ChunkPrimer primer, Biome[] biomes) {
        IBlockState filler = TABlocks.STONE.func_176223_P().func_177226_a(ITAStoneType.STONE_TYPE, (Comparable)((Object)ITAStoneType.StoneType.STONE_VOID));
        int scaleX = 5;
        int scaleY = 33;
        int scaleZ = 5;
        double[] heights = this.generateHeights(xPos * 4, 0, zPos * 4, scaleX, scaleY, scaleZ, biomes);
        for (int i = 0; i < 4; ++i) {
            int j = i * 5;
            int k = (i + 1) * 5;
            for (int l = 0; l < 4; ++l) {
                int i1 = (j + l) * 33;
                int j1 = (j + l + 1) * 33;
                int k1 = (k + l) * 33;
                int l1 = (k + l + 1) * 33;
                for (int i2 = 0; i2 < 32; ++i2) {
                    double d1 = heights[i1 + i2];
                    double d2 = heights[j1 + i2];
                    double d3 = heights[k1 + i2];
                    double d4 = heights[l1 + i2];
                    double d5 = (heights[i1 + i2 + 1] - d1) * 0.125;
                    double d6 = (heights[j1 + i2 + 1] - d2) * 0.125;
                    double d7 = (heights[k1 + i2 + 1] - d3) * 0.125;
                    double d8 = (heights[l1 + i2 + 1] - d4) * 0.125;
                    for (int j2 = 0; j2 < 8; ++j2) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int k2 = 0; k2 < 4; ++k2) {
                            double d16 = (d11 - d10) * 0.25;
                            double lvt_45_1_ = d10 - d16;
                            for (int l2 = 0; l2 < 4; ++l2) {
                                double d;
                                lvt_45_1_ += d16;
                                if (!(d > 0.0) || i2 * 8 + j2 < 0) continue;
                                primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, filler);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    protected void replaceBlocksForBiome(int x, int z, ChunkPrimer primer, Biome[] biomes) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)x, (int)z, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        double[] noise = this.gen4.func_151599_a(null, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int cX = 0; cX < 16; ++cX) {
            for (int cZ = 0; cZ < 16; ++cZ) {
                Biome biome = biomes[cZ + cX * 16];
                biome.func_180622_a(this.world, this.rand, primer, x * 16 + cX, z * 16 + cZ, noise[cZ + cX * 16]);
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer primer = new ChunkPrimer();
        Biome[] biomes = this.world.func_72959_q().func_76937_a(null, x * 4 - 2, z * 4 - 2, 10, 10);
        this.setBlocksInChunk(x, z, primer, biomes);
        biomes = this.world.func_72959_q().func_76933_b(biomes, x * 16, z * 16, 16, 16);
        this.replaceBlocksForBiome(x, z, primer, biomes);
        if (this.world.func_72912_H().func_76089_r() && TAConfig.generateSpires.getValue().booleanValue()) {
            this.spireGenerator.func_186125_a(this.world, x, z, primer);
        }
        Chunk chunk = new Chunk(this.world, primer, x, z);
        for (int i = 0; i < chunk.func_76605_m().length; ++i) {
            chunk.func_76605_m()[i] = (byte)Biome.func_185362_a((Biome)biomes[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        BlockPos pos = new BlockPos(x * 16, 0, z * 16);
        Biome biome = this.world.func_180494_b(pos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long xSeed = this.rand.nextLong() + 1L;
        long zSeed = this.rand.nextLong() + 1L;
        this.rand.setSeed((long)x * xSeed + (long)z * zSeed ^ this.world.func_72905_C());
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false);
        if (this.world.func_72912_H().func_76089_r() && TAConfig.generateSpires.getValue().booleanValue()) {
            this.spireGenerator.func_175794_a(this.world, this.rand, new ChunkPos(x, z));
            this.world.func_72964_e(x, z).func_76613_n();
        }
        biome.func_180624_a(this.world, this.rand, pos);
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        if (this.world.func_72912_H().func_76089_r() && TAConfig.generateSpires.getValue().booleanValue() && this.spireGenerator.func_143025_a().equals(structureName)) {
            return this.spireGenerator.func_180706_b(worldIn, position, findUnexplored);
        }
        return null;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        if (this.world.func_72912_H().func_76089_r() && TAConfig.generateSpires.getValue().booleanValue() && this.spireGenerator.func_175795_b(pos)) {
            return this.spireGenerator.getSpawnableCreatures(creatureType, pos);
        }
        return this.world.func_180494_b(pos).func_76747_a(creatureType);
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        if (this.world.func_72912_H().func_76089_r() && TAConfig.generateSpires.getValue().booleanValue() && this.spireGenerator != null && this.spireGenerator.func_143025_a().equals(structureName)) {
            return this.spireGenerator.func_175795_b(pos);
        }
        return false;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        if (this.world.func_72912_H().func_76089_r() && TAConfig.generateSpires.getValue().booleanValue()) {
            this.spireGenerator.func_186125_a(this.world, x, z, null);
        }
    }

    @Nullable
    public MapGenEldritchSpire.Start getSpireStart(BlockPos pos) {
        return (MapGenEldritchSpire.Start)this.spireGenerator.func_175797_c(pos);
    }
}

