/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.common.entities.EntityFluxRift;
import thecodex6824.thaumicaugmentation.api.entity.IDimensionalFracture;

public class TileRiftMonitor
extends TileEntity
implements ITickable {
    protected boolean mode;
    protected int ticks;
    protected int lastResult = -1;
    protected WeakReference<Entity> target = new WeakReference<Object>(null);
    protected UUID serverTargetID;
    protected int clientTargetID = -1;

    public TileRiftMonitor() {
        this.ticks = ThreadLocalRandom.current().nextInt(20);
    }

    @Nullable
    public Entity getTarget() {
        return (Entity)this.target.get();
    }

    public void cycleTarget() {
        List entities = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(12.0), entity -> entity instanceof EntityFluxRift || entity instanceof IDimensionalFracture);
        entities.sort((e1, e2) -> Double.compare(e1.func_174818_b(this.field_174879_c), e2.func_174818_b(this.field_174879_c)));
        if (!entities.isEmpty()) {
            if (this.target.get() == null || ((Entity)this.target.get()).field_70128_L) {
                this.target = new WeakReference(entities.get(0));
                this.serverTargetID = ((Entity)entities.get(0)).getPersistentID();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                this.func_70296_d();
            } else {
                boolean found = false;
                for (Entity e : entities) {
                    if (!e.equals(this.target.get())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.target = new WeakReference(entities.get(0));
                    this.serverTargetID = ((Entity)entities.get(0)).getPersistentID();
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                    this.func_70296_d();
                }
            }
        }
    }

    public void cycleMode() {
        this.mode = !this.mode;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.func_70296_d();
    }

    public void setMode(boolean newMode) {
        this.mode = newMode;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.func_70296_d();
    }

    public boolean getMode() {
        return this.mode;
    }

    public int getComparatorOutput() {
        Entity entity = (Entity)this.target.get();
        if (entity instanceof EntityFluxRift) {
            double ratio = 0.0;
            ratio = this.mode ? ((double)((EntityFluxRift)entity).getRiftStability() + 100.0) / 200.0 : Math.min((double)((EntityFluxRift)entity).getRiftSize() / 200.0, 200.0);
            return (int)(Math.floor(ratio * 14.0) + Math.signum(ratio));
        }
        return 0;
    }

    protected void loadTargetFromID() {
        if (!this.field_145850_b.field_72995_K) {
            List list = this.field_145850_b.func_175644_a(Entity.class, e -> e != null && e.getPersistentID().equals(this.serverTargetID));
            if (!list.isEmpty()) {
                this.target = new WeakReference(list.get(0));
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            }
        } else {
            Entity e2 = this.field_145850_b.func_73045_a(this.clientTargetID);
            if (e2 != null) {
                this.target = new WeakReference<Entity>(e2);
                this.clientTargetID = -1;
            }
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticks++ % 20 == 0 && (this.target.get() == null || ((Entity)this.target.get()).field_70128_L)) {
                if (this.serverTargetID != null) {
                    this.loadTargetFromID();
                }
                if (this.target.get() == null || ((Entity)this.target.get()).field_70128_L) {
                    this.cycleTarget();
                }
            }
            if (this.target.get() != null) {
                int level;
                if (((Entity)this.target.get()).field_70128_L) {
                    this.target.clear();
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                    this.func_70296_d();
                }
                if ((level = this.getComparatorOutput()) != this.lastResult) {
                    this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
                    this.lastResult = level;
                }
            } else if (this.lastResult != 0) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
                this.lastResult = 0;
            }
        } else if (this.field_145850_b.field_72995_K && this.clientTargetID != -1) {
            this.loadTargetFromID();
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_72321_a(0.0, 1.0, 0.0);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("mode", this.mode);
        Entity e = (Entity)this.target.get();
        compound.func_74768_a("targetID", e != null ? e.func_145782_y() : -1);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.mode = pkt.func_148857_g().func_74767_n("mode");
        this.clientTargetID = pkt.func_148857_g().func_74762_e("targetID");
        if (this.clientTargetID != -1) {
            this.loadTargetFromID();
        } else {
            this.target.clear();
        }
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c.func_177984_a());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        compound.func_74757_a("mode", this.mode);
        Entity e = (Entity)this.target.get();
        compound.func_74768_a("targetID", e != null ? e.func_145782_y() : -1);
        return compound;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.clientTargetID = tag.func_74762_e("targetID");
        if (this.clientTargetID != -1) {
            this.loadTargetFromID();
        } else {
            this.target.clear();
        }
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c.func_177984_a());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("mode", this.mode);
        if (this.serverTargetID != null) {
            compound.func_186854_a("target", this.serverTargetID);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.mode = compound.func_74767_n("mode");
        this.serverTargetID = compound.func_186857_a("target");
    }
}

