/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import java.util.Deque;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.block.property.IDirectionalBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IEnabledBlock;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.NodeHelper;
import thecodex6824.thaumicaugmentation.api.impetus.node.prefab.ImpetusNode;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;

public class TileImpetusGate
extends TileEntity
implements ITickable {
    protected static final Vec3d OFFSET = new Vec3d(0.0, 0.2, 0.0);
    protected ImpetusNode node = new ImpetusNode(1, 1){

        @Override
        public long onTransaction(Deque<IImpetusNode> path, long energy, boolean simulate) {
            return (Boolean)TileImpetusGate.this.field_145850_b.func_180495_p(TileImpetusGate.this.field_174879_c).func_177229_b((IProperty)IEnabledBlock.ENABLED) == false ? 0L : energy;
        }

        @Override
        public Vec3d getBeamEndpoint() {
            Vec3d position = new Vec3d((double)TileImpetusGate.this.field_174879_c.func_177958_n(), (double)TileImpetusGate.this.field_174879_c.func_177956_o(), (double)TileImpetusGate.this.field_174879_c.func_177952_p());
            IBlockState state = TileImpetusGate.this.field_145850_b.func_180495_p(TileImpetusGate.this.field_174879_c);
            if (state.func_177227_a().contains(IDirectionalBlock.DIRECTION)) {
                switch ((EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION)) {
                    case DOWN: {
                        return position.func_72441_c(0.5, 0.5625, 0.5);
                    }
                    case EAST: {
                        return position.func_72441_c(0.4375, 0.5, 0.5);
                    }
                    case NORTH: {
                        return position.func_72441_c(0.5, 0.5, 0.5625);
                    }
                    case SOUTH: {
                        return position.func_72441_c(0.5, 0.5, 0.4375);
                    }
                    case WEST: {
                        return position.func_72441_c(0.5625, 0.5, 0.5);
                    }
                }
                return position.func_72441_c(0.5, 0.4375, 0.5);
            }
            return position.func_72441_c(0.5, 0.4375, 0.5);
        }
    };
    protected int ticks = ThreadLocalRandom.current().nextInt(20);

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.ticks++ % 20 == 0) {
            NodeHelper.validateOutputs(this.field_145850_b, this.node);
        }
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        if (this.field_145850_b != null) {
            this.node.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
        }
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.node.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
    }

    public void onLoad() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == TABlocks.IMPETUS_GATE) {
            state.func_177230_c().func_176213_c(this.field_145850_b, this.field_174879_c, state);
        }
        this.node.init(this.field_145850_b);
        ThaumicAugmentation.proxy.registerRenderableImpetusNode(this.node);
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            NodeHelper.syncDestroyedImpetusNode(this.node);
        }
        this.node.destroy();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.node);
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.node.unload();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode(this.node);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74782_a("node", (NBTBase)this.node.serializeNBT());
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.node.init(this.field_145850_b);
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("node", (NBTBase)this.node.serializeNBT());
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.node.deserializeNBT(nbt.func_74775_l("node"));
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE) {
            return (T)CapabilityImpetusNode.IMPETUS_NODE.cast((Object)this.node);
        }
        return (T)super.getCapability(capability, facing);
    }
}

