/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.integration;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.common.integration.IIntegrationHolder;
import thecodex6824.thaumicaugmentation.common.integration.IntegrationAuraControl;
import thecodex6824.thaumicaugmentation.common.integration.IntegrationBotania;
import thecodex6824.thaumicaugmentation.common.integration.IntegrationEBWizardry;
import thecodex6824.thaumicaugmentation.common.integration.IntegrationJEID;

public class IntegrationHandler {
    public static final String JEID_MOD_ID = "jeid";
    public static final String BOTANIA_MOD_ID = "botania";
    public static final String AURACONTROL_MOD_ID = "auracontrol";
    public static final String EB_WIZARDRY_MOD_ID = "ebwizardry";
    public static final ComparableVersion EB_WIZARDRY_MIN_VERSION = new ComparableVersion("4.2.0");
    private static HashMap<String, IIntegrationHolder> integrations = new HashMap();

    public static void preInit() {
        String version;
        if (Loader.isModLoaded((String)JEID_MOD_ID)) {
            integrations.put(JEID_MOD_ID, new IntegrationJEID());
        }
        if (Loader.isModLoaded((String)BOTANIA_MOD_ID)) {
            integrations.put(BOTANIA_MOD_ID, new IntegrationBotania());
        }
        if (Loader.isModLoaded((String)AURACONTROL_MOD_ID)) {
            integrations.put(AURACONTROL_MOD_ID, new IntegrationAuraControl());
        }
        if (Loader.isModLoaded((String)EB_WIZARDRY_MOD_ID) && new ComparableVersion(version = ((ModContainer)Loader.instance().getIndexedModList().get(EB_WIZARDRY_MOD_ID)).getVersion()).compareTo(EB_WIZARDRY_MIN_VERSION) >= 0) {
            integrations.put(EB_WIZARDRY_MOD_ID, new IntegrationEBWizardry());
        }
        for (IIntegrationHolder holder : integrations.values()) {
            if (holder.registerEventBus()) {
                MinecraftForge.EVENT_BUS.register((Object)holder);
            }
            holder.preInit();
        }
    }

    public static void init() {
        for (IIntegrationHolder holder : integrations.values()) {
            holder.init();
        }
    }

    public static void postInit() {
        ThaumicAugmentation.getLogger().info("The following mods were detected and have integration enabled:");
        for (Map.Entry<String, IIntegrationHolder> entry : integrations.entrySet()) {
            entry.getValue().postInit();
            ThaumicAugmentation.getLogger().info(entry.getKey());
        }
    }

    public static boolean isIntegrationPresent(String modid) {
        return integrations.containsKey(modid);
    }

    @Nullable
    public static IIntegrationHolder getIntegration(String modid) {
        return integrations.get(modid);
    }
}

