/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.utils.charging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import tk.zeitheron.solarflux.utils.charging.AbstractCharge;
import tk.zeitheron.solarflux.utils.charging.IChargeHandler;
import tk.zeitheron.solarflux.utils.charging.IPlayerInventoryLister;
import tk.zeitheron.solarflux.utils.charging.VanillaPlayerInvLister;
import tk.zeitheron.solarflux.utils.charging.fe.FECharge;
import tk.zeitheron.solarflux.utils.charging.fe.FEChargeHandler;

public class ItemChargeHelper {
    private static final Map<Class<? extends AbstractCharge>, IChargeHandler> CHARGE_HANDLERS = new HashMap<Class<? extends AbstractCharge>, IChargeHandler>();
    private static final Map<String, IChargeHandler> CHARGE_HANDLERS_BY_ID = new HashMap<String, IChargeHandler>();
    public static final List<IPlayerInventoryLister> playerInvListers = new ArrayList<IPlayerInventoryLister>();
    private static final Predicate<Integer> I_TRUE;

    public static <T extends AbstractCharge> void handle(Class<T> chargeType, IChargeHandler<T> handler) {
        CHARGE_HANDLERS.put(chargeType, handler);
        CHARGE_HANDLERS_BY_ID.put(handler.getId(), handler);
    }

    public static <T extends AbstractCharge> IChargeHandler<T> getHandler(String id) {
        return CHARGE_HANDLERS_BY_ID.get(id);
    }

    public static <T extends AbstractCharge> IChargeHandler<T> getHandler(T charge) {
        return CHARGE_HANDLERS.get(charge.getClass());
    }

    public static <T extends AbstractCharge> T charge(ItemStack stack, T charge, boolean simulate) {
        IChargeHandler<T> h = ItemChargeHelper.getHandler(charge);
        if (h == null) {
            return charge;
        }
        return h.charge(stack, charge, simulate);
    }

    public static <T extends AbstractCharge> T chargeInventory(IInventory inv, T charge, boolean simulate) {
        return ItemChargeHelper.chargeInventory(inv, I_TRUE, charge, simulate);
    }

    public static <T extends AbstractCharge> T chargePlayer(EntityPlayer player, T charge, boolean simulate) {
        IChargeHandler<T> h = ItemChargeHelper.getHandler(charge);
        if (h == null) {
            return charge;
        }
        ArrayList handlers = new ArrayList();
        playerInvListers.forEach(pil -> pil.listItemHandlers(player, handlers));
        for (int j = 0; j < handlers.size() && charge.containsCharge(); ++j) {
            IItemHandlerModifiable handler = (IItemHandlerModifiable)handlers.get(j);
            for (int i = 0; i < handler.getSlots() && charge.containsCharge(); ++i) {
                if (!h.canCharge(handler.getStackInSlot(i), charge)) continue;
                ItemStack stack = handler.getStackInSlot(i).func_77946_l();
                charge = h.charge(stack, charge, simulate);
                handler.setStackInSlot(i, stack);
            }
        }
        return charge;
    }

    public static <T extends AbstractCharge> T chargeInventory(IInventory inv, Predicate<Integer> chargeSlot, T charge, boolean simulate) {
        IChargeHandler<T> h = ItemChargeHelper.getHandler(charge);
        if (h == null) {
            return charge;
        }
        for (int i = 0; i < inv.func_70302_i_() && charge.containsCharge(); ++i) {
            if (!chargeSlot.test(i) || !h.canCharge(inv.func_70301_a(i), charge)) continue;
            charge = h.charge(inv.func_70301_a(i), charge, simulate);
        }
        return charge;
    }

    static {
        ItemChargeHelper.handle(FECharge.class, new FEChargeHandler());
        playerInvListers.add(new VanillaPlayerInvLister());
        I_TRUE = i -> true;
    }
}

