/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.items;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tk.zeitheron.solarflux.block.tile.TileBaseSolar;
import tk.zeitheron.solarflux.init.ItemsSF;
import tk.zeitheron.solarflux.items.ItemTraversalUpgrade;
import tk.zeitheron.solarflux.items.ItemUpgrade;
import tk.zeitheron.solarflux.utils.BlockPosFace;
import tk.zeitheron.solarflux.utils.InventoryDummy;

public class ItemBlockChargingUpgrade
extends ItemUpgrade {
    IEnergyStorage estorage;

    public ItemBlockChargingUpgrade() {
        this.setRegistryName("solarflux", "block_charging_upgrade");
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityEnergy.ENERGY, facing) && (this.estorage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing)) != null && this.estorage.canReceive()) {
            ItemStack held = player.func_184586_b(hand);
            NBTTagCompound nbt = held.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
                held.func_77982_d(nbt);
            }
            nbt.func_74768_a("Dim", worldIn.field_73011_w.getDimension());
            nbt.func_74772_a("Pos", pos.func_177986_g());
            nbt.func_74774_a("Face", (byte)facing.ordinal());
            this.estorage = null;
            worldIn.func_184133_a(null, pos, SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 0.25f, 1.8f);
            return EnumActionResult.SUCCESS;
        }
        this.estorage = null;
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("Pos", 4) && stack.func_77978_p().func_150297_b("Face", 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.func_77636_d(stack)) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt.func_150297_b("Dim", 3)) {
                tooltip.add("Dimension: " + nbt.func_74762_e("Dim"));
            }
            tooltip.add("Facing: " + EnumFacing.values()[nbt.func_74771_c("Face")]);
            BlockPos pos = BlockPos.func_177969_a((long)nbt.func_74763_f("Pos"));
            tooltip.add("X: " + pos.func_177958_n() + ", Y: " + pos.func_177956_o() + ", Z: " + pos.func_177952_p());
        }
    }

    @Override
    public int getMaxUpgrades() {
        return 1;
    }

    @Override
    public boolean canInstall(TileBaseSolar tile, ItemStack stack, InventoryDummy upgradeInv) {
        TileEntity t;
        BlockPos pos;
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("Pos", 4) && stack.func_77978_p().func_150297_b("Face", 1) && (!stack.func_77978_p().func_150297_b("Dim", 3) || tile.func_145831_w().field_73011_w.getDimension() == stack.func_77978_p().func_74762_e("Dim")) && tile.func_174877_v().func_177951_i((Vec3i)BlockPos.func_177969_a((long)stack.func_77978_p().func_74763_f("Pos"))) <= 256.0 && (pos = BlockPos.func_177969_a((long)stack.func_77978_p().func_74763_f("Pos"))) != null && (t = tile.func_145831_w().func_175625_s(pos)) != null && t.hasCapability(CapabilityEnergy.ENERGY, EnumFacing.values()[stack.func_77978_p().func_74771_c("Face")]);
    }

    @Override
    public boolean canStayInPanel(TileBaseSolar tile, ItemStack stack, InventoryDummy upgradeInv) {
        return this.canInstall(tile, stack, upgradeInv);
    }

    @Override
    public void update(TileBaseSolar tile, ItemStack stack, int amount) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (tile.func_145831_w().func_82737_E() % 20L == 0L) {
            double d;
            BlockPos pos = BlockPos.func_177969_a((long)nbt.func_74763_f("Pos"));
            double d2 = tile.func_174877_v().func_177951_i((Vec3i)pos);
            if (d <= 256.0) {
                d2 /= 256.0;
                tile.traversal.clear();
                if (tile.getUpgrades(ItemsSF.TRAVERSAL_UPGRADE) > 0) {
                    ItemTraversalUpgrade.cache.clear();
                    ItemTraversalUpgrade.cache.add(pos);
                    ItemTraversalUpgrade.findMachines(tile, ItemTraversalUpgrade.cache, tile.traversal);
                }
                tile.traversal.add(new BlockPosFace(pos, EnumFacing.values()[nbt.func_74771_c("Face")], (float)(1.0 - d2)));
            }
        }
    }
}

