/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.tileentity;

import epicsquid.mysticallib.tile.TileBase;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.config.GeneralConfig;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityUnendingBowl
extends TileBase {
    public static UnendingBowlFluidHandler HANDLER = new UnendingBowlFluidHandler();

    public boolean activate(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151069_bo) {
            if (!world.field_72995_K) {
                stack.func_190918_g(1);
                ItemStack potion = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
                if (!player.func_191521_c(potion)) {
                    ItemUtil.spawnItem((World)world, (BlockPos)player.func_180425_c(), (ItemStack)potion);
                }
            }
            return true;
        }
        if (!world.field_72995_K) {
            return FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)HANDLER);
        }
        return true;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)HANDLER);
        }
        return null;
    }

    public static class UnendingBowlFluidHandler
    extends FluidTank {
        public UnendingBowlFluidHandler() {
            super(Integer.MAX_VALUE);
        }

        public FluidTank readFromNBT(NBTTagCompound nbt) {
            return this;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            return nbt;
        }

        public FluidStack getFluid() {
            if (this.fluid == null) {
                this.fluid = FluidRegistry.getFluidStack((String)GeneralConfig.FluidName, (int)Integer.MAX_VALUE);
            }
            return this.fluid;
        }

        public int getFluidAmount() {
            return Integer.MAX_VALUE;
        }

        public int fillInternal(FluidStack resource, boolean doFill) {
            if (resource == null || resource.amount <= 0) {
                return 0;
            }
            if (!this.getFluid().isFluidEqual(resource)) {
                return 0;
            }
            if (!doFill) {
                return this.capacity;
            }
            if (this.tile != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.getFluid(), this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, this.capacity));
            }
            return this.capacity;
        }

        @Nullable
        public FluidStack drainInternal(int maxDrain, boolean doDrain) {
            if (doDrain && this.tile != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(this.getFluid(), this.tile.func_145831_w(), this.tile.func_174877_v(), (IFluidTank)this, maxDrain));
            }
            return new FluidStack(this.getFluid(), maxDrain);
        }

        public boolean canFill() {
            return true;
        }

        public boolean canDrain() {
            return true;
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return this.getFluid() != null && fluid.isFluidEqual(this.getFluid());
        }

        public boolean canDrainFluidType(@Nullable FluidStack fluid) {
            return fluid == null || fluid.getFluid() == FluidRegistry.getFluid((String)GeneralConfig.FluidName);
        }

        protected void onContentsChanged() {
        }
    }
}

