/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.tileentity;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.particle.particles.ParticleLeaf;
import epicsquid.mysticallib.proxy.ClientProxy;
import epicsquid.mysticallib.tile.TileBase;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.Roots;
import epicsquid.roots.advancements.Advancements;
import epicsquid.roots.block.groves.BlockGroveStone;
import epicsquid.roots.config.GeneralConfig;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.network.fx.MessageGrowthCrafterVisualFX;
import epicsquid.roots.particle.ParticleWhirlwindLeaf;
import epicsquid.roots.recipe.FeyCraftingRecipe;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityFeyCrafter
extends TileBase
implements ITickable {
    public static int COUNTDOWN = 40;
    public static int GROVE_STONE_RADIUS = 10;
    protected int countdown = -1;
    protected List<ItemStack> storedItems = new ArrayList<ItemStack>();
    public ItemStackHandler inventory = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            TileEntityFeyCrafter.this.func_70296_d();
            if (!((TileEntityFeyCrafter)TileEntityFeyCrafter.this).field_145850_b.field_72995_K) {
                TileEntityFeyCrafter.this.updatePacketViaState();
            }
        }
    };
    protected BlockPos groveStone = null;
    protected FeyCraftingRecipe lastRecipe;
    private static final double[] stages = new double[]{0.1, 0.15, 0.2, 0.25, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("handler", (NBTBase)this.inventory.serializeNBT());
        tag.func_74772_a("groveStone", this.groveStone == null ? -1L : this.groveStone.func_177986_g());
        if (!this.storedItems.isEmpty()) {
            NBTTagList tagList = new NBTTagList();
            for (ItemStack stack : this.storedItems) {
                tagList.func_74742_a((NBTBase)stack.serializeNBT());
            }
            tag.func_74782_a("storedItems", (NBTBase)tagList);
        }
        tag.func_74768_a("countdown", this.countdown);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("handler"));
        long gpos = tag.func_74763_f("groveStone");
        this.groveStone = gpos == -1L ? null : BlockPos.func_177969_a((long)gpos);
        this.storedItems = new ArrayList<ItemStack>();
        if (tag.func_74764_b("storedItems")) {
            NBTTagList stored = tag.func_150295_c("storedItems", 10);
            for (int i = 0; i < stored.func_74745_c(); ++i) {
                this.storedItems.add(new ItemStack(stored.func_150305_b(i)));
            }
        }
        this.countdown = tag.func_74764_b("countdown") ? tag.func_74762_e("countdown") : -1;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(@Nonnull NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void breakBlock(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            Util.spawnInventoryInWorld((World)world, (double)((double)this.func_174877_v().func_177958_n() + 0.5), (double)((double)this.func_174877_v().func_177956_o() + 0.5), (double)((double)this.func_174877_v().func_177952_p() + 0.5), (IItemHandler)this.inventory);
        }
    }

    public boolean hasValidGroveStone() {
        List potentials;
        if (this.groveStone != null) {
            IBlockState grove = this.field_145850_b.func_180495_p(this.groveStone);
            if (grove.func_177230_c() == ModBlocks.grove_stone && ((Boolean)grove.func_177229_b((IProperty)BlockGroveStone.VALID)).booleanValue()) {
                return true;
            }
            this.groveStone = null;
        }
        if ((potentials = Util.getBlocksWithinRadius((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)GROVE_STONE_RADIUS, (float)GROVE_STONE_RADIUS, (float)GROVE_STONE_RADIUS, (Block)ModBlocks.grove_stone)).isEmpty()) {
            return false;
        }
        for (BlockPos pos : potentials) {
            IBlockState grove = this.field_145850_b.func_180495_p(pos);
            if (!((Boolean)grove.func_177229_b((IProperty)BlockGroveStone.VALID)).booleanValue()) continue;
            this.groveStone = pos;
            return true;
        }
        return false;
    }

    public List<ItemStack> craft(EntityPlayer player) {
        FeyCraftingRecipe recipe = this.getRecipe();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        ItemStack current = ItemStack.field_190927_a;
        ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
        while (recipe != null) {
            inputItems.clear();
            boolean singleStack = false;
            for (int i = 0; i < 5; ++i) {
                inputItems.add(this.inventory.extractItem(i, 1, false));
            }
            for (ItemStack stack : recipe.transformIngredients(inputItems, this)) {
                ItemUtil.spawnItem((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177982_a(Util.rand.nextBoolean() ? -1 : 1, 1, Util.rand.nextBoolean() ? -1 : 1), (ItemStack)stack);
            }
            if (current.func_190926_b()) {
                current = recipe.getResult().func_77946_l();
                if (current.func_77976_d() == 1) {
                    singleStack = true;
                }
                recipe.postCraft(current, inputItems, player);
            } else if (current.func_190916_E() + recipe.getResult().func_190916_E() < current.func_77976_d()) {
                current.func_190917_f(recipe.getResult().func_190916_E());
            } else {
                result.add(current);
                current = recipe.getResult().func_77946_l();
            }
            this.lastRecipe = recipe;
            if (singleStack) break;
            recipe = this.getRecipe();
        }
        if (!current.func_190926_b()) {
            result.add(current);
        }
        return result;
    }

    public FeyCraftingRecipe getRecipe() {
        List<ItemStack> contents = this.getContents();
        if (contents.isEmpty()) {
            return null;
        }
        return ModRecipes.getFeyCraftingRecipe(contents);
    }

    public List<ItemStack> getContents() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack inSlot = this.inventory.getStackInSlot(i);
            if (inSlot.func_190926_b()) continue;
            result.add(inSlot);
        }
        return result;
    }

    public boolean activate(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean shouldGui;
        boolean bl = shouldGui = !this.hasValidGroveStone();
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        if (!ModItems.knives.contains(player.func_184586_b(hand).func_77973_b())) {
            shouldGui = true;
        }
        if (!shouldGui) {
            if (this.countdown != -1) {
                return true;
            }
            this.storedItems = this.craft(player);
            if (this.storedItems.isEmpty()) {
                shouldGui = true;
            }
        }
        if (shouldGui) {
            player.openGui((Object)Roots.instance, 18, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        this.countdown = COUNTDOWN;
        MessageGrowthCrafterVisualFX packet = new MessageGrowthCrafterVisualFX(this.func_174877_v(), world.field_73011_w.getDimension());
        PacketHandler.sendToAllTracking((IMessage)packet, (TileEntity)this);
        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ModSounds.WHIRLWIND, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        Advancements.CRAFTING_TRIGGER.trigger((EntityPlayerMP)player, (Object)this.lastRecipe);
        this.lastRecipe = null;
        return true;
    }

    public void doVisual() {
        if (this.field_145850_b.field_72995_K) {
            BlockPos pos = this.func_174877_v();
            for (int s = 0; s < 12; ++s) {
                double r = stages[s];
                double y = 0.6 + (double)s * 0.13;
                int i = 0;
                while ((double)i < r * 1.4 * 8.0) {
                    ClientProxy.particleRenderer.spawnParticle(this.field_145850_b, ParticleWhirlwindLeaf.class, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, new double[]{200.0, 0.23529411764705882 + Util.rand.nextDouble() * 0.05, 0.47058823529411764 + Util.rand.nextDouble() * 0.05, 0.23529411764705882 + Util.rand.nextDouble() * 0.05, 1.1f, 0.9f, 0.0, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + y, (double)pos.func_177952_p() + 0.5, r, 0.0});
                    ClientProxy.particleRenderer.spawnParticle(this.field_145850_b, ParticleWhirlwindLeaf.class, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, new double[]{200.0, 0.11764705882352941 + Util.rand.nextDouble() * 0.05, 0.23529411764705882 + Util.rand.nextDouble() * 0.05, 0.11764705882352941 + Util.rand.nextDouble() * 0.05, 1.1f, 1.1f, 0.0, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + y, (double)pos.func_177952_p() + 0.5, r * 0.85, 1.0});
                    ++i;
                }
            }
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 2L == 0L && this.getRecipe() != null) {
            ClientProxy.particleRenderer.spawnParticle(this.field_145850_b, ParticleLeaf.class, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.75, (double)this.field_174879_c.func_177952_p() + 0.5, (Util.rand.nextDouble() - 0.5) * 0.005, Util.rand.nextDouble() * 0.02 * 0.5, (Util.rand.nextDouble() - 0.5) * 0.005, new double[]{100.0, 0.24705882352941178, 0.5607843137254902 + Util.rand.nextDouble() * 0.05, 0.2901960784313726, 1.0, 1.0, 1.0});
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.countdown > 0) {
                this.countdown = this.storedItems.isEmpty() ? -1 : --this.countdown;
            } else {
                this.countdown = -1;
                for (EnumFacing facing : EnumFacing.values()) {
                    IItemHandler cap;
                    TileEntity te;
                    IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v().func_177972_a(facing));
                    if (GeneralConfig.getCrafterOutputIgnore().contains(state.func_177230_c()) || (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(facing))) == null || (cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) == null) continue;
                    ArrayList<ItemStack> newItems = new ArrayList<ItemStack>();
                    for (ItemStack toPut : this.storedItems) {
                        ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)cap, (ItemStack)toPut, (boolean)false);
                        if (result.func_190926_b()) continue;
                        newItems.add(result);
                    }
                    this.storedItems = newItems;
                }
                for (ItemStack stack : this.storedItems) {
                    EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.1, (double)this.field_174879_c.func_177952_p() + 0.5, stack);
                    this.field_145850_b.func_72838_d((Entity)item);
                }
                this.storedItems.clear();
            }
        }
    }
}

