/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.roots.entity.ritual.EntityRitualHeavyStorms;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.properties.Property;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.conditions.ConditionRunedPillars;
import epicsquid.roots.ritual.conditions.ConditionStandingStones;
import epicsquid.roots.util.RitualUtil;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreIngredient;

public class RitualHeavyStorms
extends RitualBase {
    public static Property.PropertyDuration PROP_DURATION = new Property.PropertyDuration(2400);
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 15).setDescription("Radius on the X Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 15).setDescription("Radius on the Y Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 15).setDescription("Radius on the Z Axis of the cube in which the ritual takes place");
    public static Property<Float> PROP_LIGHTNING_CHANCE = new Property<Float>("lightning_chance", Float.valueOf(0.1f)).setDescription("Chance (per interval of 1 second) of the ritual duration for lightning to strike in the ritual area");
    public static Property<Integer> PROP_MAX_STRIKES = new Property<Integer>("lightning_interval", 10).setDescription("Maximum number of lightning strikes that can happen per ritual. (Set to -1 for infinite)");
    public double radius_x;
    public double radius_y;
    public double radius_z;
    public int interval;
    public int max_strikes;
    public float lightning_chance;

    public RitualHeavyStorms(String name, boolean disabled) {
        super(name, disabled);
        this.properties.add(PROP_DURATION, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z, PROP_LIGHTNING_CHANCE, PROP_MAX_STRIKES);
        this.setEntityClass(EntityRitualHeavyStorms.class);
    }

    @Override
    public void init() {
        this.recipe = new RitualBase.RitualRecipe((RitualBase)this, new ItemStack(Blocks.field_150392_bi), new ItemStack(ModItems.dewgonia), new OreIngredient("vine"), new ItemStack(ModItems.cloud_berry), new ItemStack(Items.field_151126_ay));
        this.addCondition(new ConditionStandingStones(3, 1));
        this.addCondition(new ConditionRunedPillars(RitualUtil.RunedWoodType.DARK_OAK, 4, 1));
        this.setIcon(ModItems.ritual_heavy_storms);
        this.setColor(TextFormatting.DARK_AQUA);
        this.setBold(true);
    }

    @Override
    public void doFinalise() {
        this.duration = this.properties.get(PROP_DURATION);
        int[] radius = this.properties.getRadius();
        this.radius_x = (double)radius[0] + 0.5;
        this.radius_y = (double)radius[1] + 0.5;
        this.radius_z = (double)radius[2] + 0.5;
        this.lightning_chance = this.properties.get(PROP_LIGHTNING_CHANCE).floatValue();
        this.max_strikes = this.properties.get(PROP_MAX_STRIKES);
    }
}

