/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.modifiers;

import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.roots.api.Herb;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.IModifier;
import epicsquid.roots.modifiers.IModifierCore;
import epicsquid.roots.modifiers.IModifierCost;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.util.types.RegistryItem;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class Modifier
extends RegistryItem
implements IModifier {
    private final IModifierCore core;
    private final Set<IModifier> conflicts = new HashSet<IModifier>();
    private final Map<CostType, IModifierCost> costs;
    private List<Property<SpellBase.ModifierCost>> propertyCache;
    private ItemStack modifierStack = ItemStack.field_190927_a;
    private String identifier = null;

    public Modifier(ResourceLocation name, IModifierCore core, Map<CostType, IModifierCost> costs) {
        this.setRegistryName(name);
        this.costs = costs;
        this.core = core;
    }

    @Override
    public boolean isDisabled() {
        return ModifierRegistry.isDisabled(this);
    }

    @Override
    public String getTranslationKey() {
        ResourceLocation rl = this.getRegistryName();
        if (rl.func_110624_b().equals("roots")) {
            return "roots.modifiers.modifiers." + rl.func_110623_a();
        }
        return "roots.modifiers.modifiers." + rl.func_110624_b() + "." + rl.func_110623_a();
    }

    @Override
    public String getFormatting() {
        return this.core.getFormatting();
    }

    @Override
    public ItemStack getStack() {
        return this.core.getStack();
    }

    public ItemStack getModifierStack() {
        if (this.modifierStack.func_190926_b()) {
            this.modifierStack = new ItemStack(ModItems.spell_modifier);
            NBTTagCompound tag = ItemUtil.getOrCreateTag((ItemStack)this.modifierStack);
            tag.func_74778_a("modifier", this.getRegistryName().toString());
        }
        return this.modifierStack;
    }

    @Override
    public IModifierCore getCore() {
        return this.core;
    }

    @Override
    public Map<CostType, IModifierCost> getCosts() {
        return this.costs;
    }

    @Override
    public Set<IModifier> getConflicts() {
        return this.conflicts;
    }

    @Override
    public String getIdentifier() {
        if (this.identifier == null) {
            this.identifier = this.getRegistryName().toString();
        }
        return this.identifier;
    }

    @Override
    public List<Property<SpellBase.ModifierCost>> asProperties() {
        if (this.propertyCache == null) {
            this.propertyCache = new ArrayList<Property<SpellBase.ModifierCost>>();
            for (IModifierCost entry : this.getCosts().values()) {
                String name = entry.asPropertyName();
                if (name == null) continue;
                Property<SpellBase.ModifierCost> prop = new Property<SpellBase.ModifierCost>(name, new SpellBase.ModifierCost(entry));
                this.propertyCache.add(prop);
            }
        }
        return this.propertyCache;
    }

    @Override
    public void addConflict(IModifier supplier, boolean reverse) {
        this.conflicts.add(supplier);
        if (reverse) {
            supplier.addConflict(this, false);
        }
    }

    public void addConflicts(IModifier ... suppliers) {
        for (IModifier sup : suppliers) {
            this.addConflict(sup);
        }
    }

    public void replaceCosts(List<SpellBase.ModifierCost> costs) {
        this.costs.clear();
        for (SpellBase.ModifierCost cost : costs) {
            this.costs.put(cost.getType(), cost.asCost());
        }
    }

    @Override
    public Object2DoubleOpenHashMap<Herb> apply(Object2DoubleOpenHashMap<Herb> costs, CostType phase) {
        if (phase == CostType.NO_COST) {
            return costs;
        }
        Object2DoubleOpenHashMap result = new Object2DoubleOpenHashMap(costs);
        for (Map.Entry<CostType, IModifierCost> c : this.getCosts().entrySet()) {
            Herb herb;
            double val;
            IModifierCost cost = c.getValue();
            if (cost.getCost() != phase) continue;
            if (cost.getCost() == CostType.ADDITIONAL_COST) {
                if (result.containsKey((Object)cost.getHerb())) {
                    result.put((Object)cost.getHerb(), result.getDouble((Object)cost.getHerb()) + cost.getValue());
                    continue;
                }
                result.put((Object)cost.getHerb(), cost.getValue());
                continue;
            }
            if (cost.getCost() == CostType.ALL_COST_MULTIPLIER) {
                for (Object2DoubleMap.Entry actualCost : costs.object2DoubleEntrySet()) {
                    val = actualCost.getDoubleValue();
                    herb = (Herb)actualCost.getKey();
                    result.put((Object)herb, val + val * cost.getValue());
                }
                continue;
            }
            if (cost.getCost() == CostType.SPECIFIC_COST_ADJUSTMENT) {
                for (Object2DoubleMap.Entry actualCost : costs.object2DoubleEntrySet()) {
                    val = actualCost.getDoubleValue();
                    herb = (Herb)actualCost.getKey();
                    result.put((Object)herb, val + cost.getValue());
                }
                continue;
            }
            if (cost.getCost() != CostType.SPECIFIC_COST_MULTIPLIER) continue;
            for (Object2DoubleMap.Entry actualCost : costs.object2DoubleEntrySet()) {
                val = actualCost.getDoubleValue();
                herb = (Herb)actualCost.getKey();
                result.put((Object)herb, val + val * cost.getValue());
            }
        }
        return result;
    }
}

