/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.hwyla.providers;

import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.tileentity.TileEntityPyre;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class ProviderPyre
implements IWailaDataProvider {
    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntityPyre te = (TileEntityPyre)accessor.getTileEntity();
        if (te != null && te.getBurnTime() > 0) {
            int duration;
            if (te.getLastRecipeUsed() != null) {
                ItemStack result = te.getLastRecipeUsed().getResult();
                duration = te.getLastRecipeUsed().getBurnTime();
                tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"roots.hud.pyre.recipe", (Object[])new Object[]{result.func_82833_r()}));
            } else if (te.getLastRitualUsed() != null) {
                RitualBase ritual = te.getLastRitualUsed();
                duration = ritual.getDuration();
                tooltip.add(I18n.func_135052_a((String)"roots.hud.pyre.ritual", (Object[])new Object[]{ritual.getFormat() + I18n.func_135052_a((String)("roots.ritual." + ritual.getName() + ".name"), (Object[])new Object[0])}));
            } else {
                return tooltip;
            }
            double totalSeconds = (double)(duration - (duration - te.getBurnTime())) / 20.0;
            tooltip.add(I18n.func_135052_a((String)"roots.hud.pyre.progress", (Object[])new Object[]{(int)totalSeconds}));
        }
        return tooltip;
    }
}

