/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.crafttweaker.tweaks.predicates;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlockState;
import crafttweaker.api.minecraft.CraftTweakerMC;
import epicsquid.roots.integration.crafttweaker.tweaks.predicates.Predicates;
import epicsquid.roots.util.zen.ZenDocAppend;
import epicsquid.roots.util.zen.ZenDocArg;
import epicsquid.roots.util.zen.ZenDocClass;
import epicsquid.roots.util.zen.ZenDocMethod;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.roots.predicates.PropertyPredicate")
@ZenDocAppend(value={"docs/include/transmutation.propertypredicate.example.md"})
@ZenClass(value="mods.roots.predicates.PropertyPredicate")
@ZenRegister
public class PropertyPredicate
implements Predicates.IPredicate {
    private IBlockState state;
    private List<IProperty<?>> properties;

    public PropertyPredicate(IBlockState state, String[] properties) {
        this.state = state;
        this.properties = new ArrayList();
        BlockStateContainer container = CraftTweakerMC.getBlockState((IBlockState)state).func_177230_c().func_176194_O();
        for (String name : properties) {
            IProperty prop = container.func_185920_a(name);
            if (prop != null) {
                this.properties.add(prop);
                continue;
            }
            CraftTweakerAPI.logError((String)("Invalid property name '" + name + "' for " + state.toString()));
        }
    }

    @ZenMethod
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="state", info="description of a simple blockstate"), @ZenDocArg(arg="properties", info="a string containing the property name that must match")}, description={"Creates an IPredicate where the specified state is compared against other states, where the block type must match and the values of the specified property names must match."})
    public static PropertyPredicate create(IBlockState state, String properties) {
        return new PropertyPredicate(state, new String[]{properties});
    }

    @ZenMethod
    @ZenDocMethod(order=2, args={@ZenDocArg(arg="state", info="description of a simple blockstate"), @ZenDocArg(arg="properties", info="an array of strings containing property names that must match")}, description={"Creates an IPredicate where the specified state is compared against other states, where the block type must match and the values of all of the specified property names must match."})
    public static PropertyPredicate create(IBlockState state, String[] properties) {
        return new PropertyPredicate(state, properties);
    }

    @Override
    public epicsquid.roots.recipe.transmutation.PropertyPredicate get() {
        return new epicsquid.roots.recipe.transmutation.PropertyPredicate(CraftTweakerMC.getBlockState((IBlockState)this.state), this.properties);
    }
}

