/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.init;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.Loader;

public class ModDamage {
    private static final String FEY_FIRE_FAKE_PLAYER_NAME = "Fey Fire";
    private static final UUID FEY_FIRE_FAKE_PLAYER_UUID = UUID.fromString("fd3bc208-e351-48ac-afc4-1b612dc36aff");
    public static final GameProfile FEY_FIRE_FAKE_PLAYER = new GameProfile(FEY_FIRE_FAKE_PLAYER_UUID, "Fey Fire");
    private static final String FEY_CRAFTER_FAKE_PLAYER_NAME = "Fey Crafter";
    private static final UUID FEY_CRAFTER_FAKE_PLAYER_UUID = UUID.fromString("f8f5968b-da9f-430d-851b-cf232728f141");
    public static final GameProfile FEY_CRAFTER_FAKE_PLAYER = new GameProfile(FEY_CRAFTER_FAKE_PLAYER_UUID, "Fey Crafter");
    public static final String FEY_FIRE = "fey_fire";
    public static DamageSource RADIANT_DAMAGE = new DamageSource("holy_damage").func_76348_h().func_82726_p();
    public static DamageSource PHYSICAL_DAMAGE = new DamageSource("physical_damage").func_76348_h();
    public static DamageSource PSYCHIC_DAMAGE = new DamageSource("psychic_damage").func_76348_h().func_82726_p();
    public static DamageSource WATER_DAMAGE = new DamageSource("water_damage").func_76348_h().func_82726_p();
    public static DamageSource COLD_DAMAGE = new DamageSource("cold_damage").func_76348_h().func_82726_p();
    public static DamageSource BLEED_DAMAGE = new DamageSource("bleed_damage").func_76348_h();
    public static DamageSource ROSE_DAMAGE = new DamageSource("rose_thorns").func_76348_h();
    public static DamageSource HARVEST_RITUAL_DAMAGE = new DamageSource("harvest_damage_ritual");

    public static DamageSource physicalDamageFrom(@Nullable Entity player) {
        DamageSource source = player == null ? PHYSICAL_DAMAGE : new EntityDamageSource("physical", player).func_76348_h();
        return source;
    }

    public static DamageSource magicDamageFrom(@Nullable Entity player) {
        DamageSource source = player == null ? DamageSource.field_76376_m : new EntityDamageSource("magic", player).func_76348_h().func_82726_p();
        return source;
    }

    public static DamageSource coldDamageFrom(@Nullable Entity player) {
        DamageSource source = player == null ? DamageSource.field_76376_m : new EntityDamageSource("cold_damage", player).func_76348_h().func_82726_p();
        return source;
    }

    public static DamageSource roseDamageFrom(@Nullable Entity player) {
        if (player == null) {
            return ROSE_DAMAGE;
        }
        DamageSource source = new EntityDamageSource("rose_thorns", player).func_76348_h();
        return source;
    }

    public static DamageSource radiantDamageFrom(@Nullable Entity player) {
        DamageSource source = player == null ? RADIANT_DAMAGE : new EntityDamageSource("holy_damage", player).func_76348_h().func_82726_p();
        if (Loader.isModLoaded((String)"consecration")) {
            source.func_76361_j();
        }
        return source;
    }

    public static DamageSource fireDamageFrom(@Nullable Entity player) {
        DamageSource source = player == null ? DamageSource.field_76372_a : new EntityDamageSource("fire_damage", player).func_76348_h().func_82726_p().func_76361_j();
        return source;
    }

    public static DamageSource waterDamageFrom(@Nullable Entity player) {
        if (player == null) {
            return WATER_DAMAGE;
        }
        return new EntityDamageSource("water_damage", player).func_76348_h().func_82726_p();
    }

    @Nullable
    public static DamageSource wildfireDamage(World world) {
        if (world.field_72995_K) {
            return null;
        }
        FakePlayer player = ModDamage.getFakePlayer(world);
        return new EntityDamageSource(FEY_FIRE, (Entity)player).func_76348_h().func_82726_p().func_76361_j();
    }

    public static FakePlayer getFakePlayer(World world) {
        return ModDamage.getFakePlayer(world, FEY_FIRE_FAKE_PLAYER);
    }

    public static FakePlayer getFakePlayer(World world, GameProfile profile) {
        if (world.field_72995_K) {
            throw new IllegalStateException("can't get a fake player on a client side");
        }
        WorldServer server = (WorldServer)world;
        return FakePlayerFactory.get((WorldServer)server, (GameProfile)profile);
    }

    public static void init() {
    }
}

