/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.config;

import epicsquid.mysticallib.util.ConfigUtil;
import epicsquid.roots.Roots;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Mod.EventBusSubscriber(modid="roots")
@Config.LangKey(value="config.roots.category.general")
@Config(modid="roots", name="roots/general", category="main")
public class GeneralConfig {
    @Config.Comment(value={"Set to false to disable repairing items in an Imbuer"})
    public static boolean AllowImbuerRepair = true;
    @Config.Comment(value={"Set to false to prevent runic dust from removing enchants with an Imbuer"})
    public static boolean AllowImbuerDisenchant = true;
    @Config.Comment(value={"Set to false to prevent Imbuer disenchantment operations from reducing the repair cost of an item"})
    public static boolean AllowImbuerDisenchantReduceCost = true;
    @Config.Comment(value={"Divisor of max damage of an item to calculte how much is repaired in an Imbuer (formula: max damage / X)"})
    public static int MaxDamageDivisor = 4;
    @Config.Comment(value={"Client side only: disable elemental soil particles"})
    public static boolean DisableParticles = false;
    @Config.Comment(value={"Set to true to give players the Roots Guide Book upon joining the server"})
    public static boolean GiveBook = false;
    @Config.Comment(value={"Inject some items from Roots into dungeon & other loot chests"})
    public static boolean InjectLoot = true;
    @Config.Comment(value={"Minimum number of pulls for injected loot"})
    public static int InjectMinimum = 1;
    @Config.Comment(value={"Maximum nubmer of pulls for injected loot"})
    public static int InjectMaximum = 1;
    @Config.Comment(value={"1 in X chance per random tick for the Grove Stone to do anything"})
    public static int GroveStoneChance = 2;
    @Config.Comment(value={"Set to false to disable Grove Stone environmental effects"})
    public static boolean EnableGroveStoneEnvironment = true;
    @Config.Comment(value={"Set to true to automatically equip component and apothecary pouches when right-clicking"})
    public static boolean AutoEquipPouches = false;
    @Config.Comment(value={"Set to true to automatically refill your component and apothecary pouches when picking up herbs"})
    public static boolean AutoRefillPouches = false;
    @Config.Comment(value={"The aoe-radius for using runic shears to aoe-shear things"})
    public static int RunicShearsRadius = 15;
    @Config.Comment(value={"The health threshold at which entities are considered boss-type creatures (in half hearts)"})
    public static float BossEntityHealth = 40.0f;
    @Config.Comment(value={"List of mod:item:meta (meta optional) of saplings that should be planted in 2x2 by the Spreading Forest ritual"})
    public static String[] TwoByTwoSaplings = new String[]{"thaumcraft:sapling_greatwood"};
    @Config.Ignore
    private static Set<ItemStack> twoByTwoSaplings = null;
    @Config.Comment(value={"List of mod:item:meta (meta optional) of saplings that should be blacklisted from the Spreading Forest ritual"})
    public static String[] SaplingBlacklist = new String[]{"roots:wildwood_sapling", "corvus:frankinsence_sapling", "thebetweenlands:sapling_spirit_tree"};
    @Config.Ignore
    private static Set<ItemStack> saplingBlacklist = null;
    @Config.Comment(value={"Name of the liquid as per the Forge registry to provide from the Unending Bowl"})
    public static String FluidName = "water";
    @Config.Comment(value={"How long it takes a Fire Starter to start a fire (in ticks)"})
    public static int FireStarterTicks = 60;
    @Config.Comment(value={"Whether or not the Untrue Pacifist advancement should be tracked"})
    public static boolean UntruePacifist = true;
    @Config.Comment(value={"Whether or not the Wild Mage villager career should be populated (note: this may break pre-existing worlds if changed)"})
    public static boolean WildMageVillager = true;
    @Config.Comment(value={"List of blocks that Fey Crafters and Runic Crafters should not output to"})
    public static String[] crafterOutputBlackist = new String[]{"minecraft:dispenser"};
    @Config.Ignore
    private static Set<Block> crafterOutputIgnore = null;
    @Config.Comment(value={"List of blocks that Overgrowth and Terra Moss should consider water for adjacency purposes"})
    public static String[] waterBlocks = new String[]{"minecraft:water", "minecraft:flowing_water"};
    @Config.Comment(value={"The block that is considered the cardinal definition of water"})
    public static String waterBlock = "minecraft:water";
    @Config.Comment(value={"Whether or not the firestarter should be injected into JEI"})
    public static boolean injectFirestarter = true;
    @Config.Ignore
    private static Block actualWaterBlock = null;
    @Config.Ignore
    private static Set<Block> actualWaterBlocks = null;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("roots")) {
            ConfigManager.sync((String)"roots", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static Set<ItemStack> getTwoByTwoSaplings() {
        if (twoByTwoSaplings == null) {
            twoByTwoSaplings = ConfigUtil.parseItemStacksSet((String[])TwoByTwoSaplings);
        }
        return twoByTwoSaplings;
    }

    public static Set<ItemStack> getSaplingBlacklist() {
        if (saplingBlacklist == null) {
            saplingBlacklist = ConfigUtil.parseItemStacksSet((String[])SaplingBlacklist);
        }
        return saplingBlacklist;
    }

    @Nullable
    public static Fluid getFluid() {
        return FluidRegistry.getFluid((String)FluidName);
    }

    public static Set<Block> getCrafterOutputIgnore() {
        if (crafterOutputIgnore == null) {
            crafterOutputIgnore = new HashSet<Block>();
            for (String rl : crafterOutputBlackist) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(rl));
                if (block == null) {
                    Roots.logger.error("Invalid Configuration Value for: crafterOutputBlacklist.\n  - " + rl + " is not a valid block.");
                    continue;
                }
                crafterOutputIgnore.add(block);
            }
        }
        return crafterOutputIgnore;
    }

    public static Set<Block> getWaterBlocks() {
        if (actualWaterBlocks == null) {
            actualWaterBlocks = new HashSet<Block>();
            for (String rl : waterBlocks) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(rl));
                if (block == null) {
                    Roots.logger.error("Invalid Configuration Value for: waterBlocks.\n  - " + rl + " is not a valid block.");
                    continue;
                }
                actualWaterBlocks.add(block);
            }
        }
        return actualWaterBlocks;
    }

    public static Block getWaterBlock() {
        if (actualWaterBlock == null) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(waterBlock));
            if (block == null) {
                Roots.logger.error("Invalid Configuration Value for: waterBlock.\n  - " + waterBlock + " is not a valid block.");
            } else {
                actualWaterBlock = block;
            }
        }
        return actualWaterBlock;
    }
}

