/*
 * Decompiled with CFR 0.152.
 */
package requious.util;

import java.awt.Color;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class Misc {
    public static void syncTE(TileEntity tile, boolean broken) {
        int j;
        int i;
        PlayerChunkMap chunkMap;
        PlayerChunkMapEntry entry;
        SPacketUpdateTileEntity packet;
        World world = tile.func_145831_w();
        if (!tile.func_145837_r() && !broken && world instanceof WorldServer && (packet = tile.func_189518_D_()) != null && (entry = (chunkMap = ((WorldServer)world).func_184164_w()).func_187301_b(i = tile.func_174877_v().func_177958_n() >> 4, j = tile.func_174877_v().func_177952_p() >> 4)) != null) {
            entry.func_187267_a((Packet)packet);
        }
    }

    public static AxisAlignedBB rotateAABB(AxisAlignedBB aabb, EnumFacing direction) {
        Vec3d pointA = new Vec3d(aabb.field_72340_a - 0.5, aabb.field_72338_b - 0.5, aabb.field_72339_c - 0.5);
        Vec3d pointB = new Vec3d(aabb.field_72336_d - 0.5, aabb.field_72337_e - 0.5, aabb.field_72334_f - 0.5);
        return new AxisAlignedBB(0.5 + Misc.xOffset(pointA, direction), 0.5 + Misc.yOffset(pointA, direction), 0.5 + Misc.zOffset(pointA, direction), 0.5 + Misc.xOffset(pointB, direction), 0.5 + Misc.yOffset(pointB, direction), 0.5 + Misc.zOffset(pointB, direction));
    }

    public static double xOffset(Vec3d offset, EnumFacing direction) {
        switch (direction) {
            case DOWN: 
            case NORTH: {
                return -offset.field_72450_a;
            }
            case WEST: {
                return -offset.field_72448_b;
            }
            case EAST: {
                return offset.field_72448_b;
            }
        }
        return offset.field_72450_a;
    }

    public static double yOffset(Vec3d offset, EnumFacing direction) {
        switch (direction) {
            case DOWN: {
                return -offset.field_72448_b;
            }
            case NORTH: {
                return offset.field_72449_c;
            }
            case SOUTH: {
                return -offset.field_72449_c;
            }
            case WEST: {
                return offset.field_72450_a;
            }
            case EAST: {
                return -offset.field_72450_a;
            }
        }
        return offset.field_72448_b;
    }

    public static double zOffset(Vec3d offset, EnumFacing direction) {
        switch (direction) {
            case DOWN: 
            case WEST: {
                return -offset.field_72449_c;
            }
            case NORTH: {
                return -offset.field_72448_b;
            }
            case SOUTH: {
                return offset.field_72448_b;
            }
        }
        return offset.field_72449_c;
    }

    public static BlockPos posOffset(BlockPos pos, Vec3i offset, EnumFacing direction) {
        int oz;
        int oy;
        int ox;
        switch (direction) {
            case DOWN: {
                ox = -offset.func_177958_n();
                oy = -offset.func_177956_o();
                oz = -offset.func_177952_p();
                break;
            }
            case NORTH: {
                ox = -offset.func_177958_n();
                oy = offset.func_177952_p();
                oz = -offset.func_177956_o();
                break;
            }
            case SOUTH: {
                ox = offset.func_177958_n();
                oy = -offset.func_177952_p();
                oz = offset.func_177956_o();
                break;
            }
            case WEST: {
                ox = -offset.func_177956_o();
                oy = offset.func_177958_n();
                oz = -offset.func_177952_p();
                break;
            }
            case EAST: {
                ox = offset.func_177956_o();
                oy = -offset.func_177958_n();
                oz = offset.func_177952_p();
                break;
            }
            default: {
                ox = offset.func_177958_n();
                oy = offset.func_177956_o();
                oz = offset.func_177952_p();
            }
        }
        return pos.func_177982_a(ox, oy, oz);
    }

    public static String getCountString(ItemStack itemstack) {
        String s = null;
        int count = itemstack.func_190916_E();
        if (count >= 1000000000) {
            s = count / 1000000000 + "B";
        } else if (count >= 100000000) {
            s = "." + count / 100000000 + "B";
        } else if (count >= 1000000) {
            s = count / 1000000 + "M";
        } else if (count >= 100000) {
            s = "." + count / 100000 + "M";
        } else if (count >= 1000) {
            s = count / 1000 + "k";
        }
        return s;
    }

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        Misc.drawTexturedModalRect(x, y, 100, textureX, textureY, width, height);
    }

    public static void drawTexturedModalRect(int x, int y, int z, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(x + 0), (double)(y + height), (double)z).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + 0), (double)z).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + 0), (double)(y + 0), (double)z).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static Color lerpColorRGB(List<Color> colors, double lerp) {
        if (colors.size() <= 1) {
            throw new IllegalArgumentException("Needs atleast two colors.");
        }
        if (lerp >= 1.0) {
            return colors.get(colors.size() - 1);
        }
        int index = MathHelper.func_76125_a((int)((int)(lerp * (double)(colors.size() - 1))), (int)0, (int)(colors.size() - 2));
        return Misc.lerpColorRGB(colors.get(index), colors.get(index + 1), lerp * (double)(colors.size() - 1) % 1.0);
    }

    public static Color lerpColorHSB(List<Color> colors, double lerp) {
        if (colors.size() <= 1) {
            throw new IllegalArgumentException("Needs atleast two colors.");
        }
        if (lerp >= 1.0) {
            return colors.get(colors.size() - 1);
        }
        int expectedIndex = (int)(lerp * (double)(colors.size() - 1));
        int index = MathHelper.func_76125_a((int)expectedIndex, (int)0, (int)(colors.size() - 2));
        return Misc.lerpColorHSB(colors.get(index), colors.get(index + 1), lerp * (double)(colors.size() - 1) % 1.0);
    }

    public static Color lerpColorRGB(Color colorA, Color colorB, double lerp) {
        int r = (int)MathHelper.func_151238_b((double)colorA.getRed(), (double)colorB.getRed(), (double)lerp);
        int g = (int)MathHelper.func_151238_b((double)colorA.getGreen(), (double)colorB.getGreen(), (double)lerp);
        int b = (int)MathHelper.func_151238_b((double)colorA.getBlue(), (double)colorB.getBlue(), (double)lerp);
        int a = (int)MathHelper.func_151238_b((double)colorA.getAlpha(), (double)colorB.getAlpha(), (double)lerp);
        return new Color(r, g, b, a);
    }

    public static Color lerpColorHSB(Color colorA, Color colorB, double lerp) {
        float[] hsbA = Color.RGBtoHSB(colorA.getRed(), colorA.getGreen(), colorA.getBlue(), null);
        float[] hsbB = Color.RGBtoHSB(colorB.getRed(), colorB.getGreen(), colorB.getBlue(), null);
        float h = (float)MathHelper.func_151238_b((double)hsbA[0], (double)hsbB[0], (double)lerp);
        float s = (float)MathHelper.func_151238_b((double)hsbA[1], (double)hsbB[1], (double)lerp);
        float b = (float)MathHelper.func_151238_b((double)hsbA[2], (double)hsbB[2], (double)lerp);
        int a = (int)MathHelper.func_151238_b((double)colorA.getAlpha(), (double)colorB.getAlpha(), (double)lerp);
        Color hsbColor = Color.getHSBColor(h, s, b);
        return new Color(hsbColor.getRed(), hsbColor.getGreen(), hsbColor.getBlue(), a);
    }

    public static Color parseColor(int[] rgb) {
        Color color = Color.WHITE;
        if (rgb != null && rgb.length >= 3 && rgb.length <= 4) {
            color = new Color(rgb[0], rgb[1], rgb[2], rgb.length == 4 ? rgb[3] : 255);
        }
        return color;
    }

    public static Vec3d getLocalVector(Vec3d vector, EnumFacing facing) {
        return new Vec3d(Misc.xOffset(vector, facing), Misc.yOffset(vector, facing), Misc.zOffset(vector, facing));
    }
}

