/*
 * Decompiled with CFR 0.152.
 */
package requious.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import requious.tile.ILaserAcceptor;
import requious.util.ILaserStorage;
import requious.util.LaserVisual;
import requious.util.Misc;

public class LaserUtil {
    static Random random = new Random();
    private World world;
    private BlockPos emitPos;
    private EnumFacing emitFacing;
    private String type;
    private int x1;
    private int y1;
    private int z1;
    private int x2;
    private int y2;
    private int z2;
    private int x;
    private int y;
    private int z;
    private int minTargets = 1;
    private int maxTargets = 1;
    private List<ILaserAcceptor> acceptors = new ArrayList<ILaserAcceptor>();
    private LaserVisual visual;
    private List<Target> targets = new ArrayList<Target>();
    State state = State.SEARCHING;
    List<ILaserAcceptor> searchAcceptors = new ArrayList<ILaserAcceptor>();
    List<LazyTarget> lazyTargets = new ArrayList<LazyTarget>();

    public World getWorld() {
        return this.world;
    }

    public void setEmitter(World world, BlockPos pos, EnumFacing facing, String type, LaserVisual visual) {
        this.world = world;
        this.emitPos = pos;
        this.emitFacing = facing;
        this.type = type;
        this.visual = visual;
        this.readTarget();
    }

    public void setTarget(Vec3i zoneA, Vec3i zoneB) {
        int xMin = Math.min(zoneA.func_177958_n(), zoneB.func_177958_n());
        int yMin = Math.min(zoneA.func_177956_o(), zoneB.func_177956_o());
        int zMin = Math.min(zoneA.func_177952_p(), zoneB.func_177952_p());
        int xMax = Math.max(zoneA.func_177958_n(), zoneB.func_177958_n());
        int yMax = Math.max(zoneA.func_177956_o(), zoneB.func_177956_o());
        int zMax = Math.max(zoneA.func_177952_p(), zoneB.func_177952_p());
        if (xMin != this.x1 || xMax != this.x2 || yMin != this.y1 || yMax != this.y2 || zMin != this.z1 || zMax != this.z2) {
            this.x1 = xMin;
            this.y1 = yMin;
            this.z1 = zMin;
            this.x2 = xMax;
            this.y2 = yMax;
            this.z2 = zMax;
            this.setDirty();
        }
    }

    public void setMultiTarget(int minTargets, int maxTargets) {
        this.minTargets = minTargets;
        this.maxTargets = maxTargets;
    }

    public void setDirty() {
        this.targets.clear();
        this.acceptors.clear();
        this.startSearch();
    }

    public void startSearch() {
        this.state = State.SEARCHING;
        this.x = this.x1;
        this.y = this.y1;
        this.z = this.z1;
        this.searchAcceptors.clear();
    }

    public boolean hasTargets() {
        return this.targets.size() >= this.minTargets && this.targets.size() <= this.maxTargets;
    }

    public boolean hasMaxTargets() {
        return this.targets.size() == this.maxTargets;
    }

    private boolean moveCursor() {
        ++this.x;
        if (this.x > this.x2) {
            this.x = this.x1;
            ++this.y;
        }
        if (this.y > this.y2) {
            this.y = this.y1;
            ++this.z;
        }
        if (this.z > this.z2) {
            this.z = this.z1;
            return true;
        }
        return false;
    }

    public void next() {
        for (int i = 0; i < 88 && this.state == State.SEARCHING; ++i) {
            boolean looped;
            ILaserStorage laserStorage;
            BlockPos targetPos = Misc.posOffset(this.emitPos, new Vec3i(this.x, this.y, this.z), this.emitFacing);
            TileEntity target = this.world.func_175625_s(targetPos);
            if (!targetPos.equals((Object)this.emitPos) && target instanceof ILaserAcceptor && (laserStorage = ((ILaserAcceptor)target).getLaserStorage(this.emitFacing)) != null && laserStorage.receive(this.type, Integer.MAX_VALUE, true) > 0) {
                this.searchAcceptors.add((ILaserAcceptor)target);
            }
            if (!(looped = this.moveCursor())) continue;
            this.state = this.searchAcceptors.isEmpty() ? State.NOT_FOUND : State.FOUND;
        }
    }

    public boolean foundNew() {
        HashSet<ILaserAcceptor> test = new HashSet<ILaserAcceptor>(this.acceptors);
        for (ILaserAcceptor acceptor : this.searchAcceptors) {
            if (test.contains(acceptor)) continue;
            return true;
        }
        return false;
    }

    public void pickTarget() {
        this.acceptors.clear();
        this.acceptors.addAll(this.searchAcceptors);
        this.searchAcceptors.clear();
        this.targets.clear();
        int required = this.maxTargets;
        ArrayList<ILaserAcceptor> acceptorSet = new ArrayList<ILaserAcceptor>(this.acceptors);
        while (this.targets.size() < required && !acceptorSet.isEmpty()) {
            ILaserAcceptor acceptor = (ILaserAcceptor)acceptorSet.get(random.nextInt(acceptorSet.size()));
            this.targets.add(new Target(acceptor));
            acceptorSet.remove(acceptor);
        }
    }

    private double getDistance(ILaserAcceptor acceptor) {
        BlockPos pos = acceptor.getPosition();
        return pos.func_177951_i((Vec3i)this.emitPos);
    }

    public void fire(int power) {
        this.readTarget();
        boolean dirty = false;
        if (this.hasTargets()) {
            for (Target currentTarget : this.targets) {
                if (currentTarget.target.isValid()) {
                    int sent;
                    ILaserStorage storage = currentTarget.target.getLaserStorage(this.emitFacing);
                    if (storage == null || power <= 0) continue;
                    currentTarget.sent = sent = storage.receive(this.type, power, false);
                    continue;
                }
                dirty = true;
            }
        }
        if (dirty) {
            this.setDirty();
        }
    }

    private void readTarget() {
        if (this.world != null && !this.lazyTargets.isEmpty()) {
            this.targets.clear();
            Iterator<LazyTarget> iterator = this.lazyTargets.iterator();
            while (iterator.hasNext()) {
                LazyTarget target = iterator.next();
                TileEntity tile = this.world.func_175625_s(target.targetPos);
                if (tile instanceof ILaserAcceptor) {
                    this.targets.add(new Target((ILaserAcceptor)tile, target.sent));
                }
                iterator.remove();
            }
        }
    }

    public void render() {
        this.readTarget();
        if (this.visual != null && this.world != null && this.world.field_72995_K) {
            for (Target target : this.targets) {
                if (target.sent <= 0) {
                    System.out.println("Test2");
                }
                if (!target.target.isValid() || target.sent <= 0) continue;
                this.visual.render(this.world, this.emitPos, target.getPosition(), target.sent);
            }
        }
    }

    public boolean success() {
        return this.state == State.FOUND;
    }

    public boolean failure() {
        return this.state == State.NOT_FOUND;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        NBTTagList targetList = new NBTTagList();
        for (Target target : this.targets) {
            BlockPos pos = target.getPosition();
            NBTTagCompound targetCompound = new NBTTagCompound();
            targetCompound.func_74768_a("targetX", pos.func_177958_n());
            targetCompound.func_74768_a("targetY", pos.func_177956_o());
            targetCompound.func_74768_a("targetZ", pos.func_177952_p());
            targetCompound.func_74768_a("sent", target.sent);
            targetList.func_74742_a((NBTBase)targetCompound);
        }
        compound.func_74782_a("targets", (NBTBase)targetList);
        compound.func_74768_a("x1", this.x1);
        compound.func_74768_a("y1", this.y1);
        compound.func_74768_a("z1", this.z1);
        compound.func_74768_a("x2", this.x2);
        compound.func_74768_a("y2", this.y2);
        compound.func_74768_a("z2", this.z2);
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.state = State.NOT_FOUND;
        if (compound.func_74764_b("targets")) {
            this.lazyTargets.clear();
            NBTTagList targetList = compound.func_150295_c("targets", 10);
            for (int i = 0; i < targetList.func_74745_c(); ++i) {
                NBTTagCompound targetCompound = targetList.func_150305_b(i);
                BlockPos targetPos = new BlockPos(targetCompound.func_74762_e("targetX"), targetCompound.func_74762_e("targetY"), targetCompound.func_74762_e("targetZ"));
                this.lazyTargets.add(new LazyTarget(targetPos, targetCompound.func_74762_e("sent")));
                this.state = State.FOUND;
            }
        }
        this.x1 = compound.func_74762_e("x1");
        this.y1 = compound.func_74762_e("y1");
        this.z1 = compound.func_74762_e("z1");
        this.x2 = compound.func_74762_e("x2");
        this.y2 = compound.func_74762_e("y2");
        this.z2 = compound.func_74762_e("z2");
    }

    public static enum State {
        SEARCHING,
        FOUND,
        NOT_FOUND;

    }

    static class LazyTarget {
        BlockPos targetPos;
        int sent;

        public LazyTarget(BlockPos targetPos, int sent) {
            this.targetPos = targetPos;
            this.sent = sent;
        }
    }

    static class Target {
        ILaserAcceptor target;
        int sent;

        public Target(ILaserAcceptor target) {
            this.target = target;
        }

        public Target(ILaserAcceptor target, int sent) {
            this.target = target;
            this.sent = sent;
        }

        public BlockPos getPosition() {
            return this.target.getPosition();
        }
    }
}

