/*
 * Decompiled with CFR 0.152.
 */
package requious.recipe;

import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraftforge.fluids.FluidStack;
import requious.compat.crafttweaker.RecipeContainer;
import requious.compat.jei.JEISlot;
import requious.compat.jei.slot.FluidSlot;
import requious.data.component.ComponentBase;
import requious.data.component.ComponentFluid;
import requious.recipe.ConsumptionResult;
import requious.recipe.MatchResult;
import requious.recipe.RequirementBase;

public class RequirementFluid
extends RequirementBase {
    ILiquidStack ingredient;
    int min;
    int max;

    public RequirementFluid(String group, ILiquidStack ingredient) {
        this(group, ingredient, ingredient.getAmount(), ingredient.getAmount());
    }

    public RequirementFluid(String group, ILiquidStack ingredient, int min, int max) {
        super(group);
        this.ingredient = ingredient;
        this.min = min;
        this.max = max;
    }

    @Override
    public MatchResult matches(ComponentBase.Slot slot, ConsumptionResult result) {
        FluidStack stack;
        if (slot instanceof ComponentFluid.Slot && slot.isGroup(this.group) && (stack = ((ComponentFluid.Slot)slot).getContents()) != null && this.ingredient.matches(CraftTweakerMC.getILiquidStack((FluidStack)stack)) && stack.amount >= this.min) {
            result.add(Math.min(stack.amount, this.max));
            return MatchResult.MATCHED;
        }
        return MatchResult.NOT_MATCHED;
    }

    @Override
    public void fillContainer(ComponentBase.Slot slot, ConsumptionResult result, RecipeContainer container) {
        if (this.ingredient.getMark() != null) {
            container.addInput(this.ingredient.getMark(), ((ComponentFluid.Slot)slot).drain((Integer)result.getConsumed(), true));
        }
    }

    @Override
    public void consume(ComponentBase.Slot slot, ConsumptionResult result) {
        if (slot instanceof ComponentFluid.Slot && result instanceof ConsumptionResult.Integer) {
            ((ComponentFluid.Slot)slot).drain((Integer)result.getConsumed(), false);
        }
    }

    @Override
    public ConsumptionResult createResult() {
        return new ConsumptionResult.Integer((RequirementBase)this, 0);
    }

    @Override
    public boolean fillJEI(JEISlot slot) {
        if (slot instanceof FluidSlot && slot.group.equals(this.group) && !slot.isFilled()) {
            FluidSlot fluidSlot = (FluidSlot)slot;
            if (this.ingredient.getLiquids() != null) {
                for (ILiquidStack fluid : this.ingredient.getLiquids()) {
                    fluidSlot.addFluid(CraftTweakerMC.getLiquidStack((ILiquidStack)fluid));
                }
            }
            fluidSlot.setInput(true);
            return true;
        }
        return false;
    }
}

