/*
 * Decompiled with CFR 0.152.
 */
package requious.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import requious.compat.crafttweaker.IWorldFunction;
import requious.compat.crafttweaker.MachineContainer;
import requious.compat.crafttweaker.RecipeContainer;
import requious.data.AssemblyData;
import requious.data.component.ComponentBase;
import requious.data.component.ComponentEnergy;
import requious.data.component.ComponentFluid;
import requious.data.component.ComponentItem;
import requious.data.component.ComponentLaser;
import requious.recipe.AssemblyRecipe;
import requious.recipe.ConsumptionResult;
import requious.tile.TileEntityAssembly;
import requious.util.CheckCache;
import requious.util.ILaserStorage;
import requious.util.MachineCommandSender;
import requious.util.MachineVisual;

public class AssemblyProcessor {
    AssemblyData data;
    ComponentBase.Slot[][] slots = new ComponentBase.Slot[9][5];
    List<ComponentBase.Collector> collectors = new ArrayList<ComponentBase.Collector>();
    TileEntity tile;
    Map<String, CheckCache> cache = new HashMap<String, CheckCache>();
    Map<String, Object> variables = new HashMap<String, Object>();
    Map<String, Object> variablesHistory = new HashMap<String, Object>();
    MachineContainer container;
    MachineCommandSender commandSender;

    public AssemblyProcessor(AssemblyData data) {
        this.data = data;
        this.container = new MachineContainer(this);
        this.commandSender = new MachineCommandSender(this);
    }

    public boolean isActive() {
        return this.container.getInteger("active") > 0;
    }

    public MachineCommandSender getCommandSender() {
        return this.commandSender;
    }

    public TileEntity getTile() {
        return this.tile;
    }

    public EnumFacing getFacing() {
        if (this.tile instanceof TileEntityAssembly) {
            return ((TileEntityAssembly)this.tile).getFacing();
        }
        return EnumFacing.UP;
    }

    public void setOwner(EntityPlayer player) {
        this.setVariable("owner", player.func_70005_c_());
        this.setVariable("ownerUUID", player.func_146103_bH().getId().toString());
        this.tile.func_70296_d();
    }

    public String getCommandName() {
        Object commandName = this.getVariable("commandName");
        if (commandName != null) {
            return commandName.toString();
        }
        return "@";
    }

    public Object getVariable(String name) {
        return this.variables.get(name);
    }

    public void setVariable(String name, Object value) {
        this.variables.put(name, value);
        this.tile.func_70296_d();
    }

    public void stashVariable(String name) {
        this.variablesHistory.put(name, this.getVariable(name));
    }

    public Object getHistory(String name) {
        return this.variablesHistory.get(name);
    }

    public boolean isCacheInvalid(String type, long time, long interval) {
        CheckCache check = this.cache.get(type);
        return check == null || check.getTicksSinceLastCheck(time) > interval;
    }

    public boolean getCacheResult(String type) {
        CheckCache check = this.cache.get(type);
        return check.getResult();
    }

    public void setCacheResult(String type, boolean result, long time) {
        CheckCache check = this.cache.computeIfAbsent(type, k -> new CheckCache());
        check.setResult(result, time);
    }

    public ItemStack insertItem(String group, ItemStack stack) {
        for (ComponentBase.Slot slot : this.getSlots()) {
            ItemStack remainder;
            if (!(slot instanceof ComponentItem.Slot) || !slot.isGroup(group) || (remainder = ((ComponentItem.Slot)slot).getItem().insert(stack, false)).func_190916_E() >= stack.func_190916_E()) continue;
            return remainder;
        }
        return stack;
    }

    public ItemStack extractItem(String group, Predicate<ItemStack> filter, int n) {
        for (ComponentBase.Slot slot : this.getSlots()) {
            ComponentItem.Slot itemSlot;
            ItemStack extracted;
            if (!(slot instanceof ComponentItem.Slot) || !slot.isGroup(group) || (extracted = (itemSlot = (ComponentItem.Slot)slot).getItem().extract(n, true)).func_190916_E() < n || !filter.test(extracted)) continue;
            itemSlot.getItem().extract(n, false);
            return extracted;
        }
        return ItemStack.field_190927_a;
    }

    public FluidStack insertFluid(String group, FluidStack stack) {
        for (ComponentBase.Slot slot : this.getSlots()) {
            int filled;
            if (!(slot instanceof ComponentFluid.Slot) || !slot.isGroup(group) || (filled = ((ComponentFluid.Slot)slot).fill(stack, false)) <= 0) continue;
            stack.amount = Math.max(0, stack.amount - filled);
            if (stack.amount > 0) {
                return stack;
            }
            return null;
        }
        return stack;
    }

    public FluidStack extractFluid(String group, Predicate<FluidStack> filter, int n) {
        for (ComponentBase.Slot slot : this.getSlots()) {
            ComponentFluid.Slot fluidSlot;
            FluidStack extracted;
            if (!(slot instanceof ComponentFluid.Slot) || !slot.isGroup(group) || (extracted = (fluidSlot = (ComponentFluid.Slot)slot).drain(n, true)) == null || extracted.amount < n || !filter.test(extracted)) continue;
            fluidSlot.drain(n, false);
            return extracted;
        }
        return null;
    }

    public int insertEnergy(String group, int energy) {
        for (ComponentBase.Slot slot : this.getSlots()) {
            int filled;
            if (!(slot instanceof ComponentEnergy.Slot) || !slot.isGroup(group) || (filled = ((ComponentEnergy.Slot)slot).receive(energy, false)) <= 0) continue;
            return energy - filled;
        }
        return energy;
    }

    public int extractEnergy(String group, int energy) {
        for (ComponentBase.Slot slot : this.getSlots()) {
            int filled;
            if (!(slot instanceof ComponentEnergy.Slot) || !slot.isGroup(group) || (filled = ((ComponentEnergy.Slot)slot).extract(energy, false)) <= 0) continue;
            return filled;
        }
        return 0;
    }

    public Iterable<MachineVisual> getVisuals() {
        return this.data.getVisuals();
    }

    public boolean check(IWorldFunction worldCheck, String group, long interval) {
        if (this.tile == null || this.tile.func_145831_w() == null) {
            return false;
        }
        long time = this.tile.func_145831_w().func_82737_E();
        if (this.isCacheInvalid(group, time, interval)) {
            boolean checkResult = worldCheck.run(this.container);
            this.setCacheResult(group, checkResult, time);
            return checkResult;
        }
        return this.getCacheResult(group);
    }

    public boolean run(IWorldFunction worldCheck) {
        if (this.tile == null || this.tile.func_145831_w() == null) {
            return false;
        }
        return worldCheck.run(this.container);
    }

    private NBTBase serializeVariable(Object value) {
        if (value instanceof Integer) {
            return new NBTTagInt(((Integer)value).intValue());
        }
        if (value instanceof Double) {
            return new NBTTagDouble(((Double)value).doubleValue());
        }
        if (value instanceof String) {
            return new NBTTagString((String)value);
        }
        if (value instanceof ItemStack) {
            NBTTagCompound stackCompound = ((ItemStack)value).serializeNBT();
            stackCompound.func_74778_a("CompoundType", "ItemStack");
            return stackCompound;
        }
        if (value instanceof FluidStack) {
            NBTTagCompound stackCompound = ((FluidStack)value).writeToNBT(new NBTTagCompound());
            stackCompound.func_74778_a("CompoundType", "FluidStack");
            return stackCompound;
        }
        return null;
    }

    private Object deserializeVariable(NBTBase nbt) {
        if (nbt instanceof NBTTagInt) {
            return ((NBTTagInt)nbt).func_150287_d();
        }
        if (nbt instanceof NBTTagDouble) {
            return ((NBTTagDouble)nbt).func_150286_g();
        }
        if (nbt instanceof NBTTagString) {
            return ((NBTTagString)nbt).func_150285_a_();
        }
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound compound = (NBTTagCompound)nbt;
            String type = compound.func_74779_i("CompoundType");
            if (type.equals("ItemStack")) {
                return new ItemStack(compound);
            }
            if (type.equals("FluidStack")) {
                return FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound);
            }
        }
        return null;
    }

    private NBTTagCompound serializeVariables() {
        NBTTagCompound variableCompound = new NBTTagCompound();
        for (Map.Entry<String, Object> entry : this.variables.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            NBTBase serialized = this.serializeVariable(value);
            if (serialized == null) continue;
            variableCompound.func_74782_a(key, serialized);
        }
        return variableCompound;
    }

    private void deserializeVariables(NBTTagCompound variableCompound) {
        this.variables.clear();
        for (String key : variableCompound.func_150296_c()) {
            NBTBase variableEntry = variableCompound.func_74781_a(key);
            Object deserialized = this.deserializeVariable(variableEntry);
            if (deserialized == null) continue;
            this.variables.put(key, deserialized);
        }
    }

    private NBTTagCompound serializeCache() {
        NBTTagCompound cacheCompound = new NBTTagCompound();
        for (Map.Entry<String, CheckCache> entry : this.cache.entrySet()) {
            NBTTagCompound cacheEntry = new NBTTagCompound();
            CheckCache cache = entry.getValue();
            cacheEntry.func_74772_a("time", cache.getCheckTime());
            cacheEntry.func_74757_a("result", cache.getResult());
            cacheCompound.func_74782_a(entry.getKey(), (NBTBase)cacheEntry);
        }
        return cacheCompound;
    }

    private void deserializeCache(NBTTagCompound cacheCompound) {
        this.cache.clear();
        for (String key : cacheCompound.func_150296_c()) {
            NBTTagCompound cacheEntry = cacheCompound.func_74775_l(key);
            this.cache.put(key, new CheckCache(cacheEntry.func_74767_n("result"), cacheEntry.func_74763_f("time")));
        }
    }

    public void setComponent(ComponentBase[][] components) {
        for (int x = 0; x < components.length; ++x) {
            for (int y = 0; y < components[x].length; ++y) {
                ComponentBase component = components[x][y];
                if (component == null) continue;
                this.slots[x][y] = component.createSlot();
            }
        }
    }

    private void addToCollector(ComponentBase.Slot slot) {
        slot.addCollectors(this.collectors);
        for (ComponentBase.Collector collector : this.collectors) {
            collector.accept(slot);
        }
    }

    public void setup() {
        for (int x = 0; x < this.slots.length; ++x) {
            for (int y = 0; y < this.slots[x].length; ++y) {
                ComponentBase.Slot slot = this.slots[x][y];
                if (slot == null) continue;
                this.addToCollector(slot);
            }
        }
    }

    public void setTile(TileEntity tile) {
        this.tile = tile;
        for (ComponentBase.Collector collector : this.collectors) {
            collector.setTile(tile);
        }
        this.setVariable("commandName", "@");
    }

    public ComponentBase.Slot getSlot(int x, int y) {
        if (x < 0 || x >= this.slots.length || y < 0 || y >= this.slots[x].length) {
            return null;
        }
        return this.slots[x][y];
    }

    public List<ComponentBase.Slot> getSlots() {
        ArrayList<ComponentBase.Slot> rList = new ArrayList<ComponentBase.Slot>();
        for (int x = 0; x < this.slots.length; ++x) {
            for (int y = 0; y < this.slots[x].length; ++y) {
                ComponentBase.Slot slot = this.slots[x][y];
                if (slot == null) continue;
                rList.add(slot);
            }
        }
        return rList;
    }

    public void update() {
        this.container.setInteger("active", this.container.getInteger("active") - 1);
        for (int x = 0; x < this.slots.length; ++x) {
            for (int y = 0; y < this.slots[x].length; ++y) {
                ComponentBase.Slot slot = this.slots[x][y];
                if (slot == null) continue;
                slot.update();
            }
        }
        for (ComponentBase.Collector collector : this.collectors) {
            collector.update();
        }
        boolean recipeCrafted = false;
        for (List<AssemblyRecipe> recipes : this.data.recipes.values()) {
            for (AssemblyRecipe recipe : recipes) {
                RecipeContainer container;
                List<ConsumptionResult> results = recipe.matches(this, container = new RecipeContainer(this.container));
                if (results == null || recipeCrafted) continue;
                recipe.calculate(container);
                if (!recipe.fitsResults(this, container)) continue;
                recipe.consumeRequirements(results);
                recipe.produceResults(this, container);
                recipeCrafted = true;
            }
        }
        for (ComponentBase.Collector collector : this.collectors) {
            collector.updatePost(recipeCrafted);
        }
    }

    public void machineBroken(World world, Vec3d position) {
        for (int x = 0; x < this.slots.length; ++x) {
            for (int y = 0; y < this.slots[x].length; ++y) {
                ComponentBase.Slot slot = this.slots[x][y];
                if (slot == null) continue;
                slot.machineBroken(world, position);
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        for (int x = 0; x < this.slots.length; ++x) {
            for (int y = 0; y < this.slots[x].length; ++y) {
                ComponentBase.Slot slot = this.slots[x][y];
                if (slot == null) continue;
                compound.func_74782_a(x + "_" + y, slot.serializeNBT());
            }
        }
        compound.func_74782_a("variables", (NBTBase)this.serializeVariables());
        compound.func_74782_a("cache", (NBTBase)this.serializeCache());
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        for (int x = 0; x < this.slots.length; ++x) {
            for (int y = 0; y < this.slots[x].length; ++y) {
                ComponentBase.Slot slot = this.slots[x][y];
                if (slot == null) continue;
                slot.deserializeNBT((NBTBase)compound.func_74775_l(x + "_" + y));
            }
        }
        this.deserializeVariables(compound.func_74775_l("variables"));
        this.deserializeCache(compound.func_74775_l("cache"));
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing localSide, @Nullable EnumFacing globalSide) {
        for (ComponentBase.Collector collector : this.collectors) {
            if (!collector.hasCapability() || !collector.hasCapability(capability, localSide, globalSide)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing localSide, @Nullable EnumFacing globalSide) {
        T instance = null;
        for (ComponentBase.Collector collector : this.collectors) {
            if (collector.hasCapability()) {
                instance = collector.getCapability(capability, localSide, globalSide);
            }
            if (instance == null) continue;
            break;
        }
        return instance;
    }

    public ILaserStorage getLaserAcceptor(EnumFacing localSide, EnumFacing globalSide) {
        for (ComponentBase.Collector collector : this.collectors) {
            if (!(collector instanceof ComponentLaser.Collector) || !((ComponentLaser.Collector)collector).getFace().matches(localSide, globalSide)) continue;
            return (ILaserStorage)((Object)collector);
        }
        return null;
    }

    public ComponentEnergy.CollectorIC2 getIC2Handler() {
        for (ComponentBase.Collector collector : this.collectors) {
            if (!(collector instanceof ComponentEnergy.CollectorIC2)) continue;
            return (ComponentEnergy.CollectorIC2)collector;
        }
        return null;
    }

    public boolean isDirty() {
        boolean dirty = false;
        for (int x = 0; x < this.slots.length; ++x) {
            for (int y = 0; y < this.slots[x].length; ++y) {
                ComponentBase.Slot slot = this.slots[x][y];
                if (slot == null || !slot.isDirty()) continue;
                dirty = true;
                slot.markClean();
            }
        }
        return dirty;
    }
}

