/*
 * Decompiled with CFR 0.152.
 */
package requious;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import requious.block.BlockAssembly;
import requious.block.BlockEmitter;
import requious.block.BlockFluidEmitter;
import requious.block.BlockRedEmitter;
import requious.block.IDynamicModel;
import requious.data.AssemblyData;
import requious.data.BatteryData;
import requious.data.FluidCellData;
import requious.data.FluidEmitterData;
import requious.data.RedEmitterData;
import requious.entity.EntitySpark;
import requious.entity.spark.TargetTile;
import requious.entity.spark.ValueFluid;
import requious.entity.spark.ValueForgeEnergy;
import requious.item.IDynamicItemModel;
import requious.item.ItemBattery;
import requious.item.ItemFluidCell;
import requious.item.ItemShape;
import requious.item.ItemTuningFork;
import requious.model.ModelShape;
import requious.tile.TileEntityAssembly;
import requious.tile.TileEntityAssemblyRenderer;
import requious.util.AABBTypeAdapter;
import requious.util.ColorTypeAdapter;
import requious.util.LaserVisual;
import requious.util.ResourceLocationTypeAdapter;

public class Registry {
    public static List<RedEmitterData> RED_EMITTER_DATA = new ArrayList<RedEmitterData>();
    public static List<FluidEmitterData> FLUID_EMITTER_DATA = new ArrayList<FluidEmitterData>();
    public static List<AssemblyData> ASSEMBLY_DATA = new ArrayList<AssemblyData>();
    public static List<FluidCellData> FLUID_CELL_DATA = new ArrayList<FluidCellData>();
    public static List<BatteryData> BATTERY_DATA = new ArrayList<BatteryData>();
    public static List<BlockRedEmitter> RED_EMITTERS = new ArrayList<BlockRedEmitter>();
    public static List<BlockFluidEmitter> FLUID_EMITTERS = new ArrayList<BlockFluidEmitter>();
    @GameRegistry.ObjectHolder(value="requious:tuning_fork")
    public static Item TUNING_FORK;
    @GameRegistry.ObjectHolder(value="requious:shape")
    public static ItemShape SHAPE;

    public static AssemblyData getAssemblyData(String name) {
        return ASSEMBLY_DATA.stream().filter(data -> data.resourceName.equals(name)).findFirst().orElse(null);
    }

    public static BatteryData getBatteryData(String name) {
        return BATTERY_DATA.stream().filter(data -> data.resourceName.equals(name)).findFirst().orElse(null);
    }

    public static FluidCellData getFluidCellData(String name) {
        return FLUID_CELL_DATA.stream().filter(data -> data.resourceName.equals(name)).findFirst().orElse(null);
    }

    public static void init() {
        EntitySpark.registerValue(new ValueForgeEnergy.Deserializer());
        EntitySpark.registerValue(new ValueFluid.Deserializer());
        EntitySpark.registerTarget(new TargetTile.Deserializer());
        LaserVisual.register("beam", LaserVisual.Beam::new);
        LaserVisual.register("lightning", LaserVisual.Lightning::new);
        LaserVisual.register("fire_beam", LaserVisual.FireBeam::new);
    }

    @SubscribeEvent
    public static void onUse(PlayerInteractEvent.RightClickItem event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
    }

    public static void initColors() {
        Object emitter;
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        for (BlockRedEmitter blockRedEmitter : RED_EMITTERS) {
            blockColors.func_186722_a(Registry::colorMultiplierDynamicBlock, new Block[]{blockRedEmitter});
            itemColors.func_186731_a(Registry::colorMultiplierDynamicItemBlock, new Block[]{blockRedEmitter});
        }
        for (BlockFluidEmitter blockFluidEmitter : FLUID_EMITTERS) {
            blockColors.func_186722_a(Registry::colorMultiplierDynamicBlock, new Block[]{blockFluidEmitter});
            itemColors.func_186731_a(Registry::colorMultiplierDynamicItemBlock, new Block[]{blockFluidEmitter});
        }
        for (AssemblyData assemblyData : ASSEMBLY_DATA) {
            emitter = assemblyData.getBlock();
            blockColors.func_186722_a(Registry::colorMultiplierDynamicBlock, new Block[]{emitter});
            itemColors.func_186731_a(Registry::colorMultiplierDynamicItemBlock, new Block[]{emitter});
        }
        for (FluidCellData fluidCellData : FLUID_CELL_DATA) {
            emitter = fluidCellData.getItem();
            itemColors.func_186730_a(Registry::colorMultiplierDynamicItem, new Item[]{emitter});
        }
        for (BatteryData batteryData : BATTERY_DATA) {
            emitter = batteryData.getItem();
            itemColors.func_186730_a(Registry::colorMultiplierDynamicItem, new Item[]{emitter});
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        BlockEmitter emitter;
        for (RedEmitterData redEmitterData : RED_EMITTER_DATA) {
            emitter = (BlockRedEmitter)((Block)new BlockRedEmitter(Material.field_151573_f, redEmitterData).setRegistryName("requious", redEmitterData.resourceName)).func_149663_c(redEmitterData.resourceName).func_149647_a(CreativeTabs.field_78028_d).func_149711_c(5.0f).func_149752_b(10.0f);
            event.getRegistry().register((IForgeRegistryEntry)emitter);
            RED_EMITTERS.add((BlockRedEmitter)emitter);
        }
        for (FluidEmitterData fluidEmitterData : FLUID_EMITTER_DATA) {
            emitter = (BlockFluidEmitter)((Block)new BlockFluidEmitter(Material.field_151573_f, fluidEmitterData).setRegistryName("requious", fluidEmitterData.resourceName)).func_149663_c(fluidEmitterData.resourceName).func_149647_a(CreativeTabs.field_78028_d).func_149711_c(5.0f).func_149752_b(10.0f);
            event.getRegistry().register((IForgeRegistryEntry)emitter);
            FLUID_EMITTERS.add((BlockFluidEmitter)emitter);
        }
        for (AssemblyData assemblyData : ASSEMBLY_DATA) {
            BlockAssembly assembly = (BlockAssembly)((Block)new BlockAssembly(Material.field_151573_f, assemblyData).setRegistryName("requious", assemblyData.resourceName)).func_149663_c(assemblyData.resourceName).func_149647_a(CreativeTabs.field_78028_d).func_149711_c(5.0f).func_149752_b(10.0f);
            event.getRegistry().register((IForgeRegistryEntry)assembly);
            assemblyData.setBlock(assembly);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        Item cell;
        for (BlockRedEmitter blockRedEmitter : RED_EMITTERS) {
            event.getRegistry().register(new ItemBlock((Block)blockRedEmitter).setRegistryName(blockRedEmitter.getRegistryName()));
        }
        for (BlockFluidEmitter blockFluidEmitter : FLUID_EMITTERS) {
            event.getRegistry().register(new ItemBlock((Block)blockFluidEmitter).setRegistryName(blockFluidEmitter.getRegistryName()));
        }
        for (AssemblyData assemblyData : ASSEMBLY_DATA) {
            BlockAssembly assembly = assemblyData.getBlock();
            event.getRegistry().register(new ItemBlock((Block)assembly).setRegistryName(assembly.getRegistryName()));
        }
        for (FluidCellData fluidCellData : FLUID_CELL_DATA) {
            cell = (ItemFluidCell)((Item)new ItemFluidCell(fluidCellData).setRegistryName(fluidCellData.resourceName)).func_77655_b(fluidCellData.resourceName).func_77637_a(CreativeTabs.field_78038_k);
            event.getRegistry().register((IForgeRegistryEntry)cell);
            fluidCellData.setItem((ItemFluidCell)cell);
        }
        for (BatteryData batteryData : BATTERY_DATA) {
            cell = (ItemBattery)((Item)new ItemBattery(batteryData).setRegistryName(batteryData.resourceName)).func_77655_b(batteryData.resourceName).func_77637_a(CreativeTabs.field_78028_d);
            event.getRegistry().register((IForgeRegistryEntry)cell);
            batteryData.setItem((ItemBattery)cell);
        }
        TUNING_FORK = ((Item)new ItemTuningFork().setRegistryName(new ResourceLocation("requious", "tuning_fork"))).func_77655_b("tuning_fork").func_77637_a(CreativeTabs.field_78028_d);
        event.getRegistry().register((IForgeRegistryEntry)TUNING_FORK);
        SHAPE = (ItemShape)((Item)new ItemShape().setRegistryName(new ResourceLocation("requious", "shape"))).func_77655_b("shape").func_77637_a(CreativeTabs.field_78028_d);
        event.getRegistry().register((IForgeRegistryEntry)SHAPE);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        Item cell;
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAssembly.class, (TileEntitySpecialRenderer)new TileEntityAssemblyRenderer());
        for (BlockRedEmitter blockRedEmitter : RED_EMITTERS) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)blockRedEmitter), (int)0, (ModelResourceLocation)new ModelResourceLocation(blockRedEmitter.getRedirect(), "inventory"));
            ModelLoader.setCustomStateMapper((Block)blockRedEmitter, (IStateMapper)new DynamicStateMapper());
        }
        for (BlockFluidEmitter blockFluidEmitter : FLUID_EMITTERS) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)blockFluidEmitter), (int)0, (ModelResourceLocation)new ModelResourceLocation(blockFluidEmitter.getRedirect(), "inventory"));
            ModelLoader.setCustomStateMapper((Block)blockFluidEmitter, (IStateMapper)new DynamicStateMapper());
        }
        for (AssemblyData assemblyData : ASSEMBLY_DATA) {
            BlockAssembly assembly = assemblyData.getBlock();
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)assembly), (int)0, (ModelResourceLocation)new ModelResourceLocation(assembly.getRedirect(), "inventory"));
            for (int i = 0; i < assemblyData.extraVariants.length; ++i) {
                ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)assembly), (int)(i + 1), (ModelResourceLocation)new ModelResourceLocation(assemblyData.extraVariants[i]));
            }
            ModelLoader.setCustomStateMapper((Block)assembly, (IStateMapper)new DynamicStateMapper());
        }
        for (FluidCellData fluidCellData : FLUID_CELL_DATA) {
            cell = fluidCellData.getItem();
            ModelLoader.setCustomModelResourceLocation((Item)cell, (int)0, (ModelResourceLocation)new ModelResourceLocation(fluidCellData.model, "inventory"));
        }
        for (BatteryData batteryData : BATTERY_DATA) {
            cell = batteryData.getItem();
            ModelLoader.setCustomModelResourceLocation((Item)cell, (int)0, (ModelResourceLocation)new ModelResourceLocation(batteryData.model, "inventory"));
        }
        this.registerItemModel(TUNING_FORK, 0, "inventory");
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelShape.Loader(new ResourceLocation("requious", "shape_custom")));
        ModelResourceLocation toolShardLocation = new ModelResourceLocation(SHAPE.getRegistryName(), "inventory");
        ModelLoader.setCustomMeshDefinition((Item)SHAPE, stack -> toolShardLocation);
        ModelBakery.registerItemVariants((Item)SHAPE, (ResourceLocation[])new ResourceLocation[]{toolShardLocation});
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent event) {
        TextureMap map = event.getMap();
        map.func_174942_a(new ResourceLocation("requious", "items/shape_circle"));
        map.func_174942_a(new ResourceLocation("requious", "items/shape_star"));
        map.func_174942_a(new ResourceLocation("requious", "items/shape_square"));
        map.func_174942_a(new ResourceLocation("requious", "items/shape_sideways"));
        map.func_174942_a(new ResourceLocation("requious", "items/shape_windmill"));
    }

    private static int colorMultiplierDynamicBlock(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        IDynamicModel redirector = (IDynamicModel)state.func_177230_c();
        return redirector.getTint(tintIndex).getRGB();
    }

    private static int colorMultiplierDynamicItemBlock(ItemStack stack, int tintIndex) {
        ItemBlock itemBlock = (ItemBlock)stack.func_77973_b();
        Block block = itemBlock.func_179223_d();
        if (block instanceof IDynamicModel) {
            return ((IDynamicModel)block).getTint(tintIndex).getRGB();
        }
        return -1;
    }

    private static int colorMultiplierDynamicItem(ItemStack stack, int tintIndex) {
        Item item = stack.func_77973_b();
        if (item instanceof IDynamicItemModel) {
            return ((IDynamicItemModel)item).getTint(stack, tintIndex).getRGB();
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModel(@Nonnull Item item, int meta, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), variant));
    }

    public static void loadEmitterData(File file) {
        Gson gson = new GsonBuilder().setLenient().setPrettyPrinting().registerTypeAdapter(Color.class, (Object)new ColorTypeAdapter()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocationTypeAdapter()).registerTypeAdapter(AxisAlignedBB.class, (Object)new AABBTypeAdapter()).create();
        File configFolder = new File(file, "requious");
        if (!configFolder.exists()) {
            configFolder.mkdir();
        }
        Registry.readEmitterData(RedEmitterData.class, gson, new File(configFolder, "red_emitter.json"), Registry::addRedEmitter, Registry::getRedEmitterDefaults);
        Registry.readEmitterData(FluidEmitterData.class, gson, new File(configFolder, "fluid_emitter.json"), Registry::addFluidEmitter, Registry::getFluidEmitterDefaults);
        Registry.readEmitterData(AssemblyData.class, gson, new File(configFolder, "assembly.json"), Registry::addAssembly, Registry::getAssemblyDefaults);
        Registry.readEmitterData(FluidCellData.class, gson, new File(configFolder, "fluid_cell.json"), Registry::addFluidCell, Registry::getFluidCellDefaults);
        Registry.readEmitterData(BatteryData.class, gson, new File(configFolder, "battery.json"), Registry::addBattery, Registry::getBatteryDefaults);
    }

    private static <T> void readEmitterData(Class<T> type, Gson gson, File configJson, Consumer<T> consumer, Supplier<Iterable<T>> defaultData) {
        try {
            if (configJson.exists()) {
                JsonReader reader = gson.newJsonReader((Reader)new FileReader(configJson));
                JsonParser parser = new JsonParser();
                JsonArray root = (JsonArray)parser.parse(reader);
                for (JsonElement element : root) {
                    if (!element.isJsonObject()) continue;
                    Object datum = gson.fromJson(element, type);
                    consumer.accept(datum);
                }
                reader.close();
            } else {
                JsonWriter writer = gson.newJsonWriter((Writer)new FileWriter(configJson));
                Iterable<T> data = defaultData.get();
                writer.beginArray();
                for (T datum : data) {
                    gson.toJson(datum, type, writer);
                    consumer.accept(datum);
                }
                writer.endArray();
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Iterable<RedEmitterData> getRedEmitterDefaults() {
        ArrayList<RedEmitterData> list = new ArrayList<RedEmitterData>();
        RedEmitterData basic = new RedEmitterData();
        basic.resourceName = "red_emitter_basic";
        basic.model = new ResourceLocation("requious", "red_emitter");
        basic.capacity = 64;
        basic.interval = 40;
        list.add(basic);
        RedEmitterData advanced = new RedEmitterData();
        advanced.resourceName = "red_emitter_advanced";
        advanced.model = new ResourceLocation("requious", "red_emitter");
        advanced.capacity = 128;
        advanced.interval = 20;
        list.add(advanced);
        return list;
    }

    private static Iterable<FluidEmitterData> getFluidEmitterDefaults() {
        ArrayList<FluidEmitterData> list = new ArrayList<FluidEmitterData>();
        FluidEmitterData liquidOnly = new FluidEmitterData();
        liquidOnly.resourceName = "liquid_emitter";
        liquidOnly.model = new ResourceLocation("requious", "fluid_emitter");
        liquidOnly.capacity = 1000;
        liquidOnly.interval = 40;
        list.add(liquidOnly);
        FluidEmitterData gasOnly = new FluidEmitterData();
        gasOnly.resourceName = "gas_emitter";
        gasOnly.model = new ResourceLocation("requious", "fluid_emitter");
        gasOnly.capacity = 1000;
        gasOnly.interval = 40;
        list.add(gasOnly);
        return list;
    }

    private static Iterable<AssemblyData> getAssemblyDefaults() {
        ArrayList<AssemblyData> list = new ArrayList<AssemblyData>();
        AssemblyData itemGate = new AssemblyData();
        itemGate.resourceName = "item_gate";
        itemGate.model = new ResourceLocation("requious", "assembly_block");
        list.add(itemGate);
        AssemblyData laser = new AssemblyData();
        laser.resourceName = "laser";
        laser.model = new ResourceLocation("requious", "assembly_laser");
        list.add(laser);
        AssemblyData assembler = new AssemblyData();
        assembler.resourceName = "assembler";
        assembler.model = new ResourceLocation("requious", "assembly_slab");
        list.add(assembler);
        return list;
    }

    private static Iterable<FluidCellData> getFluidCellDefaults() {
        ArrayList<FluidCellData> list = new ArrayList<FluidCellData>();
        FluidCellData cell = new FluidCellData();
        cell.resourceName = "cell";
        cell.model = new ResourceLocation("requious", "cell");
        cell.colorsSerialized = new Color[]{new Color(255, 255, 255)};
        cell.generateSubItems = true;
        cell.capacity = 1000;
        list.add(cell);
        return list;
    }

    private static Iterable<BatteryData> getBatteryDefaults() {
        ArrayList<BatteryData> list = new ArrayList<BatteryData>();
        BatteryData cell = new BatteryData();
        cell.resourceName = "battery_copper";
        cell.model = new ResourceLocation("requious", "battery_small");
        cell.colorsSerialized = new Color[]{new Color(220, 64, 16), new Color(255, 192, 64)};
        cell.capacity = 1000;
        list.add(cell);
        cell = new BatteryData();
        cell.resourceName = "battery_iron";
        cell.model = new ResourceLocation("requious", "battery_medium_fill0");
        cell.colorsSerialized = new Color[]{new Color(255, 255, 255), new Color(255, 192, 64), new Color(255, 0, 0)};
        cell.capacity = 2000;
        list.add(cell);
        cell = new BatteryData();
        cell.resourceName = "energy_gem";
        cell.model = new ResourceLocation("requious", "energy_diamond");
        cell.colorsSerialized = new Color[]{new Color(255, 0, 0), new Color(255, 192, 192)};
        cell.capacity = 64000;
        list.add(cell);
        cell = new BatteryData();
        cell.resourceName = "lapotron";
        cell.model = new ResourceLocation("requious", "lapotron_diamond");
        cell.colorsSerialized = new Color[]{new Color(0, 0, 255), new Color(192, 192, 255), new Color(255, 255, 255)};
        cell.capacity = 256000;
        list.add(cell);
        cell = new BatteryData();
        cell.resourceName = "lapotron_orb";
        cell.model = new ResourceLocation("requious", "containment_gem");
        cell.colorsSerialized = new Color[]{new Color(255, 255, 255), new Color(0, 0, 255)};
        cell.capacity = 2048000;
        list.add(cell);
        cell = new BatteryData();
        cell.resourceName = "quantron";
        cell.model = new ResourceLocation("requious", "lapotron_emerald");
        cell.colorsSerialized = new Color[]{new Color(128, 255, 0), new Color(255, 255, 192), new Color(64, 64, 64)};
        cell.capacity = 68000000;
        list.add(cell);
        cell = new BatteryData();
        cell.resourceName = "positron_unit";
        cell.model = new ResourceLocation("requious", "containment_fill0");
        cell.colorsSerialized = new Color[]{new Color(128, 255, 192), new Color(255, 255, 0)};
        cell.capacity = 1000000000;
        list.add(cell);
        return list;
    }

    private static void addRedEmitter(RedEmitterData data) {
        RED_EMITTER_DATA.add(data);
        data.init();
    }

    private static void addFluidEmitter(FluidEmitterData data) {
        FLUID_EMITTER_DATA.add(data);
        data.init();
    }

    private static void addAssembly(AssemblyData data) {
        ASSEMBLY_DATA.add(data);
        data.init();
    }

    private static void addFluidCell(FluidCellData data) {
        FLUID_CELL_DATA.add(data);
        data.init();
    }

    private static void addBattery(BatteryData data) {
        BATTERY_DATA.add(data);
        data.init();
    }

    private static class DynamicStateMapper
    extends StateMapperBase {
        private DynamicStateMapper() {
        }

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            IDynamicModel redirector = (IDynamicModel)state.func_177230_c();
            LinkedHashMap map = Maps.newLinkedHashMap((Map)state.func_177228_b());
            return new ModelResourceLocation(redirector.getRedirect(), this.func_178131_a(map));
        }
    }
}

