/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui.guielements;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.projectintelligence.client.PITextures;
import com.brandon3055.projectintelligence.client.StyleHandler;
import com.brandon3055.projectintelligence.client.gui.PIPartRenderer;
import com.brandon3055.projectintelligence.client.gui.guielements.GuiActiveDownloads;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;

public class GuiNotifications
extends MGuiElementBase<GuiNotifications> {
    private static StyleHandler.PropertyGroup windowProps = new StyleHandler.PropertyGroup("user_dialogs");
    private static StyleHandler.PropertyGroup buttonProps = new StyleHandler.PropertyGroup("user_dialogs.button_style");
    private PIPartRenderer windowRenderer = new PIPartRenderer(windowProps);
    private static Queue<NotifyInfo> notifyQueue = new LinkedList<NotifyInfo>();
    private IModularGui parent;
    private GuiActiveDownloads downloadsUI;
    private LinkedList<Notification> notifications = new LinkedList();
    private Notification lastAdded = null;
    private int tick = 0;
    private int yOffset = 0;

    public GuiNotifications(IModularGui parent, GuiActiveDownloads downloadsUI) {
        this.parent = parent;
        this.downloadsUI = downloadsUI;
    }

    public static void addNotification(String text, boolean autoClose) {
        notifyQueue.add(new NotifyInfo(text, autoClose));
    }

    public static void addNotification(String text, int displaySeconds) {
        notifyQueue.add(new NotifyInfo(text, displaySeconds * 20));
    }

    public static void addNotification(String text) {
        GuiNotifications.addNotification(text, true);
    }

    public boolean onUpdate() {
        NotifyInfo info;
        if (this.tick++ % 10 == 0) {
            DataUtils.forEachMatch(this.notifications, notification -> !notification.isEnabled(), arg_0 -> ((GuiNotifications)this).removeChild(arg_0));
            this.notifications.removeIf(notification -> !notification.isEnabled());
        }
        if (this.downloadsUI.isEnabled()) {
            int offset = this.screenHeight - this.downloadsUI.yPos();
            if (offset != this.yOffset) {
                this.notifications.forEach(notification -> ((Notification)notification).shiftUp(offset - this.yOffset));
                this.yOffset = offset;
            }
        } else if (this.yOffset > 0) {
            this.notifications.forEach(notification -> ((Notification)notification).shiftUp(-this.yOffset));
            this.yOffset = 0;
        }
        if (!(notifyQueue.isEmpty() || this.lastAdded != null && !this.lastAdded.animComplete && this.lastAdded.isEnabled() || (info = notifyQueue.poll()) == null)) {
            Notification newNotify = new Notification(this, info, (int)((double)this.screenWidth * 0.6));
            this.addChild(newNotify);
            int y = this.screenHeight - newNotify.ySize() - 2 - this.yOffset;
            newNotify.setPos(this.screenWidth, y);
            newNotify.targetYPos = y;
            this.notifications.forEach(notification -> ((Notification)notification).shiftUp(newNotify.ySize() + 2));
            this.notifications.add(newNotify);
            this.lastAdded = newNotify;
        }
        return super.onUpdate();
    }

    public void reloadElement() {
        super.reloadElement();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static class NotifyInfo {
        private final String text;
        private final boolean autoClose;
        private int maxAge;

        public NotifyInfo(String text) {
            this(text, true, 600);
        }

        public NotifyInfo(String text, int maxAge) {
            this(text, true, maxAge);
        }

        public NotifyInfo(String text, boolean autoClose) {
            this(text, autoClose, 600);
        }

        public NotifyInfo(String text, boolean autoClose, int maxAge) {
            this.text = text;
            this.autoClose = autoClose;
            this.maxAge = maxAge;
        }
    }

    private static class Notification
    extends MGuiElementBase<Notification> {
        private GuiNotifications parent;
        private final String text;
        private final boolean autoClose;
        private int maxWidth;
        private int targetYPos;
        private int age = 0;
        private int maxAge;
        private boolean animComplete = false;
        private boolean closing = false;

        private Notification(GuiNotifications parent, NotifyInfo info, int maxWidth) {
            this.parent = parent;
            this.text = info.text;
            this.autoClose = info.autoClose;
            this.maxWidth = maxWidth;
            this.maxAge = info.maxAge;
        }

        public void addChildElements() {
            int textWidth = Math.min(this.maxWidth - 14, this.fontRenderer.func_78256_a(this.text));
            GuiLabel label = new GuiLabel(this.text).setTrim(false).setHeightForText(textWidth);
            label.setWrap(true).setShadow(false);
            label.setAlignment(GuiAlign.LEFT);
            this.setSize(label.xSize() + 14, label.ySize() + 6);
            label.setRelPos((MGuiElementBase)this, 3, 3);
            label.setTextColour(windowProps.textColour());
            this.addChild((MGuiElementBase)label);
            GuiButton close = (GuiButton)((GuiButton)new GuiButton().setSize(8, 8)).setHoverText(I18n.func_135052_a((String)"pi.button.close", (Object[])new Object[0]));
            GuiTexture closeTex = new GuiTexture(0, 0, 8, 8, PITextures.PI_PARTS);
            closeTex.setTexSizeOverride(16, 16);
            closeTex.setPreDrawCallback((minecraft, mouseX, mouseY, partialTicks, mouseOver) -> buttonProps.glColour(mouseOver));
            closeTex.setPostDrawCallback(MGuiElementBase.IDrawCallback::resetColour);
            close.addChild((MGuiElementBase)closeTex);
            close.setListener(() -> {
                Notification cfr_ignored_0 = (Notification)this.setEnabled(false);
            });
            close.setPos(this.maxXPos() - 11, this.yPos() + 3);
            this.addChild((MGuiElementBase)close);
            this.targetYPos = this.yPos();
            super.addChildElements();
        }

        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            this.parent.windowRenderer.render(this);
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }

        private void shiftUp(int amount) {
            this.targetYPos -= amount;
        }

        public boolean onUpdate() {
            ++this.age;
            if (this.age > this.maxAge && this.autoClose) {
                this.closing = true;
            }
            if (this.yPos() != this.targetYPos) {
                int newY = Math.round(MathHelper.approachLinear((float)this.yPos(), (float)this.targetYPos, (float)5.0f));
                this.setYPos(newY);
            }
            if (!this.animComplete || this.closing) {
                int target = this.closing ? this.screenWidth + 10 : this.screenWidth - this.xSize() - 5;
                int newX = Math.round(MathHelper.approachLinear((float)this.xPos(), (float)target, (float)30.0f));
                if (newX <= target && !this.closing) {
                    newX = target;
                    this.animComplete = true;
                }
                this.setXPos(newX);
                if (this.closing && this.xPos() > this.screenWidth) {
                    this.setEnabled(false);
                }
            }
            return super.onUpdate();
        }
    }
}

