/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui;

import codechicken.lib.math.MathHelper;
import codechicken.lib.util.ArrayUtils;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiEntityRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiPickColourDialog;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiSelectDialog;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiSlotRender;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiStackIcon;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTextField;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.integration.JeiHelper;
import com.brandon3055.brandonscore.lib.DLRSCache;
import com.brandon3055.brandonscore.lib.DLResourceLocation;
import com.brandon3055.brandonscore.lib.StackReference;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.projectintelligence.client.PITextures;
import com.brandon3055.projectintelligence.client.gui.ContentInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiContentSelect
extends ModularGuiContainer<Container> {
    private GuiScreen parant;
    private Set<ContentInfo.ContentType> allowedTypes;
    private ContentInfo.ContentType selectedType;
    private boolean allowCustomSize = true;
    private boolean allowLinking = true;
    private boolean entityInvalid = false;
    private SelectMode selectMode;
    private final ContentInfo contentInfo;
    private GuiStackIcon stackRenderer;
    private GuiEntityRenderer entityRenderer;
    private GuiTexture imageRenderer;
    private GuiTextField stackString;
    private GuiTextField entityString;
    private GuiTextField itemSizeField;
    private GuiTextField entitySizeField;
    private GuiTextField scaleField;
    private GuiTextField imgURLField;
    private GuiTextField imgWidthField;
    private GuiTextField imgHeightField;
    private Consumer<ContentInfo> selectCallBack;
    private DLResourceLocation imgResource;

    public GuiContentSelect(GuiScreen parent, SelectMode selectMode, @Nullable ContentInfo contentInfo, ContentInfo.ContentType ... selectableTypes) {
        super((Container)new DummyContainer(null));
        this.parant = parent;
        if (selectableTypes.length == 0) {
            throw new RuntimeException("Must specify at least 1 selectable type");
        }
        this.allowedTypes = Sets.newHashSet((Object[])selectableTypes);
        this.selectedType = contentInfo != null && ArrayUtils.contains((Object[])selectableTypes, (Object)((Object)contentInfo.type)) ? contentInfo.type : selectableTypes[0];
        this.contentInfo = contentInfo == null ? new ContentInfo(this.selectedType) : contentInfo;
        this.field_146999_f = 224;
        this.field_147000_g = 230;
        this.selectMode = selectMode;
        if (selectMode == SelectMode.ICON && contentInfo == null) {
            this.contentInfo.drawSlot = true;
        }
    }

    public GuiContentSelect(GuiScreen parent, SelectMode selectMode, ContentInfo.ContentType ... selectableTypes) {
        this(parent, selectMode, (ContentInfo)null, selectableTypes);
    }

    public GuiContentSelect setSelectCallBack(Consumer<ContentInfo> selectCallBack) {
        this.selectCallBack = selectCallBack;
        return this;
    }

    public void addElements(GuiElementManager manager) {
        GuiTexture background = (GuiTexture)GuiTexture.newBCTexture((int)this.field_146999_f, (int)this.field_147000_g).setPos(this.getGuiLeft(), this.getGuiTop());
        manager.add((MGuiElementBase)background);
        if (this.allowedTypes.size() > 1) {
            GuiButton button;
            int nextButtonPos = this.guiLeft() + 5;
            if (this.allowedTypes.contains((Object)ContentInfo.ContentType.ITEM_STACK)) {
                button = (GuiButton)((GuiButton)new GuiButton("Item Stack").setVanillaButtonRender(true).setSize(70, 16)).setPos(nextButtonPos, this.guiTop() + 5);
                manager.add((MGuiElementBase)button);
                button.setToggleMode(true).setToggleStateSupplier(() -> this.selectedType == ContentInfo.ContentType.ITEM_STACK);
                button.setListener(() -> this.changeType(ContentInfo.ContentType.ITEM_STACK));
                nextButtonPos = button.maxXPos() + 2;
            }
            if (this.allowedTypes.contains((Object)ContentInfo.ContentType.ENTITY)) {
                button = (GuiButton)((GuiButton)new GuiButton("Entity").setVanillaButtonRender(true).setSize(70, 16)).setPos(nextButtonPos, this.guiTop() + 5);
                manager.add((MGuiElementBase)button);
                button.setToggleMode(true).setToggleStateSupplier(() -> this.selectedType == ContentInfo.ContentType.ENTITY);
                button.setListener(() -> this.changeType(ContentInfo.ContentType.ENTITY));
                nextButtonPos = button.maxXPos() + 2;
            }
            if (this.allowedTypes.contains((Object)ContentInfo.ContentType.IMAGE)) {
                button = (GuiButton)((GuiButton)new GuiButton("Image").setVanillaButtonRender(true).setSize(70, 16)).setPos(nextButtonPos, this.guiTop() + 5);
                manager.add((MGuiElementBase)button);
                button.setToggleMode(true).setToggleStateSupplier(() -> this.selectedType == ContentInfo.ContentType.IMAGE);
                button.setListener(() -> this.changeType(ContentInfo.ContentType.IMAGE));
            }
            if (this.allowedTypes.contains((Object)ContentInfo.ContentType.FLUID)) {
                button = (GuiButton)((GuiButton)new GuiButton("Fluid").setVanillaButtonRender(true).setSize(70, 16)).setPos(nextButtonPos, this.guiTop() + 5);
                manager.add((MGuiElementBase)button);
                button.setToggleMode(true).setToggleStateSupplier(() -> this.selectedType == ContentInfo.ContentType.FLUID);
                button.setListener(() -> this.changeType(ContentInfo.ContentType.FLUID));
            }
        }
        MGuiElementBase container = new MGuiElementBase().addToGroup(ContentInfo.ContentType.ITEM_STACK.name());
        manager.add(container);
        Consumer<GuiButton> action = guiButton -> {
            this.contentInfo.drawHover = !this.contentInfo.drawHover;
            this.stackRenderer.setToolTip(this.contentInfo.drawHover);
        };
        container.addChild(this.newButton("Draw Vanilla Tool Tip", action, () -> this.contentInfo.drawHover, 0.0).setEnabled(!this.selectMode.isBasic()));
        Consumer<GuiTextField> change = textField -> {
            textField.setText(textField.getText().replace("\\n", "\n"));
            this.contentInfo.hover_text = textField.getText();
            this.stackRenderer.setToolTipOverride(this.contentInfo.hover_text.isEmpty() ? null : Lists.newArrayList((Object[])this.contentInfo.hover_text.split("\n")));
        };
        container.addChild((MGuiElementBase)this.newTextField("Override Vanilla Tool Tip", change, 0.75, 0).setText(this.contentInfo.hover_text)).setEnabled(!this.selectMode.isBasic()).setHoverText("Allows you to specify a custom tool tip for the item. Accepts \\n for new lines and the select character \\\u00a7 for formatting");
        container.addChild(this.newButton("Draw Slot", guiButton -> {
            this.contentInfo.drawSlot = !this.contentInfo.drawSlot;
        }, () -> this.contentInfo.drawSlot, 2.75).setEnabled(!this.selectMode.isBasic()));
        change = textField -> this.itemStackSelected(StackReference.fromString((String)textField.getText()), false);
        this.stackString = this.newTextField("Stack String", change, 4.0, 0).setText(this.contentInfo.stack.toString());
        container.addChild((MGuiElementBase)this.stackString).setHoverText("Format is: " + TextFormatting.GOLD + "registry:name,stackSize,damage,{nbt}");
        this.itemSizeField = this.newSizeField("Size:", guiTextField -> {
            this.contentInfo.size = Math.max(4, Utils.parseInt((String)guiTextField.getText()));
        }, 6.0, 0).setLinkedValue(() -> "" + this.contentInfo.size).setEnabled(this.selectMode.hasSizePos());
        container.addChild((MGuiElementBase)this.itemSizeField);
        this.addInventorySelection(container, this.guiLeft() + (this.xSize() - 206) / 2, this.guiTop() + this.ySize() - 82);
        container.addChild(((GuiLabel)new GuiLabel("Select item from your inventory" + (JeiHelper.jeiAvailable() ? " or JEI" : "")).setTextColour(0).setShadow(false).setAlignment(GuiAlign.LEFT).setWrap(true).setPos(this.guiLeft() + 105, this.guiTop() + 93)).setSize(this.xSize() - 110, 14));
        container.addChild((MGuiElementBase)((GuiButton)((GuiButton)new GuiButton("OK").setSize(40, 14)).setVanillaButtonRender(true).setPos(this.guiLeft() + this.xSize() - 108, this.guiTop() + 128)).setListener((guiButton, pressed) -> this.finished(false)));
        container.addChild((MGuiElementBase)((GuiButton)((GuiButton)new GuiButton("Cancel").setSize(60, 14)).setVanillaButtonRender(true).setPos(this.guiLeft() + this.xSize() - 65, this.guiTop() + 128)).setListener((guiButton, pressed) -> this.finished(true)));
        if (this.selectMode == SelectMode.RELATION) {
            container.addChild((MGuiElementBase)((GuiButton)((GuiButton)new GuiButton("Use Meta").setSize(50, 14)).setTrim(false).setToggleMode(true).setToggleStateSupplier(() -> !this.contentInfo.ignoreMeta).setVanillaButtonRender(true).setPos(this.guiLeft() + 5, this.guiTop() + 128)).setListener((guiButton, pressed) -> {
                this.contentInfo.ignoreMeta = !this.contentInfo.ignoreMeta;
            }));
            container.addChild((MGuiElementBase)((GuiButton)((GuiButton)new GuiButton("Use NBT").setSize(50, 14)).setTrim(false).setToggleMode(true).setToggleStateSupplier(() -> this.contentInfo.includeNBT).setVanillaButtonRender(true).setPos(this.guiLeft() + 57, this.guiTop() + 128)).setListener((guiButton, pressed) -> {
                this.contentInfo.includeNBT = !this.contentInfo.includeNBT;
            }));
        }
        container.addChild((MGuiElementBase)((GuiLabel)((GuiLabel)new GuiLabel("Preview").setSize(200, 12)).setTrim(false).setPos(this.guiLeft() - 205, this.guiTop())).setAlignment(GuiAlign.RIGHT));
        this.stackRenderer = new GuiStackIcon(this.contentInfo.stack);
        ((GuiStackIcon)this.stackRenderer.setXPosMod((guiStackIcon, integer) -> this.guiLeft() - 5 - guiStackIcon.xSize())).setYPos(this.guiTop() + 12);
        this.stackRenderer.setSizeModifiers((guiStackIcon, integer) -> this.contentInfo.size, (guiStackIcon, integer) -> this.contentInfo.size);
        this.stackRenderer.setToolTip(this.contentInfo.drawHover);
        this.stackRenderer.addSlotBackground();
        this.stackRenderer.getBackground().setEnabledCallback(() -> this.contentInfo.drawSlot).setXPosMod((o, o2) -> this.stackRenderer.xPos());
        container.addChild((MGuiElementBase)this.stackRenderer);
        container = new MGuiElementBase().addToGroup(ContentInfo.ContentType.ENTITY.name());
        manager.add(container);
        if (this.selectMode != SelectMode.RELATION) {
            Consumer<GuiTextField> change2 = textField -> {
                if (textField.getText().contains("\n")) {
                    textField.setText(textField.getText().replace("\\n", "\n"));
                }
                this.contentInfo.hover_text = textField.getText();
                this.entityRenderer.setHoverTextArray(element -> this.contentInfo.hover_text.isEmpty() ? new String[]{} : this.contentInfo.hover_text.split("\n"));
            };
            container.addChild((MGuiElementBase)this.newTextField("Hover text", change2, 0.0, 0).setText(this.contentInfo.hover_text)).setHoverText("Allows you to add mouse hover text to this entity. Accepts \\n for new lines and the select character \\\u00a7 for formatting");
            container.addChild((MGuiElementBase)this.newButton("Entity tracks mouse movement", guiButton -> {
                this.contentInfo.trackMouse = !this.contentInfo.trackMouse;
                this.entityRenderer.setTrackMouse(this.contentInfo.trackMouse);
            }, () -> this.contentInfo.trackMouse, 2.0));
            container.addChild((MGuiElementBase)this.newButton("Draw Player Name (for player only)", guiButton -> {
                this.contentInfo.drawName = !this.contentInfo.drawName;
                this.entityRenderer.setDrawName(this.contentInfo.drawName && this.entityString.getText().startsWith("player:"));
            }, () -> this.contentInfo.drawName, 3.0));
            this.entitySizeField = this.newSizeField("Size:", guiTextField -> {
                this.contentInfo.size = Math.max(4, Utils.parseInt((String)guiTextField.getText()));
            }, 4.0, 0).setLinkedValue(() -> "" + this.contentInfo.size).setEnabled(this.selectMode.hasSizePos());
            container.addChild((MGuiElementBase)this.entitySizeField);
            this.scaleField = (GuiTextField)this.newDoubleField("Scale:", value -> {
                this.contentInfo.scale = MathHelper.clip((double)value, (double)0.01, (double)100.0);
            }, 4.0, 115).setLinkedValue(() -> "" + this.contentInfo.scale).setEnabled(this.selectMode.hasSizePos()).setHoverText("Sets the scale of the entity relative to the size of the renderer element (not shown in the preview)");
            container.addChild((MGuiElementBase)this.scaleField);
            container.addChild(this.newIntField("X Offset:", value -> {
                this.contentInfo.xOffset = value;
            }, 5.0, 0).setText("" + this.contentInfo.xOffset).setEnabled(this.selectMode.hasSizePos()).setHoverText("Offsets the rendered x position of an entity.\nUseful for fine tuning an entities position or having an entity render in a completely different part of the gui. (not shown in the preview)"));
            container.addChild(this.newIntField("Y Offset:", value -> {
                this.contentInfo.yOffset = value;
            }, 5.0, 100).setText("" + this.contentInfo.yOffset).setEnabled(this.selectMode.hasSizePos()).setHoverText("Offsets the rendered y position of an entity.\nUseful for fine tuning an entities position or having an entity render in a completely different part of the gui. (not shown in the preview)"));
            Consumer<Integer> rotateChanged = value -> {
                this.contentInfo.rotation = value;
                this.entityRenderer.setLockedRotation((float)this.contentInfo.rotation).rotationLocked(this.contentInfo.rotationSpeed == 0.0);
                this.entityRenderer.setRotationSpeedMultiplier((float)this.contentInfo.rotationSpeed);
            };
            Consumer<Double> speedChanged = value -> {
                this.contentInfo.rotationSpeed = value;
                this.entityRenderer.setLockedRotation((float)this.contentInfo.rotation).rotationLocked(this.contentInfo.rotationSpeed == 0.0);
                this.entityRenderer.setRotationSpeedMultiplier((float)this.contentInfo.rotationSpeed);
            };
            container.addChild(this.newIntField("Rotation:", rotateChanged, 6.0, 2).setText("" + this.contentInfo.rotation).setHoverText("Sets the fixed rotation of the entity if rotate speed is set to 0 (Not compatible with track mouse mode)"));
            container.addChild(this.newDoubleField("Speed:", speedChanged, 6.0, 112).setText("" + this.contentInfo.rotationSpeed).setHoverText("Sets the rotation speed of the entity (Not compatible with track mouse mode)\nThis is a multiplier for the default speed of 20 degrees per second."));
        }
        this.entityString = this.newTextField("Entity String", guiTextField -> this.updateEntity(), 7.0, 0).setText(this.contentInfo.entity);
        container.addChild((MGuiElementBase)this.entityString).setHoverText("Format is: " + TextFormatting.GOLD + "modid:entity_name or player:username\n" + TextFormatting.GRAY + "The entity name must be the entities registry name.");
        if (this.selectMode != SelectMode.RELATION) {
            container.addChild((MGuiElementBase)((GuiLabel)((GuiLabel)new GuiLabel("Entity Inventory (right click to clear slot)").setTextColour(0).setShadow(false).setSize(200, 12)).setTrim(false).setPos(this.guiLeft() + 5, this.guiTop() + 174)).setAlignment(GuiAlign.LEFT));
            this.addEntityInventory(container);
        }
        GuiButton pickEntity = (GuiButton)((GuiButton)new GuiButton("Find Entity").setVanillaButtonRender(true).setSize(95, 14)).setPos(this.guiLeft() + 124, this.guiTop() + 187);
        container.addChild((MGuiElementBase)pickEntity);
        pickEntity.setListener(() -> this.openEntitySelector((MGuiElementBase)pickEntity));
        container.addChild((MGuiElementBase)((GuiButton)((GuiButton)new GuiButton("OK").setSize(40, 14)).setVanillaButtonRender(true).setPos(this.guiLeft() + this.xSize() - 108, this.guiTop() + this.ySize() - 20)).setListener((guiButton, pressed) -> this.finished(false)));
        container.addChild((MGuiElementBase)((GuiButton)((GuiButton)new GuiButton("Cancel").setSize(60, 14)).setVanillaButtonRender(true).setPos(this.guiLeft() + this.xSize() - 65, this.guiTop() + this.ySize() - 20)).setListener((guiButton, pressed) -> this.finished(true)));
        container.addChild((MGuiElementBase)((GuiLabel)((GuiLabel)new GuiLabel("Preview").setSize(200, 12)).setTrim(false).setPos(this.guiLeft() - 205, this.guiTop())).setAlignment(GuiAlign.RIGHT));
        this.entityRenderer = new GuiEntityRenderer();
        this.entityRenderer.setSizeModifiers((guiStackIcon, integer) -> this.contentInfo.size, (guiStackIcon, integer) -> this.contentInfo.size);
        this.entityRenderer.setEntity(new ResourceLocation("minecraft:pig")).setTrackMouse(this.contentInfo.trackMouse);
        ((GuiEntityRenderer)this.entityRenderer.setXPosMod((guiStackIcon, integer) -> this.guiLeft() - 12 - guiStackIcon.xSize())).setYPos(this.guiTop() + 18);
        this.entityRenderer.silentErrors = true;
        this.entityRenderer.setLockedRotation((float)this.contentInfo.rotation).rotationLocked(this.contentInfo.rotationSpeed == 0.0);
        this.entityRenderer.setRotationSpeedMultiplier((float)this.contentInfo.rotationSpeed);
        container.addChild((MGuiElementBase)((GuiLabel)((GuiLabel)((GuiLabel)new GuiLabel(TextFormatting.RED + "Invalid Entity String").setEnabledCallback(() -> this.entityInvalid)).setSize(50, 12)).setWrap(true).setPos(this.guiLeft() - 55, this.guiTop() + 20)).setAlignment(GuiAlign.RIGHT));
        container.addChild((MGuiElementBase)this.entityRenderer);
        container = new MGuiElementBase().addToGroup(ContentInfo.ContentType.IMAGE.name());
        manager.add(container);
        this.imgURLField = this.newTextField("Image URL:", guiTextField -> this.updateImage(), 0.0, 0).setText(this.contentInfo.imageURL);
        container.addChild((MGuiElementBase)this.imgURLField).setHoverText("Currently only accepts http links https is not supported (yet)");
        this.imgWidthField = (GuiTextField)this.newSizeField("Width:", value -> this.setImageSize(Utils.parseInt((String)value.getText()), -1), 2.0, 6).setText("" + this.contentInfo.width).setEnabled(this.selectMode.hasSizePos()).setHoverText("Sets the width of the image. If width is set height will be automatically updated based on the images aspect ratio");
        container.addChild((MGuiElementBase)this.imgWidthField);
        this.imgHeightField = (GuiTextField)this.newSizeField("Height:", value -> this.setImageSize(-1, Utils.parseInt((String)value.getText())), 3.0, 0).setText("" + this.contentInfo.height).setEnabled(this.selectMode.hasSizePos()).setHoverText("Sets the height of the image. If width is set width will be automatically updated based on the images aspect ratio");
        container.addChild((MGuiElementBase)this.imgHeightField);
        GuiButton borderColour = (GuiButton)((GuiButton)((GuiButton)new GuiButton("Border Colour").setPos(this.guiLeft() + 119, this.guiTop() + 62)).setSize(100, 14)).setWrap(true).setVanillaButtonRender(true).setEnabled(this.selectMode.hasSizePos());
        borderColour.setListener(() -> new GuiPickColourDialog((MGuiElementBase)borderColour).setIncludeAlpha(false).setColour(this.contentInfo.borderColour).setCCColourChangeListener(colour -> {
            this.contentInfo.borderColour = colour;
        }).showCenter());
        container.addChild((MGuiElementBase)borderColour);
        GuiButton hoverColour = (GuiButton)((GuiButton)((GuiButton)new GuiButton("Border Hover").setPos(this.guiLeft() + 119, this.guiTop() + 78)).setSize(100, 14)).setWrap(true).setVanillaButtonRender(true).setEnabled(this.selectMode.hasSizePos());
        hoverColour.setListener(() -> new GuiPickColourDialog((MGuiElementBase)hoverColour).setIncludeAlpha(false).setColour(this.contentInfo.borderColourHover).setCCColourChangeListener(colour -> {
            this.contentInfo.borderColourHover = colour;
        }).showCenter());
        container.addChild((MGuiElementBase)hoverColour);
        container.addChild(this.newIntField("Padding:", value -> {
            this.contentInfo.rightPadding = this.contentInfo.padding = value.intValue();
            this.contentInfo.bottomPadding = this.contentInfo.padding;
            this.contentInfo.topPadding = this.contentInfo.padding;
            this.contentInfo.leftPadding = this.contentInfo.padding;
        }, 4.0, 0).setEnabled(this.selectMode.hasSizePos()).setLinkedValue(() -> "" + this.contentInfo.padding).setHoverText("Adds uniform padding (a border) around the image"));
        container.addChild(this.newIntField("Left:", value -> {
            this.contentInfo.leftPadding = value;
            this.contentInfo.padding = 0;
        }, 5.0, 11).setLinkedValue(() -> "" + this.contentInfo.leftPadding).setEnabled(this.selectMode.hasSizePos()).setHoverText("Sets custom padding for the left side of the image"));
        container.addChild(this.newIntField("Top:", value -> {
            this.contentInfo.topPadding = value;
            this.contentInfo.padding = 0;
        }, 5.0, 106).setLinkedValue(() -> "" + this.contentInfo.topPadding).setEnabled(this.selectMode.hasSizePos()).setHoverText("Sets custom padding for the top side of the image"));
        container.addChild(this.newIntField("Bottom:", value -> {
            this.contentInfo.bottomPadding = value;
            this.contentInfo.padding = 0;
        }, 6.0, 0).setLinkedValue(() -> "" + this.contentInfo.bottomPadding).setEnabled(this.selectMode.hasSizePos()).setHoverText("Sets custom padding for the bottom side of the image"));
        container.addChild(this.newIntField("Right:", value -> {
            this.contentInfo.rightPadding = value;
            this.contentInfo.padding = 0;
        }, 6.0, 100).setLinkedValue(() -> "" + this.contentInfo.rightPadding).setEnabled(this.selectMode.hasSizePos()).setHoverText("Sets custom padding for the right side of the image"));
        Consumer<GuiTextField> change3 = textField -> {
            if (textField.getText().contains("\n")) {
                textField.setText(textField.getText().replace("\\n", "\n"));
            }
            this.contentInfo.hover_text = textField.getText();
            this.entityRenderer.setHoverTextArray(element -> this.contentInfo.hover_text.isEmpty() ? new String[]{} : this.contentInfo.hover_text.split("\n"));
        };
        container.addChild((MGuiElementBase)this.newTextField("Hover text", change3, 7.0, 0).setText(this.contentInfo.hover_text)).setHoverText("Allows you to add mouse hover text to this entity. Accepts \\n for new lines and the select character \\\u00a7 for formatting");
        container.addChild((MGuiElementBase)this.newTextField("Link pageURI or web address (optional)", textField -> {
            this.contentInfo.linkTarget = textField.getText();
        }, 9.0, 0).setText(this.contentInfo.hover_text)).setHoverText("Allows you to add a link to be opened when this image is clicked.");
        container.addChild((MGuiElementBase)((GuiLabel)((GuiLabel)((GuiLabel)new GuiLabel("jpg images are preferred due to their smaller file size. Please consider converting your image to jpg format.").setEnabledCallback(() -> this.imgURLField.getText().endsWith(".png"))).setShadow(false).setPos(this.guiLeft() - 60, this.guiTop() + this.ySize() + 5)).setSize(this.xSize() + 120, 20)).setWrap(true).setTextColour(0xFF0000));
        container.addChild((MGuiElementBase)((GuiButton)((GuiButton)new GuiButton("OK").setSize(40, 14)).setVanillaButtonRender(true).setPos(this.guiLeft() + this.xSize() - 108, this.guiTop() + this.ySize() - 20)).setListener((guiButton, pressed) -> this.finished(false)));
        container.addChild((MGuiElementBase)((GuiButton)((GuiButton)new GuiButton("Cancel").setSize(60, 14)).setVanillaButtonRender(true).setPos(this.guiLeft() + this.xSize() - 65, this.guiTop() + this.ySize() - 20)).setListener((guiButton, pressed) -> this.finished(true)));
        this.imageRenderer = new GuiTexture(0, 0, 18, 18, new ResourceLocation(""));
        this.imageRenderer.setTexSizeOverride(18, 18).setTexSheetSize(18);
        ((GuiTexture)this.imageRenderer.setXPosMod((guiStackIcon, integer) -> this.guiLeft() - 5 - guiStackIcon.xSize() - this.contentInfo.rightPadding)).setYPosMod((guiTexture, integer) -> this.guiTop() + this.contentInfo.topPadding);
        GuiBorderedRect imgBack = new GuiBorderedRect();
        imgBack.setBorderColourGetter(hovering -> hovering ? (this.contentInfo.borderColourHover == null ? 0 : this.contentInfo.borderColourHover.argb()) : (this.contentInfo.borderColour == null ? 0 : this.contentInfo.borderColour.argb()));
        ((GuiBorderedRect)imgBack.setXPosMod((guiStackIcon, integer) -> this.guiLeft() - 5 - guiStackIcon.xSize())).setYPosMod((guiTexture, integer) -> this.guiTop());
        imgBack.setSizeModifiers((g, i) -> this.imageRenderer.xSize() + this.contentInfo.leftPadding + this.contentInfo.rightPadding, (g, i) -> this.imageRenderer.ySize() + this.contentInfo.topPadding + this.contentInfo.bottomPadding);
        container.addChild((MGuiElementBase)imgBack);
        imgBack.addChild((MGuiElementBase)this.imageRenderer);
        this.updateImage();
        container = new MGuiElementBase().addToGroup(ContentInfo.ContentType.FLUID.name());
        manager.add(container);
        container.addChild((MGuiElementBase)((GuiButton)((GuiButton)new GuiButton("OK").setSize(40, 14)).setVanillaButtonRender(true).setPos(this.guiLeft() + this.xSize() - 108, this.guiTop() + this.ySize() - 20)).setListener((guiButton, pressed) -> this.finished(false)));
        container.addChild((MGuiElementBase)((GuiButton)((GuiButton)new GuiButton("Cancel").setSize(60, 14)).setVanillaButtonRender(true).setPos(this.guiLeft() + this.xSize() - 65, this.guiTop() + this.ySize() - 20)).setListener((guiButton, pressed) -> this.finished(true)));
        final GuiStackIcon icon = (GuiStackIcon)new GuiStackIcon(new StackReference(ItemStack.field_190927_a)).setSize(32, 32);
        container.addChild((MGuiElementBase)icon);
        icon.setToolTip(false);
        Consumer<String> update = new Consumer<String>(){

            @Override
            public void accept(String s) {
                ItemStack bucket;
                ((GuiContentSelect)GuiContentSelect.this).contentInfo.fluid = s;
                icon.setHoverText(((GuiContentSelect)GuiContentSelect.this).contentInfo.fluid);
                Fluid fluid = FluidRegistry.getFluid((String)((GuiContentSelect)GuiContentSelect.this).contentInfo.fluid);
                if (fluid != null && !(bucket = FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000))).func_190926_b()) {
                    icon.setStack(new StackReference(bucket));
                }
            }
        };
        GuiTextField field = this.newTextField("Fluid Name", textField -> update.accept(textField.getText()), 7.0, 0).setLinkedValue(() -> this.contentInfo.fluid).setText(this.contentInfo.fluid);
        container.addChild((MGuiElementBase)field);
        update.accept(field.getText());
        GuiButton pickFluid = (GuiButton)((GuiButton)new GuiButton("Find Fluid").setVanillaButtonRender(true).setSize(95, 14)).setPos(this.guiLeft() + 124, this.guiTop() + 187);
        container.addChild((MGuiElementBase)pickFluid);
        pickFluid.setListener(() -> this.openFluidSelector((MGuiElementBase)pickFluid, update));
        icon.setPos(this.guiLeft() + 5, pickFluid.yPos());
    }

    public void reloadGui() {
        super.reloadGui();
        this.changeType(this.selectedType);
        this.updateEntity();
    }

    private GuiButton newButton(String label, @Nonnull Consumer<GuiButton> onClick, @Nullable Supplier<Boolean> stateSupplier, double heightIndex) {
        int elementTop = this.guiTop() + 30;
        int spacing = 16;
        GuiButton button = (GuiButton)((GuiButton)new GuiButton(label).setSize(this.xSize() - 10, 14)).setVanillaButtonRender(true).setPos(this.guiLeft() + 5, (int)((double)elementTop + (double)spacing * heightIndex));
        if (stateSupplier != null) {
            button.setToggleMode(true).setToggleStateSupplier(stateSupplier);
        }
        button.setListener(() -> onClick.accept(button));
        return button;
    }

    private GuiTextField newTextField(String label, @Nonnull Consumer<GuiTextField> onChange, double heightIndex, int xOffset) {
        int elementTop = this.guiTop() + 30;
        int spacing = 16;
        GuiLabel fieldLabel = (GuiLabel)new GuiLabel(label).setWrap(false).setTrim(false).setWidthFromText(14).setPos(this.guiLeft() + 5 + xOffset, (int)((double)elementTop + (double)spacing * heightIndex + 3.0));
        fieldLabel.setTextColour(0).setShadow(false);
        GuiTextField textField = new GuiTextField();
        ((GuiTextField)textField.setSize(this.xSize() - 10, 14)).setPos(this.guiLeft() + 5 + xOffset, (int)((double)elementTop + (double)spacing * (heightIndex + 1.0)));
        textField.setListener((event, eventSource) -> onChange.accept(textField));
        textField.addChild((MGuiElementBase)fieldLabel);
        textField.setMaxStringLength(4096);
        return textField;
    }

    private GuiTextField newSizeField(String label, @Nonnull Consumer<GuiTextField> onChange, double heightIndex, int xOffset) {
        int elementTop = this.guiTop() + 30;
        int spacing = 16;
        GuiLabel fieldLabel = (GuiLabel)new GuiLabel(label).setWrap(false).setTrim(false).setWidthFromText(14).setPos(this.guiLeft() + 5 + xOffset, (int)((double)elementTop + (double)spacing * heightIndex));
        fieldLabel.setTextColour(0).setShadow(false);
        GuiTextField textField = new GuiTextField();
        ((GuiTextField)textField.setSize(50, 14)).setPos(fieldLabel.maxXPos() + 2, fieldLabel.yPos());
        textField.setListener((event, eventSource) -> onChange.accept(textField));
        textField.addChild((MGuiElementBase)fieldLabel);
        textField.setMaxStringLength(8);
        GuiButton percent = new GuiButton("%").setToggleMode(true).setToggleStateSupplier(() -> this.contentInfo.sizePercent);
        percent.setListener(() -> {
            this.contentInfo.sizePercent = !this.contentInfo.sizePercent;
            textField.setValidator(s -> s.isEmpty() || Utils.validInteger((String)s));
        });
        ((GuiButton)percent.setSize(20, 14)).setPos(textField.maxXPos() + 2, fieldLabel.yPos());
        percent.setHoverText("If enabled this value becomes a percentage value between 0 and 100 where a value of say 50 would be half of the width of the gui");
        percent.setVanillaButtonRender(true);
        fieldLabel.addChild((MGuiElementBase)percent);
        return textField;
    }

    private GuiTextField newIntField(String label, @Nonnull Consumer<Integer> onChange, double heightIndex, int xOffset) {
        int elementTop = this.guiTop() + 30;
        int spacing = 16;
        GuiLabel fieldLabel = (GuiLabel)new GuiLabel(label).setWrap(false).setTrim(false).setWidthFromText(14).setPos(this.guiLeft() + 5 + xOffset, (int)((double)elementTop + (double)spacing * heightIndex));
        fieldLabel.setTextColour(0).setShadow(false);
        GuiTextField textField = new GuiTextField();
        ((GuiTextField)textField.setSize(50, 14)).setPos(fieldLabel.maxXPos() + 2, fieldLabel.yPos());
        textField.setListener((event, eventSource) -> onChange.accept(Utils.parseInt((String)textField.getText())));
        textField.addChild((MGuiElementBase)fieldLabel);
        textField.setMaxStringLength(8);
        textField.setValidator(s -> s.isEmpty() || Utils.validDouble((String)s));
        return textField;
    }

    private GuiTextField newDoubleField(String label, @Nonnull Consumer<Double> onChange, double heightIndex, int xOffset) {
        int elementTop = this.guiTop() + 30;
        int spacing = 16;
        GuiLabel fieldLabel = (GuiLabel)new GuiLabel(label).setWrap(false).setTrim(false).setWidthFromText(14).setPos(this.guiLeft() + 5 + xOffset, (int)((double)elementTop + (double)spacing * heightIndex));
        fieldLabel.setTextColour(0).setShadow(false);
        GuiTextField textField = new GuiTextField();
        ((GuiTextField)textField.setSize(50, 14)).setPos(fieldLabel.maxXPos() + 2, fieldLabel.yPos());
        textField.setListener((event, eventSource) -> onChange.accept(Utils.parseDouble((String)textField.getText())));
        textField.addChild((MGuiElementBase)fieldLabel);
        textField.setMaxStringLength(8);
        textField.setValidator(s -> s.isEmpty() || Utils.validDouble((String)s));
        return textField;
    }

    private void updateEntity() {
        this.contentInfo.entity = this.entityString.getText();
        this.entityRenderer.setEnabled(true);
        this.entityInvalid = false;
        if (this.contentInfo.entity.startsWith("player:") && !this.contentInfo.entity.replaceFirst("player:", "").isEmpty()) {
            EntityPlayer player = GuiEntityRenderer.createRenderPlayer((World)this.field_146297_k.field_71441_e, (String)this.contentInfo.entity.replaceFirst("player:", ""));
            this.entityRenderer.setEntity((Entity)player);
            this.entityRenderer.setDrawName(this.contentInfo.drawName);
            for (int i = 0; i < 6; ++i) {
                player.func_184201_a(EntityEquipmentSlot.values()[i], this.contentInfo.entityInventory[i > 1 ? 7 - i : i]);
            }
        } else {
            Entity entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(this.contentInfo.entity), (World)this.field_146297_k.field_71441_e);
            if (entity == null) {
                this.entityRenderer.setEnabled(false);
                this.entityInvalid = true;
            } else {
                for (int i = 0; i < 6; ++i) {
                    entity.func_184201_a(EntityEquipmentSlot.values()[i], this.contentInfo.entityInventory[i > 1 ? 7 - i : i]);
                }
                this.entityRenderer.setEntity(entity);
                this.entityRenderer.setDrawName(false);
            }
        }
    }

    private void setImageSize(int width, int height) {
        this.contentInfo.width = width;
        this.contentInfo.height = height;
        if (width == -1) {
            this.imgWidthField.setText("-1");
        } else if (height == -1) {
            this.imgHeightField.setText("-1");
        }
        this.updateImage();
    }

    private void updateImage() {
        this.contentInfo.imageURL = this.imgURLField.getText();
        this.imgResource = DLRSCache.getResource((String)this.contentInfo.imageURL);
        this.imageRenderer.setTexture((ResourceLocation)this.imgResource);
        if (this.contentInfo.width != -1) {
            this.imageRenderer.setSize(this.contentInfo.width, (int)((double)this.imgResource.height / (double)this.imgResource.width * (double)this.contentInfo.width));
        } else if (this.contentInfo.height != -1) {
            this.imageRenderer.setSize((int)((double)this.imgResource.width / (double)this.imgResource.height * (double)this.contentInfo.height), this.contentInfo.height);
        }
    }

    private void openEntitySelector(MGuiElementBase parent) {
        GuiSelectDialog selector = new GuiSelectDialog(parent);
        ((GuiSelectDialog)((GuiSelectDialog)selector.setSize(134, 200)).setInsets(1, 1, 12, 1)).setCloseOnSelection(true);
        selector.addChild((MGuiElementBase)((GuiBorderedRect)new GuiBorderedRect().setPosAndSize((MGuiElementBase)selector)).setColours(-1, -16777216));
        selector.setRendererBuilder(s -> {
            MGuiElementBase base = new GuiBorderedRect().setColours(-16777216, -9408400).setSize(130, 40);
            base.addChild((MGuiElementBase)((GuiEntityRenderer)new GuiEntityRenderer().setTrackMouse(true).setForce2dSize(true).setPosAndSize(7, 11, 24, 24)).setEntity(new ResourceLocation(s)).setSilentErrors(true));
            base.addChild((MGuiElementBase)((GuiLabel)new GuiLabel(s).setShadow(false).setPosAndSize(35, 0, 85, 40)).setWrap(true));
            return base;
        });
        GuiTextField filter = new GuiTextField();
        selector.addChild((MGuiElementBase)filter);
        ((GuiTextField)filter.setSize(selector.xSize(), 14)).setPos(selector.xPos(), selector.maxYPos() - 12);
        Runnable reload = () -> {
            selector.clearItems();
            String filterText = filter.getText();
            for (EntityList.EntityEggInfo info : EntityList.field_75627_a.values()) {
                String id = info.field_75613_a.toString();
                if (!filterText.isEmpty() && !id.contains(filterText)) continue;
                selector.addItem((Object)id);
            }
        };
        reload.run();
        filter.setListener((event1, eventSource1) -> reload.run());
        selector.showCenter();
        selector.getScrollElement().setListSpacing(1).reloadElement();
        selector.setSelectionListener(s -> {
            this.entityString.setText(s);
            this.updateEntity();
        });
    }

    private void openFluidSelector(MGuiElementBase parent, Consumer<String> update) {
        GuiSelectDialog selector = new GuiSelectDialog(parent);
        ((GuiSelectDialog)((GuiSelectDialog)selector.setSize(134, 200)).setInsets(1, 1, 12, 1)).setCloseOnSelection(true);
        selector.addChild((MGuiElementBase)((GuiBorderedRect)new GuiBorderedRect().setPosAndSize((MGuiElementBase)selector)).setColours(-1, -16777216));
        selector.setRendererBuilder(s -> {
            ItemStack bucket;
            MGuiElementBase base = new GuiBorderedRect().setColours(-16777216, -9408400).setSize(130, 20);
            Fluid fluid = FluidRegistry.getFluid((String)s);
            if (fluid != null && !(bucket = FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000))).func_190926_b()) {
                base.addChild(new GuiStackIcon(new StackReference(bucket)).setPosAndSize(2, 1, 18, 18));
            }
            base.addChild((MGuiElementBase)((GuiLabel)new GuiLabel(s).setShadow(false).setPosAndSize(20, 0, 85, 20)).setWrap(true));
            return base;
        });
        GuiTextField filter = new GuiTextField();
        selector.addChild((MGuiElementBase)filter);
        ((GuiTextField)filter.setSize(selector.xSize(), 14)).setPos(selector.xPos(), selector.maxYPos() - 12);
        Runnable reload = () -> {
            selector.clearItems();
            String filterText = filter.getText();
            for (String fluid : FluidRegistry.getRegisteredFluids().keySet()) {
                if (!filterText.isEmpty() && !fluid.contains(filterText)) continue;
                selector.addItem((Object)fluid);
            }
        };
        reload.run();
        filter.setListener((event1, eventSource1) -> reload.run());
        selector.showCenter();
        selector.getScrollElement().setListSpacing(1).reloadElement();
        selector.setSelectionListener(s -> {
            this.contentInfo.fluid = s;
            update.accept((String)s);
        });
    }

    private void addInventorySelection(MGuiElementBase parent, int invX, int invY) {
        GuiSlotRender slot;
        InventoryPlayer inv = Minecraft.func_71410_x().field_71439_g.field_71071_by;
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 4; ++y) {
                int xPos = invX + x * 18 + (x > 0 ? 4 : 0);
                int yPos = invY + y * 18 + (x > 0 && y == 3 ? 4 : 0);
                ItemStack stack = x == 0 ? inv.func_70440_f(3 - y) : (y == 3 ? inv.func_70301_a(x - 1) : inv.func_70301_a(x - 1 + 9 * (y + 1)));
                slot = (GuiSlotRender)new GuiSlotRender().setPos(xPos, yPos);
                if (!stack.func_190926_b()) {
                    slot.addChild(new GuiStackIcon(new StackReference(stack)).setPos((MGuiElementBase)slot));
                    slot.addChild((MGuiElementBase)((GuiButton)new GuiButton().setPosAndSize((MGuiElementBase)slot)).setListener(() -> this.itemStackSelected(new StackReference(stack), true)));
                }
                parent.addChild((MGuiElementBase)slot);
            }
        }
        slot = (GuiSlotRender)new GuiSlotRender().setPos(invX + 188, this.guiTop() + this.ySize() - 24);
        parent.addChild((MGuiElementBase)slot);
        if (!((ItemStack)inv.field_184439_c.get(0)).func_190926_b()) {
            slot.addChild(new GuiStackIcon(new StackReference((ItemStack)inv.field_184439_c.get(0))).setPos((MGuiElementBase)slot));
            slot.addChild((MGuiElementBase)((GuiButton)new GuiButton().setPosAndSize((MGuiElementBase)slot)).setListener(() -> this.itemStackSelected(new StackReference((ItemStack)inv.field_184439_c.get(0)), true)));
        }
    }

    private void addEntityInventory(MGuiElementBase container) {
        for (int i = 0; i < 6; ++i) {
            int slotIndex = i;
            GuiSlotRender slot = new GuiSlotRender();
            ((GuiSlotRender)slot.setPos(this.guiLeft() + 5 + i * 18 + (i > 1 ? 8 : (i > 0 ? 4 : 0)), this.guiTop() + 187)).setSize(18, 18);
            container.addChild((MGuiElementBase)slot);
            slot.addChild(((GuiTexture)new GuiTexture(96 + i * 16, 0, 16, 16, PITextures.PI_PARTS).setRelPos((MGuiElementBase)slot, 1, 1)).setEnabledCallback(() -> this.contentInfo.entityInventory[slotIndex].func_190926_b()));
            ItemStack stack = this.contentInfo.entityInventory[i];
            GuiStackIcon stackIcon = (GuiStackIcon)new GuiStackIcon(new StackReference(stack)).setPos((MGuiElementBase)slot);
            stackIcon.setEnabledCallback(() -> !this.contentInfo.entityInventory[slotIndex].func_190926_b());
            slot.addChild((MGuiElementBase)stackIcon);
            GuiButton button = (GuiButton)new GuiButton().setPosAndSize((MGuiElementBase)slot);
            slot.addChild((MGuiElementBase)button);
            button.setListener((guiButton, pressed) -> {
                if (pressed == 1) {
                    this.contentInfo.entityInventory[slotIndex] = ItemStack.field_190927_a;
                    stackIcon.setStack(new StackReference(ItemStack.field_190927_a));
                    this.updateEntity();
                } else {
                    GuiContentSelect gui = new GuiContentSelect((GuiScreen)this, SelectMode.PICK_STACK, ContentInfo.ContentType.ITEM_STACK);
                    gui.setSelectCallBack(content -> {
                        if (content == null) {
                            return;
                        }
                        this.contentInfo.entityInventory[slotIndex] = content.stack.createStack();
                        stackIcon.setStack(content.stack);
                        this.updateEntity();
                    });
                    gui.contentInfo.stack = new StackReference(this.contentInfo.entityInventory[slotIndex]);
                    this.field_146297_k.func_147108_a((GuiScreen)gui);
                }
            });
        }
    }

    private void finished(boolean cancel) {
        if (this.selectCallBack != null) {
            this.selectCallBack.accept(cancel ? null : this.contentInfo);
        }
        this.field_146297_k.func_147108_a(this.parant);
    }

    public void changeType(ContentInfo.ContentType type) {
        this.manager.setGroupEnabled(ContentInfo.ContentType.ITEM_STACK.name(), type == ContentInfo.ContentType.ITEM_STACK);
        this.manager.setGroupEnabled(ContentInfo.ContentType.ENTITY.name(), type == ContentInfo.ContentType.ENTITY);
        this.manager.setGroupEnabled(ContentInfo.ContentType.IMAGE.name(), type == ContentInfo.ContentType.IMAGE);
        this.manager.setGroupEnabled(ContentInfo.ContentType.FLUID.name(), type == ContentInfo.ContentType.FLUID);
        this.selectedType = type;
        this.contentInfo.type = type;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.imgResource != null && this.imgResource.dlStateChanged()) {
            this.updateImage();
        }
    }

    public void func_146269_k() throws IOException {
        if (Mouse.isCreated()) {
            while (Mouse.next()) {
                boolean jeiItemClicked;
                this.mouseHandled = false;
                ItemStack itemUnderMouse = JeiHelper.getPanelItemUnderMouse();
                boolean bl = jeiItemClicked = itemUnderMouse != null && Mouse.getEventButtonState();
                if (!jeiItemClicked && MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.MouseInputEvent.Pre((GuiScreen)this))) continue;
                this.func_146274_d();
                if (((Object)((Object)this)).equals(this.field_146297_k.field_71462_r) && !this.mouseHandled) {
                    MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.MouseInputEvent.Post((GuiScreen)this));
                }
                if (this.mouseHandled || !jeiItemClicked) continue;
                this.itemStackSelected(new StackReference(itemUnderMouse), true);
            }
        }
        if (Keyboard.isCreated()) {
            while (Keyboard.next()) {
                this.keyHandled = false;
                if (MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.KeyboardInputEvent.Pre((GuiScreen)this))) continue;
                this.func_146282_l();
                if (!((Object)((Object)this)).equals(this.field_146297_k.field_71462_r) || this.keyHandled) continue;
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.KeyboardInputEvent.Post((GuiScreen)this));
            }
        }
    }

    public void itemStackSelected(StackReference itemStack, boolean updateStackField) {
        if (this.selectedType == ContentInfo.ContentType.ITEM_STACK) {
            if (itemStack == null) {
                itemStack = new StackReference(ItemStack.field_190927_a);
            }
            this.contentInfo.stack = itemStack;
            this.stackRenderer.setToolTipOverride(this.contentInfo.hover_text.isEmpty() ? null : Lists.newArrayList((Object[])this.contentInfo.hover_text.split("\n")));
            this.stackRenderer.setStack(this.contentInfo.stack);
            if (updateStackField) {
                this.stackString.setText(itemStack.toString());
                this.stackString.setCursorPositionZero();
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (keyCode == 28) {
            this.finished(false);
        }
    }

    public static class DummyContainer
    extends Container {
        public DummyContainer(EntityPlayer player) {
        }

        public boolean func_75145_c(EntityPlayer playerIn) {
            return true;
        }

        public void func_75141_a(int slotID, ItemStack stack) {
        }

        public void func_190896_a(List<ItemStack> stacks) {
        }

        public void func_75137_b(int id, int data) {
        }
    }

    public static enum SelectMode {
        ICON(false, true),
        RELATION(false, false),
        MD_CONTENT(true, true),
        PICK_STACK(false, false);

        private final boolean hasSize;
        private final boolean customizations;

        private SelectMode(boolean hasSize, boolean customizations) {
            this.hasSize = hasSize;
            this.customizations = customizations;
        }

        public boolean hasSizePos() {
            return this.hasSize;
        }

        public boolean isBasic() {
            return !this.customizations;
        }
    }
}

