/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import java.math.BigInteger;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="projecte")
public class ToolTipEvent {
    @SubscribeEvent
    public static void tTipEvent(ItemTooltipEvent event) {
        long value;
        ItemStack current = event.getItemStack();
        if (current.func_190926_b()) {
            return;
        }
        Item currentItem = current.func_77973_b();
        Block currentBlock = Block.func_149634_a((Item)currentItem);
        EntityPlayerSP clientPlayer = Minecraft.func_71410_x().field_71439_g;
        if (ProjectEConfig.misc.pedestalToolTips && currentItem instanceof IPedestalItem) {
            event.getToolTip().add(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"pe.pedestal.on_pedestal", (Object[])new Object[0]) + " ");
            Object description = ((IPedestalItem)currentItem).getPedestalDescription();
            if (description.isEmpty()) {
                event.getToolTip().add(IPedestalItem.TOOLTIPDISABLED);
            } else {
                event.getToolTip().addAll(((IPedestalItem)currentItem).getPedestalDescription());
            }
        }
        if (ProjectEConfig.misc.odToolTips) {
            for (int id : OreDictionary.getOreIDs((ItemStack)current)) {
                event.getToolTip().add("OD: " + OreDictionary.getOreName((int)id));
            }
            if (currentBlock instanceof BlockFluidBase) {
                event.getToolTip().add("Fluid: " + ((BlockFluidBase)currentBlock).getFluid().getName());
            }
        }
        if (ProjectEConfig.misc.emcToolTips && EMCHelper.doesItemHaveEmc(current)) {
            value = EMCHelper.getEmcValue(current);
            event.getToolTip().add(TextFormatting.YELLOW + I18n.func_135052_a((String)"pe.emc.emc_tooltip_prefix", (Object[])new Object[0]) + " " + TextFormatting.WHITE + Constants.EMC_FORMATTER.format(value) + TextFormatting.BLUE + EMCHelper.getEmcSellString(current, 1));
            if (current.func_190916_E() > 1) {
                event.getToolTip().add(TextFormatting.YELLOW + I18n.func_135052_a((String)"pe.emc.stackemc_tooltip_prefix", (Object[])new Object[0]) + " " + TextFormatting.WHITE + Constants.EMC_FORMATTER.format(BigInteger.valueOf(value).multiply(BigInteger.valueOf(current.func_190916_E()))) + TextFormatting.BLUE + EMCHelper.getEmcSellString(current, current.func_190916_E()));
            }
            if (GuiScreen.func_146272_n() && clientPlayer != null && ((IKnowledgeProvider)clientPlayer.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY, null)).hasKnowledge(current)) {
                event.getToolTip().add(TextFormatting.YELLOW + I18n.func_135052_a((String)"pe.emc.has_knowledge", (Object[])new Object[0]));
            }
        }
        if (ProjectEConfig.misc.statToolTips) {
            String unit = I18n.func_135052_a((String)"pe.emc.name", (Object[])new Object[0]);
            String rate = I18n.func_135052_a((String)"pe.emc.rate", (Object[])new Object[0]);
            if (currentBlock == ObjHandler.collectorMK1) {
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxgenrate_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + rate, 4L));
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxstorage_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + unit, 10000L));
            }
            if (currentBlock == ObjHandler.collectorMK2) {
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxgenrate_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + rate, 12L));
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxstorage_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + unit, 30000L));
            }
            if (currentBlock == ObjHandler.collectorMK3) {
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxgenrate_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + rate, 40L));
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxstorage_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + unit, 60000L));
            }
            if (currentBlock == ObjHandler.relay) {
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxoutrate_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + rate, 64L));
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxstorage_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + unit, 100000L));
            }
            if (currentBlock == ObjHandler.relayMK2) {
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxoutrate_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + rate, 192L));
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxstorage_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + unit, 1000000L));
            }
            if (currentBlock == ObjHandler.relayMK3) {
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxoutrate_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + rate, 640L));
                event.getToolTip().add(TextFormatting.DARK_PURPLE + String.format(I18n.func_135052_a((String)"pe.emc.maxstorage_tooltip", (Object[])new Object[0]) + TextFormatting.BLUE + " %d " + unit, 10000000L));
            }
        }
        if (current.func_77942_o() && (current.func_77973_b() instanceof IItemEmc || current.func_77978_p().func_74764_b("StoredEMC"))) {
            value = current.func_77978_p().func_74764_b("StoredEMC") ? current.func_77978_p().func_74763_f("StoredEMC") : ((IItemEmc)current.func_77973_b()).getStoredEmc(current);
            event.getToolTip().add(TextFormatting.YELLOW + I18n.func_135052_a((String)"pe.emc.storedemc_tooltip", (Object[])new Object[0]) + " " + TextFormatting.RESET + Constants.EMC_FORMATTER.format(value));
        }
    }
}

