/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.fluids.FluidStack;
import openblocks.Config;
import openblocks.client.renderer.tileentity.tank.ITankRenderFluidData;
import openblocks.common.tileentity.TileEntityTank;
import openmods.utils.Diagonal;
import openmods.utils.TextureUtils;

public class TileEntityTankRenderer
extends FastTESR<TileEntityTank> {
    public void renderTileEntityFast(TileEntityTank tankTile, double x, double y, double z, float partialTicks, int destroyStage, float alpha, BufferBuilder buffer) {
        if (tankTile.func_145837_r()) {
            return;
        }
        ITankRenderFluidData data = tankTile.getRenderFluidData();
        if (data != null && data.hasFluid()) {
            buffer.func_178969_c(x, y, z);
            World world = tankTile.func_145831_w();
            float time = (float)world.func_82737_E() + partialTicks;
            int selfLightLevel = Config.tanksEmitLight ? tankTile.getFluidLightLevel() : 0;
            int combinedLights = world.func_175626_b(tankTile.func_174877_v(), selfLightLevel);
            TileEntityTankRenderer.renderFluid(buffer, data, time, combinedLights);
            buffer.func_178969_c(0.0, 0.0, 0.0);
        }
    }

    private static void addVertex(BufferBuilder wr, double x, double y, double z, double u, double v, int r, int g, int b, int a, int skyLight, int blockLight) {
        wr.func_181662_b(x, y, z).func_181669_b(r, g, b, a).func_187315_a(u, v).func_187314_a(skyLight, blockLight).func_181675_d();
    }

    private static void renderFluid(BufferBuilder wr, ITankRenderFluidData data, float time, int combinedLights) {
        int skyLight = combinedLights >> 16 & 0xFFFF;
        int blockLight = combinedLights >> 0 & 0xFFFF;
        double se = data.getCornerFluidLevel(Diagonal.SE, time);
        double ne = data.getCornerFluidLevel(Diagonal.NE, time);
        double sw = data.getCornerFluidLevel(Diagonal.SW, time);
        double nw = data.getCornerFluidLevel(Diagonal.NW, time);
        double center = data.getCenterFluidLevel(time);
        FluidStack fluid = data.getFluid();
        TextureAtlasSprite texture = TextureUtils.getFluidTexture((FluidStack)fluid);
        int color = fluid.getFluid().getColor(fluid);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        int a = color >> 24 & 0xFF;
        double uMin = texture.func_94209_e();
        double uMax = texture.func_94212_f();
        double vMin = texture.func_94206_g();
        double vMax = texture.func_94210_h();
        double vHeight = vMax - vMin;
        if (data.shouldRenderFluidWall(EnumFacing.NORTH) && (nw > 0.0 || ne > 0.0)) {
            TileEntityTankRenderer.addVertex(wr, 1.0, 0.0, 0.0, uMax, vMin, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 1.0, ne, 0.0, uMax, vMin + vHeight * ne, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 0.0, nw, 0.0, uMin, vMin + vHeight * nw, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 0.0, 0.0, 0.0, uMin, vMin, r, g, b, a, skyLight, blockLight);
        }
        if (data.shouldRenderFluidWall(EnumFacing.SOUTH) && (se > 0.0 || sw > 0.0)) {
            TileEntityTankRenderer.addVertex(wr, 1.0, 0.0, 1.0, uMin, vMin, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 1.0, se, 1.0, uMin, vMin + vHeight * se, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 0.0, sw, 1.0, uMax, vMin + vHeight * sw, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 0.0, 0.0, 1.0, uMax, vMin, r, g, b, a, skyLight, blockLight);
        }
        if (data.shouldRenderFluidWall(EnumFacing.EAST) && (ne > 0.0 || se > 0.0)) {
            TileEntityTankRenderer.addVertex(wr, 1.0, 0.0, 0.0, uMin, vMin, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 1.0, ne, 0.0, uMin, vMin + vHeight * ne, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 1.0, se, 1.0, uMax, vMin + vHeight * se, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 1.0, 0.0, 1.0, uMax, vMin, r, g, b, a, skyLight, blockLight);
        }
        if (data.shouldRenderFluidWall(EnumFacing.WEST) && (sw > 0.0 || nw > 0.0)) {
            TileEntityTankRenderer.addVertex(wr, 0.0, 0.0, 1.0, uMin, vMin, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 0.0, sw, 1.0, uMin, vMin + vHeight * sw, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 0.0, nw, 0.0, uMax, vMin + vHeight * nw, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 0.0, 0.0, 0.0, uMax, vMin, r, g, b, a, skyLight, blockLight);
        }
        if (data.shouldRenderFluidWall(EnumFacing.UP)) {
            double uMid = (uMax + uMin) / 2.0;
            double vMid = (vMax + vMin) / 2.0;
            TileEntityTankRenderer.addVertex(wr, 0.5, center, 0.5, uMid, vMid, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 1.0, se, 1.0, uMax, vMin, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 1.0, ne, 0.0, uMin, vMin, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 0.0, nw, 0.0, uMin, vMax, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 0.0, sw, 1.0, uMax, vMax, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 1.0, se, 1.0, uMax, vMin, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 0.5, center, 0.5, uMid, vMid, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 0.0, nw, 0.0, uMin, vMax, r, g, b, a, skyLight, blockLight);
        }
        if (data.shouldRenderFluidWall(EnumFacing.DOWN)) {
            TileEntityTankRenderer.addVertex(wr, 1.0, 0.0, 0.0, uMax, vMin, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 1.0, 0.0, 1.0, uMin, vMin, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 0.0, 0.0, 1.0, uMin, vMax, r, g, b, a, skyLight, blockLight);
            TileEntityTankRenderer.addVertex(wr, 0.0, 0.0, 0.0, uMax, vMax, r, g, b, a, skyLight, blockLight);
        }
    }
}

