/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.jei;

import appeng.client.gui.implementations.GuiCraftingTerm;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerCraftingTerm;
import appeng.container.slot.SlotCraftingMatrix;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketJEIRecipe;
import appeng.util.Platform;
import com.github.vfyjxf.nee.config.KeyBindings;
import com.github.vfyjxf.nee.helper.CraftingHelper;
import com.github.vfyjxf.nee.helper.IngredientRequester;
import com.github.vfyjxf.nee.helper.RecipeAnalyzer;
import com.github.vfyjxf.nee.jei.CraftingInfoError;
import com.github.vfyjxf.nee.utils.GuiUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.IItemHandler;
import p455w0rd.wct.init.ModNetworking;
import p455w0rd.wct.sync.WCTPacket;

public class CraftingTransferHandler<C extends AEBaseContainer>
implements IRecipeTransferHandler<C> {
    private final Class<C> containerClass;
    private final IngredientRequester requester;
    private static boolean isPatternInterfaceExists = false;
    public static final int RECIPE_LENGTH = 9;

    public CraftingTransferHandler(Class<C> containerClass) {
        this.containerClass = containerClass;
        this.requester = IngredientRequester.getInstance();
    }

    @Nonnull
    public Class<C> getContainerClass() {
        return this.containerClass;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@Nonnull C container, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        GuiScreen parent = GuiUtils.getParentScreen();
        if (parent != null && GuiUtils.isCraftingTerm(parent)) {
            GuiContainer craftingTerm = (GuiContainer)parent;
            if (doTransfer) {
                boolean preview = KeyBindings.isPreviewKeyDown();
                boolean nonPreview = KeyBindings.isNonPreviewKeyDown();
                if (preview || nonPreview) {
                    RecipeAnalyzer analyzer = this.createAnalyzer(parent);
                    if (analyzer == null) {
                        return null;
                    }
                    this.requester.setRequested(false, nonPreview, this.initAnalyzer(analyzer, craftingTerm, recipeLayout, player).analyzeRecipe(recipeLayout));
                    this.requester.requestNext();
                } else {
                    this.moveItems((AEBaseContainer)container, recipeLayout);
                }
            } else {
                RecipeAnalyzer analyzer = this.createAnalyzer(parent);
                if (analyzer == null) {
                    return null;
                }
                return new CraftingInfoError(this.initAnalyzer(analyzer, craftingTerm, recipeLayout, player), true);
            }
        }
        return null;
    }

    private RecipeAnalyzer initAnalyzer(@Nonnull RecipeAnalyzer analyzer, @Nonnull GuiContainer craftingTerm, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player) {
        IItemHandler craftMatrix = CraftingHelper.getCraftMatrix(craftingTerm);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (craftMatrix != null) {
            stacks.addAll(CraftingHelper.copyAllNonEmpty(craftMatrix));
        }
        if (player.field_71071_by != null) {
            stacks.addAll(CraftingHelper.copyAllNonEmpty((IInventory)player.field_71071_by));
        }
        stacks.forEach(analyzer::addAvailableIngredient);
        return analyzer;
    }

    private RecipeAnalyzer createAnalyzer(@Nonnull GuiScreen screen) {
        if (screen instanceof GuiCraftingTerm) {
            return new RecipeAnalyzer((GuiCraftingTerm)screen);
        }
        if (Loader.isModLoaded((String)"wct")) {
            return this.createAnalyzer((GuiContainer)screen);
        }
        return null;
    }

    @Optional.Method(modid="wct")
    private RecipeAnalyzer createAnalyzer(@Nonnull GuiContainer wirelessTerm) {
        return new RecipeAnalyzer(wirelessTerm);
    }

    private void moveItems(AEBaseContainer container, IRecipeLayout recipeLayout) {
        Map ingredients = recipeLayout.getItemStacks().getGuiIngredients();
        NBTTagCompound recipe = new NBTTagCompound();
        int slotIndex = 0;
        for (Map.Entry ingredientEntry : ingredients.entrySet()) {
            IGuiIngredient ingredient = (IGuiIngredient)ingredientEntry.getValue();
            if (!ingredient.isInput()) continue;
            for (Slot slot : container.field_75151_b) {
                if (!(slot instanceof SlotCraftingMatrix) && !(slot instanceof SlotFakeCraftingMatrix) || slot.getSlotIndex() != slotIndex) continue;
                NBTTagList tags = new NBTTagList();
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                ItemStack displayed = (ItemStack)ingredient.getDisplayedIngredient();
                if (displayed != null && !displayed.func_190926_b()) {
                    list.add(displayed);
                }
                for (ItemStack stack : ingredient.getAllIngredients()) {
                    if (Platform.isRecipePrioritized((ItemStack)stack)) {
                        list.add(0, stack);
                        continue;
                    }
                    list.add(stack);
                }
                for (ItemStack is : list) {
                    NBTTagCompound tag = new NBTTagCompound();
                    is.func_77955_b(tag);
                    tags.func_74742_a((NBTBase)tag);
                }
                recipe.func_74782_a("#" + slot.getSlotIndex(), (NBTBase)tags);
                break;
            }
            ++slotIndex;
        }
        try {
            if (container instanceof ContainerCraftingTerm) {
                NetworkHandler.instance().sendToServer((AppEngPacket)new PacketJEIRecipe(recipe));
            } else if (GuiUtils.isWirelessCraftingTermContainer(container)) {
                this.moveItemsForWirelessTerm(recipe);
            }
        }
        catch (IOException e) {
            AELog.debug((Throwable)e);
        }
    }

    @Optional.Method(modid="wct")
    private void moveItemsForWirelessTerm(NBTTagCompound recipe) {
        try {
            ModNetworking.instance().sendToServer((WCTPacket)new p455w0rd.wct.sync.packets.PacketJEIRecipe(recipe));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isIsPatternInterfaceExists() {
        return isPatternInterfaceExists;
    }

    public static void setIsPatternInterfaceExists(boolean isPatternInterfaceExists) {
        CraftingTransferHandler.isPatternInterfaceExists = isPatternInterfaceExists;
    }
}

