/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.items.armor;

import com.blakebr0.cucumber.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.World;

public enum ArmorType implements IStringSerializable
{
    ABSORPTION(0, "absorption"){

        @Override
        public void getSpecialAbility(World world, EntityPlayer player) {
            if (player.func_70660_b(MobEffects.field_76444_x) == null) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 9600, 4, true, false));
            }
        }
    }
    ,
    WITHER_RESISTANCE(1, "wither_resistance"){

        @Override
        public void getSpecialAbility(World world, EntityPlayer player) {
            player.func_184589_d(MobEffects.field_82731_v);
        }
    }
    ,
    ANTIVENOM(2, "antivenom"){

        @Override
        public void getSpecialAbility(World world, EntityPlayer player) {
            player.func_184589_d(MobEffects.field_76436_u);
        }
    }
    ,
    FIRE_RESISTANCE(3, "fire_resistance"){

        @Override
        public void getSpecialAbility(World world, EntityPlayer player) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 5, 0, true, false));
            player.func_70066_B();
        }
    }
    ,
    RESISTANCE(4, "resistance"){

        @Override
        public void getSpecialAbility(World world, EntityPlayer player) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 5, 0, true, false));
        }
    }
    ,
    NIGHT_VISION(5, "night_vision"){

        @Override
        public void getSpecialAbility(World world, EntityPlayer player) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 240, 0, true, false));
        }
    }
    ,
    STRENGTH(6, "strength"){

        @Override
        public void getSpecialAbility(World world, EntityPlayer player) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 5, 0, true, false));
        }
    }
    ,
    SPEED(7, "speed"),
    JUMP(8, "jump"){

        @Override
        public void getSpecialAbility(World world, EntityPlayer player) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 5, 3, true, false));
        }
    };

    public static final String ARMOR_TYPE = "ArmorType";
    private static final ArmorType[] META_LOOKUP;
    private final int index;
    private final String name;

    private ArmorType(int index, String name) {
        this.index = index;
        this.name = name;
    }

    public int getIndex() {
        return this.index;
    }

    public String func_176610_l() {
        return this.name;
    }

    public String getLocalizedName() {
        return Utils.localize((String)("tooltip.ma." + this.func_176610_l()));
    }

    public void getSpecialAbility(World world, EntityPlayer player) {
    }

    public static ArmorType byIndex(int index) {
        if (index < 0 || index >= META_LOOKUP.length) {
            index = 0;
        }
        return META_LOOKUP[index];
    }

    static {
        META_LOOKUP = new ArmorType[ArmorType.values().length];
        ArmorType[] armorTypeArray = ArmorType.values();
        int n = armorTypeArray.length;
        for (int i = 0; i < n; ++i) {
            ArmorType type;
            ArmorType.META_LOOKUP[type.getIndex()] = type = armorTypeArray[i];
        }
    }
}

